/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FilenameSignature;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;
import javassist.bytecode.ClassFile;

public class DynamicLights
extends Mod {
    boolean versionAbove18;

    public DynamicLights(MinecraftVersion minecraftVersion) {
        this.name = "Dynamic Lights";
        this.author = "Cryect, AtomicStryker";
        this.description = "Adds dynamic Light to Minecraft";
        this.website = "http://www.minecraftforum.net/topic/184426-v19-pre5-dynamic-lights/";
        this.version = "1.3";
        this.addConflict("Dynamic Lights (Optifine version)");
        this.classMods.add(new AABBPoolMod());
        this.classMods.add(new AxisAlignedBBMod());
        this.classMods.add(new BlockMod());
        this.classMods.add(new ChunkMod());
        this.classMods.add(new ChunkCacheMod());
        this.classMods.add(new EntityMod());
        this.classMods.add(new EntityClientPlayerMP());
        this.classMods.add(new EntityItemMod());
        this.classMods.add(new EntityLivingMod());
        this.classMods.add(new EntityPlayerMod());
        this.classMods.add(new EntityPlayerSPMod());
        this.classMods.add(new EntityRendererMod());
        this.classMods.add(new EnumSkyBlockMod());
        this.classMods.add(new GuiIngameMod());
        this.classMods.add(new ItemStackMod());
        this.classMods.add(new InventoryPlayerMod());
        this.classMods.add(new MinecraftMod());
        this.classMods.add(new RenderGlobalMod());
        this.classMods.add(new WorldMod());
        this.classMods.add(new WorldClientMod());
        this.classMods.add(new WorldInfoMod());
        this.classMods.add(new WorldRendererMod());
        this.filesToAdd.add(ClassMap.classNameToFilename((String)"BlockCoord"));
        this.filesToAdd.add(ClassMap.classNameToFilename((String)"DynamicLights"));
        this.filesToAdd.add(ClassMap.classNameToFilename((String)"EnumLight"));
        this.filesToAdd.add(ClassMap.classNameToFilename((String)"LightCache"));
        this.filesToAdd.add(ClassMap.classNameToFilename((String)"PlayerTorch"));
        this.filesToAdd.add(ClassMap.classNameToFilename((String)"PlayerTorchArray"));
    }

    private class WorldRendererMod
    extends ClassMod {
        public WorldRendererMod() {
            this.classSignatures.add(new ConstSignature((Object)new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.push(-999)});
                }
            });
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "setupGLTranslation", "()V"), new MethodRef(this.getDeobfClass(), "updateRenderer", "()V")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "isInFrustum", "Z"), new FieldRef(this.getDeobfClass(), "needsUpdate", "Z")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "isInitialized", "Z")}).accessFlag(2, true).accessFlag(8, false));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "reset LightCache and Blockpool in updateRenderer";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("WorldRenderer", "updateRenderer", "()V"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{42, 4, this.reference(181, (JavaRef)new FieldRef("WorldRenderer", "isInitialized", "Z"))});
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(178, (JavaRef)new FieldRef("LightCache", "cache", "LLightCache;")), this.reference(182, (JavaRef)new MethodRef("LightCache", "clear", "()V")), this.reference(184, (JavaRef)new MethodRef("BlockCoord", "resetPool", "()V"))});
                }
            });
        }
    }

    private class WorldInfoMod
    extends ClassMod {
        public WorldInfoMod() {
            this.classSignatures.add(new ConstSignature((Object)"RandomSeed"));
            this.classSignatures.add(new ConstSignature((Object)"SpawnX"));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getRandomSeed", "()J"), new MethodRef(this.getDeobfClass(), "getWorldTime", "()J")}));
        }
    }

    private class WorldClientMod
    extends ClassMod {
        WorldClientMod() {
            this.classSignatures.add(new ConstSignature((Object)"MpServer"));
            this.classSignatures.add(new ConstSignature((Object)"Quitting"));
        }
    }

    private class WorldMod
    extends ClassMod {
        WorldMod() {
            this.classSignatures.add(new ConstSignature((Object)"ambient.cave.cave"));
            this.classSignatures.add(new ConstSignature((Object)" Chunk Stats"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "worldInfo", "LWorldInfo;")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "playSoundAtEntity", "(LEntity;Ljava.lang.String;FF)V")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "markBlocksDirty", "(IIIIII)V")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "setEntityDead", "()V")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getBlockId", "(III)I")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "loadedEntityList", "Ljava.util.List;"), new FieldRef(this.getDeobfClass(), "loadedTileEntityList", "Ljava.util.List;")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getBlockId", "(III)I"), new MethodRef(this.getDeobfClass(), "getBlockMetadata", "(III)I"), new MethodRef(this.getDeobfClass(), "getFullBlockLightValue", "(III)I"), new MethodRef(this.getDeobfClass(), "getBlockLightValue", "(III)I")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "markBlockNeedsUpdate", "(III)V"), new MethodRef(this.getDeobfClass(), "markBlockAsNeedsUpdate", "(III)V"), new MethodRef(this.getDeobfClass(), "removeBlockTileEntity", "(III)V"), new MethodRef(this.getDeobfClass(), "updateAllLightTypes", "(III)V"), new MethodRef(this.getDeobfClass(), "randomDisplayUpdates", "(III)V")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getBlockId", "(III)I")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getWorldSeed", "()J"), new MethodRef(this.getDeobfClass(), "getWorldTime", "()J")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getSkyBlockTypeBrightness", "(LEnumSkyBlock;III)I"), new MethodRef(this.getDeobfClass(), "getSavedLightValue", "(LEnumSkyBlock;III)I")}).accessFlag(1, true).accessFlag(8, false));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override getSkyBlockTypeBrightness return";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("World", "getSkyBlockTypeBrightness", "(LEnumSkyBlock;III)I"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{58, 7, 25, 7, 43, 28, 16, 15, 126, 29, 21, 4, 16, 15, 126, this.reference(182, (JavaRef)new MethodRef("Chunk", "getSavedLightValue", "(LEnumSkyBlock;III)I")), 172});
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{58, 7, 25, 7, 25, 1, 21, 2, 16, 15, 126, 21, 3, 21, 4, 16, 15, 126, this.reference(182, (JavaRef)new MethodRef("Chunk", "getSavedLightValue", "(LEnumSkyBlock;III)I")), 25, 0, 25, 1, 21, 2, 21, 3, 21, 4, this.reference(184, (JavaRef)new MethodRef("PlayerTorchArray", "getBlockTorchBrightness", "(ILWorld;LEnumSkyBlock;III)I")), 172});
                }
            });
        }

        public void prePatch(String filename, ClassFile classFile) {
            this.mod.getClassMap().addInheritance(this.getDeobfClass(), "WorldClient");
        }
    }

    private class RenderGlobalMod
    extends ClassMod {
        RenderGlobalMod() {
            this.classSignatures.add(new ConstSignature((Object)"smoke"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.push("/environment/clouds.png")});
                }
            }.setMethodName("renderClouds"));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "updateRenderers", "(LEntityLiving;Z)Z")}));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "add FPS check to updateRenderers beginning";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("RenderGlobal", "updateRenderers", "(LEntityLiving;Z)Z"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{BinaryRegex.begin()});
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{3, 54, 18, 9, 55, 19, this.reference(184, (JavaRef)new MethodRef("PlayerTorchArray", "AreTorchesActive", "()Z")), 54, 17, 21, 17, 153, RenderGlobalMod.this.branch("L4"), this.reference(184, (JavaRef)new MethodRef("AABBPool", "getAvgFrameTime", "()J")), 55, 19, RenderGlobalMod.this.label("L4")});
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "add FPS check/break to end of FOR render loop";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("RenderGlobal", "updateRenderers", "(LEntityLiving;Z)Z"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{BinaryRegex.capture((String)BinaryRegex.build((Object[])new Object[]{1, this.reference(185, (JavaRef)new InterfaceMethodRef("java/util/List", "set", "(ILjava/lang/Object;)Ljava/lang/Object;")), 87})), BinaryRegex.capture((String)BinaryRegex.build((Object[])new Object[]{132, BinaryRegex.any((int)2), 167})), BinaryRegex.capture((String)BinaryRegex.build((Object[])new Object[]{BinaryRegex.any((int)2)}))});
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    byte[] b = this.getCaptureGroup(3);
                    int offset = b[0] << 8 | b[1];
                    this.getMethodInfo().getCodeAttribute().setMaxLocals(this.getMethodInfo().getCodeAttribute().getMaxLocals() + 5);
                    return this.buildCode(new Object[]{this.getCaptureGroup(1), 21, 17, 153, RenderGlobalMod.this.branch("skip"), 132, 18, 1, 21, 18, 5, 162, RenderGlobalMod.this.branch("break"), 22, 19, this.push(16666666L), 148, 158, RenderGlobalMod.this.branch("skip"), 167, RenderGlobalMod.this.branch("break"), RenderGlobalMod.this.label("skip"), this.getCaptureGroup(2), (offset -= 26) >> 8, offset & 0xFF, RenderGlobalMod.this.label("break")});
                }
            });
        }
    }

    private class MinecraftMod
    extends ClassMod {
        public MinecraftMod() {
            this.classSignatures.add(new FilenameSignature("net/minecraft/client/Minecraft.class"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "thePlayer", "LEntityClientPlayerMP;")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "theWorld", "LWorldClient;")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getAppDir", "(Ljava/lang/String;)Ljava/io/File;")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "ingameGUI", "LGuiIngame;")}));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "Dynamic Lights init in Minecraft";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.push("Post startup")});
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{42, this.reference(184, (JavaRef)new MethodRef("DynamicLights", "init", "(LMinecraft;)V"))});
                }
            });
        }
    }

    private class ItemStackMod
    extends ClassMod {
        public ItemStackMod() {
            this.classSignatures.add(new ConstSignature((Object)"id"));
            this.classSignatures.add(new ConstSignature((Object)"Count"));
            this.classSignatures.add(new ConstSignature((Object)"Damage"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "stackSize", "I"), new FieldRef(this.getDeobfClass(), "animationsToGo", "I"), new FieldRef(this.getDeobfClass(), "itemID", "I")}).accessFlag(1, true));
        }
    }

    private class InventoryPlayerMod
    extends ClassMod {
        public InventoryPlayerMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{42, this.push(36), 189, BinaryRegex.any((int)2), 181, BinaryRegex.any((int)2), 42, 7, 189, BinaryRegex.any((int)2), 181, BinaryRegex.any((int)2)});
                }
            });
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getStackInSlot", "(I)LItemStack;"), new MethodRef(this.getDeobfClass(), "armorItemInSlot", "(I)LItemStack;")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getCurrentItem", "()LItemStack;")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "currentItem", "I")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "setInventorySlotContents", "(ILItemStack;)V")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "mainInventory", "[LItemStack;"), new FieldRef(this.getDeobfClass(), "armorInventory", "[LItemStack;")}).accessFlag(1, true).accessFlag(8, false));
        }
    }

    private class GuiIngameMod
    extends ClassMod {
        public GuiIngameMod() {
            this.classSignatures.add(new ConstSignature((Object)"/gui/gui.png"));
            this.classSignatures.add(new ConstSignature((Object)"/gui/icons.png"));
            this.classSignatures.add(new ConstSignature((Object)"Used memory: "));
            this.classSignatures.add(new ConstSignature((Object)"Allocated memory: "));
        }
    }

    private class EnumSkyBlockMod
    extends ClassMod {
        public EnumSkyBlockMod() {
            this.classSignatures.add(new ConstSignature((Object)"Sky"));
            this.classSignatures.add(new ConstSignature((Object)"Block"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "Sky", "LEnumSkyBlock;"), new FieldRef(this.getDeobfClass(), "Block", "LEnumSkyBlock;")}));
        }
    }

    private class EntityRendererMod
    extends ClassMod {
        public EntityRendererMod() {
            this.classSignatures.add(new ConstSignature((Object)"/terrain.png"));
            this.classSignatures.add(new ConstSignature((Object)"ambient.weather.rain"));
            this.classSignatures.add(new ConstSignature((Object)"/environment/snow.png"));
            this.classSignatures.add(new ConstSignature((Object)"/environment/rain.png"));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getMouseOver", "(F)V"), new MethodRef(this.getDeobfClass(), "updateCameraAndRender", "(F)V")}).accessFlag(1, true).accessFlag(8, false));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "add Dynamic Lights OnTick Hook";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("EntityRenderer", "updateCameraAndRender", "(F)V"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{BinaryRegex.begin()});
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, (JavaRef)new MethodRef("DynamicLights", "OnTickInGame", "()V"))});
                }
            });
        }
    }

    private class EntityPlayerSPMod
    extends ClassMod {
        public EntityPlayerSPMod() {
            this.parentClass = "EntityPlayer";
            this.classSignatures.add(new ConstSignature((Object)"http://skins.minecraft.net/MinecraftSkins/"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.push("portal.trigger")});
                }
            }.setMethodName("onLivingUpdate"));
        }

        public void prePatch(String filename, ClassFile classFile) {
            this.mod.getClassMap().addInheritance(this.getDeobfClass(), "EntityClientPlayerMP");
        }
    }

    private class EntityPlayerMod
    extends ClassMod {
        public EntityPlayerMod() {
            this.parentClass = "EntityLiving";
            this.classSignatures.add(new ConstSignature((Object)"humanoid"));
            this.classSignatures.add(new ConstSignature((Object)"/mob/char.png"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "inventory", "LInventoryPlayer;")}));
        }
    }

    private class EntityLivingMod
    extends ClassMod {
        public EntityLivingMod() {
            this.parentClass = "Entity";
            this.classSignatures.add(new ConstSignature((Object)"ActiveEffects"));
            this.classSignatures.add(new ConstSignature((Object)"Health"));
            this.classSignatures.add(new ConstSignature((Object)"HurtTime"));
        }

        public void prePatch(String filename, ClassFile classFile) {
            this.mod.getClassMap().addInheritance(this.getDeobfClass(), "EntityPlayer");
            this.mod.getClassMap().addInheritance(this.getDeobfClass(), "EntityPlayerSP");
        }
    }

    private class EntityItemMod
    extends ClassMod {
        public EntityItemMod() {
            this.classSignatures.add(new ConstSignature((Object)"Health"));
            this.classSignatures.add(new ConstSignature((Object)"Age"));
            this.classSignatures.add(new ConstSignature((Object)"Item"));
            this.classSignatures.add(new ConstSignature((Object)"random.pop"));
            this.classSignatures.add(new ConstSignature((Object)"random.fizz"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "item", "LItemStack;")}));
        }
    }

    private class EntityClientPlayerMP
    extends ClassMod {
        public EntityClientPlayerMP() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{187, BinaryRegex.any((int)2), 89, 42, 180, BinaryRegex.any((int)2), this.push(-999.0), this.push(-999.0), 42, 180, BinaryRegex.any((int)2), 42, 180, BinaryRegex.any((int)2), 183, BinaryRegex.any((int)2), 182, BinaryRegex.any((int)2)});
                }
            });
        }
    }

    private class EntityMod
    extends ClassMod {
        public EntityMod() {
            this.classSignatures.add(new ConstSignature((Object)"Pos"));
            this.classSignatures.add(new ConstSignature((Object)"Motion"));
            this.classSignatures.add(new ConstSignature((Object)"Rotation"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "worldObj", "LWorld;")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "renderDistanceWeight", "D"), new FieldRef(this.getDeobfClass(), "prevPosX", "D"), new FieldRef(this.getDeobfClass(), "prevPosY", "D"), new FieldRef(this.getDeobfClass(), "prevPosZ", "D"), new FieldRef(this.getDeobfClass(), "posX", "D"), new FieldRef(this.getDeobfClass(), "posY", "D"), new FieldRef(this.getDeobfClass(), "posZ", "D")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "isWet", "()Z"), new MethodRef(this.getDeobfClass(), "isInWater", "()Z"), null, null, null, null, null, new MethodRef(this.getDeobfClass(), "isEntityAlive", "()Z"), null, new MethodRef(this.getDeobfClass(), "isEntityBurning", "()Z")}).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "setEntityDead", "()V"), new MethodRef(this.getDeobfClass(), "onUpdate", "()V"), new MethodRef(this.getDeobfClass(), "onEntityUpdate", "()V")}).accessFlag(1, true).accessFlag(8, false).accessFlag(1024, false).accessFlag(4, false));
        }

        public void prePatch(String filename, ClassFile classFile) {
            this.mod.getClassMap().addInheritance(this.getDeobfClass(), "EntityPlayer");
            this.mod.getClassMap().addInheritance(this.getDeobfClass(), "EntityPlayerSP");
        }
    }

    private class ChunkCacheMod
    extends ClassMod {
        ChunkCacheMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{100, 4, 96, 197, BinaryRegex.any((int)3), 181, BinaryRegex.any((int)2), BinaryRegex.optional((String)this.buildExpression(new Object[]{42, 4, 181, BinaryRegex.any((int)2)})), 42, 180, BinaryRegex.any((int)2), 54, 10, 21, 10, 21, 8, 163});
                }
            });
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "chunkArray", "[[LChunk;")}));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "worldObj", "LWorld;")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getSkyBlockTypeBrightness", "(LEnumSkyBlock;III)I"), new MethodRef(this.getDeobfClass(), "getSpecialBlockBrightness", "(LEnumSkyBlock;III)I")}).accessFlag(1, true).accessFlag(8, false));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override getSkyBlockTypeBrightness return";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("ChunkCache", "getSkyBlockTypeBrightness", "(LEnumSkyBlock;III)I"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{42, this.reference(180, (JavaRef)new FieldRef("ChunkCache", "chunkArray", "[[LChunk;")), 21, 5, 50, 21, 6, 50, 43, 28, 16, 15, 126, 29, 21, 4, 16, 15, 126, this.reference(182, (JavaRef)new MethodRef("Chunk", "getSavedLightValue", "(LEnumSkyBlock;III)I")), 172});
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{42, this.reference(180, (JavaRef)new FieldRef("ChunkCache", "chunkArray", "[[LChunk;")), 21, 5, 50, 21, 6, 50, 43, 28, 16, 15, 126, 29, 21, 4, 16, 15, 126, this.reference(182, (JavaRef)new MethodRef("Chunk", "getSavedLightValue", "(LEnumSkyBlock;III)I")), 42, this.reference(180, (JavaRef)new FieldRef("ChunkCache", "worldObj", "LWorld;")), 43, 28, 29, 21, 4, this.reference(184, (JavaRef)new MethodRef("PlayerTorchArray", "getBlockTorchBrightness", "(ILWorld;LEnumSkyBlock;III)I")), 172});
                }
            });
        }
    }

    private class ChunkMod
    extends ClassMod {
        public ChunkMod() {
            this.classSignatures.add(new ConstSignature((Object)"Wrong location! "));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "getSavedLightValue", "(LEnumSkyBlock;III)I")}));
        }
    }

    private class BlockMod
    extends ClassMod {
        public BlockMod() {
            this.classSignatures.add(new ConstSignature((Object)" is already occupied by "));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef[]{new FieldRef(this.getDeobfClass(), "blocksList", "[LBlock;")}));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "renderAsNormalBlock", "()Z")}).accessFlag(1, true).accessFlag(8, false));
        }
    }

    private class AxisAlignedBBMod
    extends ClassMod {
        AxisAlignedBBMod() {
            this.classSignatures.add(new ConstSignature((Object)"box["));
            this.classSignatures.add(new ConstSignature((Object)" -> "));
            this.classSignatures.add(new ConstSignature((Object)"]"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{BinaryRegex.begin(), 178, BinaryRegex.any((int)2), 182, BinaryRegex.any((int)2), BytecodeMatcher.captureReference((int)192), 176});
                }
            }.addXref(1, (JavaRef)new ClassRef("AABBPool")));
        }
    }

    private class AABBPoolMod
    extends ClassMod {
        AABBPoolMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{187, BinaryRegex.any((int)2), 89, 39, 41, 24, BinaryRegex.any((int)1), 24, BinaryRegex.any((int)1), 24, BinaryRegex.any((int)1), 24, BinaryRegex.any((int)1)});
                }
            });
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{42, 180, BinaryRegex.any((int)2), 42, 180, BinaryRegex.any((int)2), this.reference(185, (JavaRef)new InterfaceMethodRef("java/util/List", "size", "()I")), 42, 180, BinaryRegex.any((int)2), 100, this.reference(184, (JavaRef)new MethodRef("java/lang/Math", "max", "(II)I")), 60, 42, 180, BinaryRegex.any((int)2), this.reference(185, (JavaRef)new InterfaceMethodRef("java/util/List", "size", "()I")), 27, 164, BinaryRegex.any((int)2), 42, 180, BinaryRegex.any((int)2), 27, this.reference(185, (JavaRef)new InterfaceMethodRef("java/util/List", "remove", "(I)Ljava/lang/Object;")), 87});
                }
            });
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef[]{new MethodRef(this.getDeobfClass(), "cleanPool", "()V"), new MethodRef(this.getDeobfClass(), "clearPool", "()V")}).accessFlag(1, true));
            this.patches.add(new AddFieldPatch("nextFrameTime", "I", 9));
            this.patches.add(new AddFieldPatch("prevFrameTimeForAvg", "J", 9));
            this.patches.add(new AddFieldPatch("tFrameTimes", "[J", 9));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "add AABBPool FPS watcher";
                }

                public String getMatchExpression() {
                    JavaRef actionPerformed = DynamicLights.this.classMap.map((JavaRef)new MethodRef("AABBPool", "clearPool", "()V"));
                    if (this.getMethodInfo().getName().equals(actionPerformed.getName()) && this.getMethodInfo().getDescriptor().equals(actionPerformed.getType())) {
                        return this.buildExpression(new Object[]{BinaryRegex.begin()});
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, (JavaRef)new MethodRef("java/lang/System", "nanoTime", "()J")), this.reference(179, (JavaRef)new FieldRef("AABBPool", "prevFrameTimeForAvg", "J")), this.reference(178, (JavaRef)new FieldRef("AABBPool", "tFrameTimes", "[J")), this.reference(178, (JavaRef)new FieldRef("AABBPool", "nextFrameTime", "I")), this.reference(178, (JavaRef)new FieldRef("AABBPool", "prevFrameTimeForAvg", "J")), 80, this.reference(178, (JavaRef)new FieldRef("AABBPool", "nextFrameTime", "I")), 4, 96, 16, 60, 112, this.reference(179, (JavaRef)new FieldRef("AABBPool", "nextFrameTime", "I"))});
                }
            });
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "<clinit>", "()V")){

                public byte[] generateMethod() throws IOException {
                    this.maxStackSize = 4;
                    this.numLocals = 1;
                    this.getMethodInfo().setAccessFlags(9);
                    return this.buildCode(new Object[]{3, this.reference(179, (JavaRef)new FieldRef("AABBPool", "nextFrameTime", "I")), 9, this.reference(179, (JavaRef)new FieldRef("AABBPool", "prevFrameTimeForAvg", "J")), this.push(60), 188, 11, this.reference(179, (JavaRef)new FieldRef("AABBPool", "tFrameTimes", "[J")), 177});
                }
            });
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "getAvgFrameTime", "()J")){

                public byte[] generateMethod() throws IOException {
                    this.maxStackSize = 4;
                    this.numLocals = 1;
                    this.getMethodInfo().setAccessFlags(9);
                    return this.buildCode(new Object[]{this.reference(178, (JavaRef)new FieldRef("AABBPool", "tFrameTimes", "[J")), this.reference(178, (JavaRef)new FieldRef("AABBPool", "nextFrameTime", "I")), 47, 9, 148, 153, AABBPoolMod.this.branch("L2"), this.reference(178, (JavaRef)new FieldRef("AABBPool", "prevFrameTimeForAvg", "J")), this.reference(178, (JavaRef)new FieldRef("AABBPool", "tFrameTimes", "[J")), this.reference(178, (JavaRef)new FieldRef("AABBPool", "nextFrameTime", "I")), 47, 101, this.push(60L), 109, 173, AABBPoolMod.this.label("L2"), this.push(23333333L), 173});
                }
            });
        }
    }
}

