/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

final class BlockCoord {
    public int x;
    public int y;
    public int z;
    private static List<BlockCoord> blockCoords = new ArrayList<BlockCoord>();
    public static int numBlockCoordsInUse = 0;

    public BlockCoord(int i, int j, int k) {
        this.x = i;
        this.y = j;
        this.z = k;
    }

    public static BlockCoord getFromPool(int i, int j, int k) {
        if (numBlockCoordsInUse - blockCoords.size() >= 0) {
            blockCoords.add(new BlockCoord(i, j, k));
        }
        return blockCoords.get(numBlockCoordsInUse++).set(i, j, k);
    }

    public static void resetPool() {
        numBlockCoordsInUse = 0;
    }

    public static void releaseLastOne() {
        --numBlockCoordsInUse;
    }

    public BlockCoord set(int i, int j, int k) {
        this.x = i;
        this.y = j;
        this.z = k;
        return this;
    }

    public boolean isEqual(int i, int j, int k) {
        return this.x == i && this.y == j && this.z == k;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlockCoord) {
            BlockCoord otherCoord = (BlockCoord)obj;
            return this.x == otherCoord.x && this.y == otherCoord.y && this.z == otherCoord.z;
        }
        return false;
    }

    public int hashCode() {
        return this.x << 16 ^ this.z ^ this.y << 24;
    }
}

