/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick.util;

import com.matejdro.bukkit.portalstick.PortalStick;
import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.util.Config;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Util {
    private static final Logger log = Logger.getLogger("Minecraft");
    private static int maxLength = 105;

    public static void info(String msg) {
        log.info("[PortalStick] " + msg);
    }

    public static void severe(String msg) {
        log.severe("[PortalStick] " + msg);
    }

    public static void sendMessage(CommandSender player, String msg) {
        CustomColor lastColor = CustomColor.WHITE;
        for (String line : msg.split("`n")) {
            int i = 0;
            while (i < line.length()) {
                String part = Util.getMaxString(line.substring(i));
                if (i + part.length() < line.length() && part.contains(" ")) {
                    part = part.substring(0, part.lastIndexOf(" "));
                }
                part = lastColor.getCustom() + part;
                player.sendMessage(Util.replaceColors(part));
                lastColor = Util.getLastColor(part);
                i = i + part.length() - 1;
            }
        }
    }

    public static Location getSimpleLocation(Location location) {
        location.setX((double)Math.round(location.getX() * 10.0) / 10.0);
        location.setY((double)Math.round(location.getY() * 10.0) / 10.0);
        location.setZ((double)Math.round(location.getZ() * 10.0) / 10.0);
        return location;
    }

    public static String stripColors(String str) {
        str = str.replaceAll("(?i)\u00a7[0-F]", "");
        str = str.replaceAll("(?i)&[0-F]", "");
        return str;
    }

    public static CustomColor getLastColor(String str) {
        CustomColor lastColor = CustomColor.WHITE;
        for (int i = 0; i < str.length() - 2; i += 2) {
            for (CustomColor color : CustomColor.values()) {
                if (!str.substring(i, i + 2).equalsIgnoreCase(color.getCustom())) continue;
                lastColor = color;
            }
        }
        return lastColor;
    }

    public static String replaceColors(String str) {
        for (CustomColor color : CustomColor.values()) {
            str = str.replace(color.getCustom(), color.getString());
        }
        return str;
    }

    private static String getMaxString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Util.stripColors(str.substring(0, i)).length() != maxLength) continue;
            if (Util.stripColors(str.substring(i, i + 1)) == "") {
                return str.substring(0, i - 1);
            }
            return str.substring(0, i);
        }
        return str;
    }

    public static void PlayNote(final Player player, final byte instrument, final byte note) {
        final Block block = player.getLocation().getBlock().getRelative(0, -5, 0);
        final Byte data = block.getData();
        final Material material = block.getType();
        Region region = RegionManager.getRegion(player.getLocation());
        if (!region.getBoolean(RegionSetting.ENABLE_SOUNDS)) {
            return;
        }
        player.sendBlockChange(block.getLocation(), Material.NOTE_BLOCK, instrument);
        PortalStick.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)PortalStick.instance, new Runnable(){

            @Override
            public void run() {
                player.playNote(block.getLocation(), instrument, note);
                player.sendBlockChange(block.getLocation(), material, data.byteValue());
            }
        }, 1L);
    }

    public static void PlaySound(Config.Sound sound, Player player, Location loc) {
        if (!RegionManager.getRegion(loc).getBoolean(RegionSetting.ENABLE_SOUNDS)) {
            return;
        }
        Plugin spoutPlugin = PortalStick.instance.getServer().getPluginManager().getPlugin("Spout");
        if (!(spoutPlugin != null && Config.useBukkitContribSounds.booleanValue() || player == null || Config.soundNotes[sound.ordinal()].trim().equals(""))) {
            Byte instrument = Byte.parseByte(Config.soundNotes[sound.ordinal()].split("-")[0]);
            Byte note = Byte.parseByte(Config.soundNotes[sound.ordinal()].split("-")[1]);
            Util.PlayNote(player, instrument, note);
        }
    }

    public static int getLeftPortalColor(int preset) {
        String p = Config.ColorPresets.get(preset);
        return Integer.parseInt(p.split("-")[0]);
    }

    public static int getRightPortalColor(int preset) {
        String p = Config.ColorPresets.get(preset);
        return Integer.parseInt(p.split("-")[1]);
    }

    public static ItemStack getItemData(String itemString) {
        String[] split = itemString.split(",");
        int num = split.length < 2 ? 1 : Integer.parseInt(split[1]);
        String[] split2 = split[0].split(":");
        short data = split2.length < 2 ? (short)0 : Short.parseShort(split2[1]);
        int id = Integer.parseInt(split2[0]);
        return new ItemStack(id, num, data);
    }

    private static enum CustomColor {
        RED("c", 12),
        DARK_RED("4", 4),
        YELLOW("e", 14),
        GOLD("6", 6),
        GREEN("a", 10),
        DARK_GREEN("2", 2),
        AQUA("b", 11),
        DARK_AQUA("8", 8),
        BLUE("9", 9),
        DARK_BLUE("1", 1),
        LIGHT_PURPLE("d", 13),
        DARK_PURPLE("5", 5),
        BLACK("0", 0),
        DARK_GRAY("8", 8),
        GRAY("7", 7),
        WHITE("f", 15);

        private String custom;
        private int code;

        private CustomColor(String custom, int code) {
            this.custom = custom;
            this.code = code;
        }

        public String getCustom() {
            return "&" + this.custom;
        }

        public String getString() {
            return String.format("\u00a7%x", this.code);
        }
    }
}

