/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick.util;

import com.matejdro.bukkit.portalstick.Bridge;
import com.matejdro.bukkit.portalstick.FunnelBridgeManager;
import com.matejdro.bukkit.portalstick.Grill;
import com.matejdro.bukkit.portalstick.GrillManager;
import com.matejdro.bukkit.portalstick.PortalManager;
import com.matejdro.bukkit.portalstick.PortalStick;
import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.User;
import com.matejdro.bukkit.portalstick.UserManager;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import com.matejdro.bukkit.portalstick.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Config {
    public static PortalStick plugin;
    private static FileConfiguration mainConfig;
    private static FileConfiguration regionConfig;
    private static FileConfiguration grillConfig;
    private static FileConfiguration bridgeConfig;
    private static File mainConfigFile;
    private static File regionConfigFile;
    private static File grillConfigFile;
    private static File bridgeConfigFile;
    public static HashSet<String> DisabledWorlds;
    public static boolean DeleteOnQuit;
    public static int PortalTool;
    public static boolean CompactPortal;
    public static Region GlobalRegion;
    public static int RegionTool;
    public static boolean RestoreInvOnWorldChange;
    public static List<String> ColorPresets;
    public static int FillPortalBack;
    public static String MessageCannotPlacePortal;
    public static Boolean useBukkitContribSounds;
    public static int soundRange;
    public static String[] soundUrls;
    public static String[] soundNotes;

    public Config(PortalStick instance) {
        plugin = instance;
        mainConfigFile = Config.getConfigFile("config.yml");
        regionConfigFile = Config.getConfigFile("regions.yml");
        grillConfigFile = Config.getConfigFile("grills.yml");
        bridgeConfigFile = Config.getConfigFile("bridges.yml");
        mainConfig = Config.getConfig(mainConfigFile);
        regionConfig = Config.getConfig(regionConfigFile);
        grillConfig = Config.getConfig(grillConfigFile);
        bridgeConfig = Config.getConfig(bridgeConfigFile);
        Config.load();
    }

    public static void deleteGrill(String grill) {
        List list = grillConfig.getStringList("grills");
        list.remove(grill);
        grillConfig.set("grills", (Object)list);
        Config.saveAll();
    }

    public static void deleteRegion(String name) {
        regionConfig.set("regions." + name, null);
        Config.saveAll();
    }

    public static void deleteBridge(String bridge) {
        List list = bridgeConfig.getList("bridges", null);
        list.remove(bridge);
        bridgeConfig.set("bridges", (Object)list);
        Config.saveAll();
    }

    public static void load() {
        try {
            mainConfig.load(mainConfigFile);
            regionConfig.load(regionConfigFile);
            grillConfig.load(grillConfigFile);
            bridgeConfig.load(bridgeConfigFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        MessageCannotPlacePortal = Config.getString("messages.cannot-place-portal", "&cCannot place a portal there!");
        DisabledWorlds = new HashSet<String>(Config.getStringList("main.disabled-worlds", new ArrayList<String>()));
        DeleteOnQuit = Config.getBoolean("main.delete-on-quit", false);
        PortalTool = Config.getInt("main.portal-tool", 280);
        CompactPortal = Config.getBoolean("main.compact-portal", false);
        RegionTool = Config.getInt("main.region-tool", 268);
        RestoreInvOnWorldChange = Config.getBoolean("main.restore-inventory-on-world-change", true);
        ColorPresets = Config.getStringList("main.portal-color-presets", Arrays.asList("11-1", "2-6", "9-10", "5-13", "8-7", "15-4"));
        FillPortalBack = Config.getInt("main.fill-portal-back", -1);
        useBukkitContribSounds = Config.getBoolean("sounds.use-bukkitcontrib-sounds", true);
        soundRange = Config.getInt("sounds.sound-range", 20);
        Config.soundUrls[Sound.PORTAL_CREATE_BLUE.ordinal()] = Config.getString("sounds.create-blue-portal-url", "");
        Config.soundUrls[Sound.PORTAL_CREATE_ORANGE.ordinal()] = Config.getString("sounds.create-orange-portal-url", "");
        Config.soundUrls[Sound.PORTAL_EXIT_BLUE.ordinal()] = Config.getString("sounds.exit-blue-portal-url", "");
        Config.soundUrls[Sound.PORTAL_EXIT_ORANGE.ordinal()] = Config.getString("sounds.exit-orange-portal-url", "");
        Config.soundUrls[Sound.PORTAL_CANNOT_CREATE.ordinal()] = Config.getString("sounds.cannot-create-portal-url", "");
        Config.soundUrls[Sound.GRILL_EMANCIPATE.ordinal()] = Config.getString("sounds.grill-emancipate-url", "");
        Config.soundUrls[Sound.FAITHPLATE_LAUNCH.ordinal()] = Config.getString("sounds.faith-plate-launch-url", "");
        Config.soundUrls[Sound.GEL_BLUE_BOUNCE.ordinal()] = Config.getString("sounds.blue-gel-bounce-url", "");
        Config.soundNotes[Sound.PORTAL_CREATE_BLUE.ordinal()] = Config.getString("sounds.create-blue-portal-note", "");
        Config.soundNotes[Sound.PORTAL_CREATE_ORANGE.ordinal()] = Config.getString("sounds.create-orange-portal-note", "");
        Config.soundNotes[Sound.PORTAL_EXIT_BLUE.ordinal()] = Config.getString("sounds.exit-blue-portal-note", "");
        Config.soundNotes[Sound.PORTAL_EXIT_ORANGE.ordinal()] = Config.getString("sounds.exit-orange-portal-note", "");
        Config.soundNotes[Sound.PORTAL_CANNOT_CREATE.ordinal()] = Config.getString("sounds.cannot-create-portal-note", "");
        Config.soundNotes[Sound.GRILL_EMANCIPATE.ordinal()] = Config.getString("sounds.grill-emancipate-note", "");
        Config.soundNotes[Sound.FAITHPLATE_LAUNCH.ordinal()] = Config.getString("sounds.faith-plate-launch-note", "4-5");
        Config.soundNotes[Sound.GEL_BLUE_BOUNCE.ordinal()] = Config.getString("sounds.blue-gel-bounce-note", "4-5");
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            UserManager.createUser(player);
        }
        if (regionConfig.getConfigurationSection("regions") != null) {
            for (String regionName : regionConfig.getConfigurationSection("regions").getKeys(false)) {
                RegionManager.loadRegion(regionName);
            }
        }
        RegionManager.loadRegion("global");
        Util.info(RegionManager.getRegionMap().size() + " region(s) loaded");
        for (String grill : grillConfig.getStringList("grills")) {
            GrillManager.loadGrill(grill);
        }
        Util.info(GrillManager.grills.size() + " grill(s) loaded");
        for (String bridge : bridgeConfig.getStringList("bridges")) {
            FunnelBridgeManager.loadBridge(bridge);
        }
        Util.info(FunnelBridgeManager.bridges.size() + " bridge(s) loaded");
        Config.saveAll();
    }

    private static int getInt(String path, int def) {
        if (mainConfig.get(path) == null) {
            mainConfig.set(path, (Object)def);
        }
        return mainConfig.getInt(path, def);
    }

    private static String getString(String path, String def) {
        if (mainConfig.get(path) == null) {
            mainConfig.set(path, (Object)def);
        }
        return mainConfig.getString(path, def);
    }

    private static List<String> getStringList(String path, List<String> def) {
        if (mainConfig.get(path) == null) {
            mainConfig.set(path, def);
        }
        return mainConfig.getStringList(path);
    }

    private static Boolean getBoolean(String path, Boolean def) {
        if (mainConfig.get(path) == null) {
            mainConfig.set(path, (Object)def);
        }
        return mainConfig.getBoolean(path, def.booleanValue());
    }

    public static void reLoad() {
        Config.unLoad();
        Config.load();
    }

    public static void unLoad() {
        FunnelBridgeManager.deleteAll();
        PortalManager.deleteAll();
        GrillManager.deleteAll();
        for (Map.Entry<String, User> entry : UserManager.getUserList().entrySet()) {
            User user = entry.getValue();
            Player player = plugin.getServer().getPlayer(entry.getKey());
            if (player != null && !RegionManager.getRegion((Location)player.getLocation()).Name.equalsIgnoreCase("global")) {
                user.revertInventory(player);
            }
            UserManager.deleteUser(user);
        }
    }

    public static void loadRegionSettings(Region region) {
        for (RegionSetting setting : RegionSetting.values()) {
            Object prop = regionConfig.get("regions." + region.Name + "." + setting.getYaml());
            if (prop == null) {
                region.settings.put(setting, setting.getDefault());
            } else {
                region.settings.put(setting, prop);
            }
            regionConfig.set("regions." + region.Name + "." + setting.getYaml(), region.settings.get((Object)setting));
        }
        region.updateLocation();
    }

    private static File getConfigFile(String filename) {
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdir();
        }
        File file = new File(plugin.getDataFolder(), filename);
        return file;
    }

    private static FileConfiguration getConfig(File file) {
        YamlConfiguration config = null;
        try {
            config = new YamlConfiguration();
            if (file.exists()) {
                config.load(file);
                config.set("setup", null);
            }
            config.save(file);
            return config;
        }
        catch (Exception e) {
            Util.severe("Unable to load YAML file " + file.getAbsolutePath());
            return null;
        }
    }

    public static void saveAll() {
        for (Map.Entry<String, Region> entry : RegionManager.getRegionMap().entrySet()) {
            Region region = entry.getValue();
            for (Map.Entry<RegionSetting, Object> setting : region.settings.entrySet()) {
                regionConfig.set("regions." + region.Name + "." + setting.getKey().getYaml(), setting.getValue());
            }
        }
        try {
            regionConfig.save(regionConfigFile);
        }
        catch (Exception ex) {
            Util.severe("Error while writing to regions.yml");
        }
        grillConfig.set("grills", null);
        ArrayList<String> list = new ArrayList<String>();
        for (Grill grill : GrillManager.getGrillList()) {
            list.add(grill.getStringLocation());
        }
        grillConfig.set("grills", list);
        try {
            grillConfig.save(grillConfigFile);
        }
        catch (Exception ex) {
            Util.severe("Error while writing to grills.yml");
        }
        bridgeConfig.set("bridges", null);
        list = new ArrayList();
        for (Bridge bridge : FunnelBridgeManager.bridges) {
            list.add(bridge.getStringLocation());
        }
        bridgeConfig.set("bridges", list);
        try {
            bridgeConfig.save(bridgeConfigFile);
        }
        catch (Exception ex) {
            Util.severe("Error while writing to bridges.yml");
        }
        try {
            mainConfig.save(mainConfigFile);
        }
        catch (Exception ex) {
            Util.severe("Error while writing to config.yml");
        }
    }

    static {
        soundUrls = new String[Sound.values().length];
        soundNotes = new String[Sound.values().length];
    }

    public static enum Sound {
        PORTAL_CREATE_BLUE,
        PORTAL_CREATE_ORANGE,
        PORTAL_EXIT_BLUE,
        PORTAL_EXIT_ORANGE,
        PORTAL_CANNOT_CREATE,
        GRILL_EMANCIPATE,
        FAITHPLATE_LAUNCH,
        GEL_BLUE_BOUNCE;

    }
}

