/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick.commands;

import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.commands.BaseCommand;
import com.matejdro.bukkit.portalstick.util.Config;
import com.matejdro.bukkit.portalstick.util.Permission;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import com.matejdro.bukkit.portalstick.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FlagCommand
extends BaseCommand {
    public FlagCommand() {
        this.name = "flag";
        this.argLength = 3;
        this.usage = "<region> <flag> <value> <- flag a region";
    }

    @Override
    public boolean execute() {
        Region editRegion = RegionManager.getRegion((String)this.args.get(0));
        if (editRegion == null) {
            Util.sendMessage((CommandSender)this.player, "&cInvalid region name, please supply an existing region!");
            return true;
        }
        for (RegionSetting setting : RegionSetting.values()) {
            if (!setting.getYaml().equalsIgnoreCase((String)this.args.get(1)) || !setting.getEditable()) continue;
            Object old = editRegion.settings.remove((Object)setting);
            try {
                if (setting.getDefault() instanceof Integer) {
                    editRegion.settings.put(setting, Integer.parseInt((String)this.args.get(2)));
                } else if (setting.getDefault() instanceof Double) {
                    editRegion.settings.put(setting, Double.parseDouble((String)this.args.get(2)));
                } else if (setting.getDefault() instanceof Boolean) {
                    editRegion.settings.put(setting, Boolean.parseBoolean((String)this.args.get(2)));
                } else {
                    editRegion.settings.put(setting, this.args.get(2));
                }
                Util.sendMessage((CommandSender)this.player, "&aRegion &7" + editRegion.Name + " &aupdated");
                Config.saveAll();
                Config.reLoad();
                return true;
            }
            catch (Throwable t) {
                Util.sendMessage((CommandSender)this.player, "&cInvalid value supplied for flag &7" + setting.getYaml());
                editRegion.settings.put(setting, old);
                return true;
            }
        }
        Util.sendMessage((CommandSender)this.player, "&cInvalid flag, please choose from one of the following:");
        String flags = "";
        for (RegionSetting setting : RegionSetting.values()) {
            if (!setting.getEditable()) continue;
            flags = flags + "&c" + setting.getYaml() + "&7, ";
        }
        Util.sendMessage((CommandSender)this.player, "&c" + flags.substring(0, flags.length() - 2));
        return true;
    }

    @Override
    public boolean permission(Player player) {
        return Permission.adminRegions(player);
    }
}

