/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick.commands;

import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.User;
import com.matejdro.bukkit.portalstick.UserManager;
import com.matejdro.bukkit.portalstick.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BaseCommand {
    public CommandSender sender;
    public List<String> args = new ArrayList<String>();
    public String name;
    public int argLength;
    public String usage;
    public boolean bePlayer = true;
    public Player player;
    public Region region;
    public User user;
    public String usedCommand;

    public boolean run(CommandSender sender, String[] preArgs, String cmd) {
        this.sender = sender;
        this.args.clear();
        for (String arg : preArgs) {
            this.args.add(arg);
        }
        this.args.remove(0);
        if (this.argLength != this.args.size()) {
            this.sendUsage();
            return true;
        }
        if (this.bePlayer && !(sender instanceof Player)) {
            return false;
        }
        this.player = (Player)sender;
        this.region = RegionManager.getRegion(this.player.getLocation());
        this.user = UserManager.getUser(this.player);
        this.usedCommand = cmd;
        if (!this.permission(this.player)) {
            return false;
        }
        return this.execute();
    }

    public abstract boolean execute();

    public abstract boolean permission(Player var1);

    public void sendUsage() {
        Util.sendMessage(this.sender, "&c/" + this.usedCommand + " " + this.name + " " + this.usage);
    }
}

