/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Portal;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class User {
    private Portal bluePortal;
    private Portal orangePortal;
    private ItemStack[] inventory;
    private ItemStack boots;
    private ItemStack chest;
    private ItemStack legs;
    private ItemStack helmet;
    private Location pointOne;
    private Location pointTwo;
    private Boolean usingTool = false;
    private int colorPreset = 0;
    private HashSet<Item> droppedItems = new HashSet();
    public String name;

    public User(String Name) {
        this.name = Name;
    }

    public Portal getBluePortal() {
        return this.bluePortal;
    }

    public void setBluePortal(Portal portal) {
        this.bluePortal = portal;
    }

    public Portal getOrangePortal() {
        return this.orangePortal;
    }

    public void setOrangePortal(Portal portal) {
        this.orangePortal = portal;
    }

    public int getColorPreset() {
        return this.colorPreset;
    }

    public void setColorPreset(int input) {
        this.colorPreset = input;
    }

    public void recreatePortals() {
        if (this.bluePortal != null) {
            this.bluePortal.recreate();
        }
        if (this.orangePortal != null) {
            this.orangePortal.recreate();
        }
    }

    public void revertInventory(Player player) {
        if (this.inventory == null) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        inv.clear();
        for (ItemStack old : this.inventory) {
            if (old == null) continue;
            ItemStack stack = new ItemStack(old.getType());
            stack.setAmount(old.getAmount());
            stack.setData(old.getData());
            inv.addItem(new ItemStack[]{stack});
        }
        if (this.boots != null && this.boots.getTypeId() != 0) {
            inv.setBoots(new ItemStack(this.boots.getType()));
        }
        if (this.chest != null && this.chest.getTypeId() != 0) {
            inv.setChestplate(new ItemStack(this.chest.getType()));
        }
        if (this.legs != null && this.legs.getTypeId() != 0) {
            inv.setLeggings(new ItemStack(this.legs.getType()));
        }
        if (this.helmet != null && this.helmet.getTypeId() != 0) {
            inv.setHelmet(new ItemStack(this.helmet.getType()));
        }
    }

    public void saveInventory(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack[] con = inv.getContents();
        this.inventory = new ItemStack[player.getInventory().getContents().length];
        int i = 0;
        for (ItemStack old : con) {
            if (old != null) {
                ItemStack stack = new ItemStack(old.getType());
                stack.setData(old.getData());
                stack.setAmount(old.getAmount());
                this.inventory[i] = stack;
            }
            ++i;
        }
        this.boots = new ItemStack(inv.getBoots().getType());
        this.chest = new ItemStack(inv.getChestplate().getType());
        this.legs = new ItemStack(inv.getLeggings().getType());
        this.helmet = new ItemStack(inv.getHelmet().getType());
    }

    public void setPointTwo(Location positiontwo) {
        this.pointTwo = positiontwo;
    }

    public Location getPointTwo() {
        return this.pointTwo;
    }

    public void setPointOne(Location positionone) {
        this.pointOne = positionone;
    }

    public Location getPointOne() {
        return this.pointOne;
    }

    public void setUsingTool(Boolean usingTool) {
        this.usingTool = usingTool;
    }

    public Boolean getUsingTool() {
        return this.usingTool;
    }

    public void addDroppedItem(Item item) {
        this.droppedItems.add(item);
    }

    public HashSet<Item> getDroppedItems() {
        return this.droppedItems;
    }

    public void resetItems() {
        this.droppedItems = new HashSet();
    }
}

