/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.util.Config;
import java.util.HashMap;
import org.bukkit.Location;

public class RegionManager {
    private static HashMap<String, Region> regions = new HashMap();

    public static Region loadRegion(String name) {
        Region region = RegionManager.getRegion(name);
        if (region == null) {
            region = new Region(name);
        }
        Config.loadRegionSettings(region);
        regions.put(name, region);
        return region;
    }

    public static void deleteRegion(String name) {
        Region region = RegionManager.getRegion(name);
        regions.remove(region.Name);
        Config.deleteRegion(name);
    }

    public static void createRegion(String name, Location one, Location two) {
        Region region = RegionManager.loadRegion(name);
        region.setLocation(one, two);
        Config.saveAll();
    }

    public static Region getRegion(Location location) {
        for (Region region : regions.values()) {
            if (!region.contains(location.toVector()) || !location.getWorld().getName().equalsIgnoreCase(region.World) || region.Name.equalsIgnoreCase("global")) continue;
            return region;
        }
        return RegionManager.getRegion("global");
    }

    public static Region getRegion(String name) {
        return regions.get(name.toLowerCase());
    }

    public static HashMap<String, Region> getRegionMap() {
        return regions;
    }
}

