/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Portal;
import com.matejdro.bukkit.portalstick.User;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import com.matejdro.bukkit.portalstick.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class Region
extends User {
    public HashMap<RegionSetting, Object> settings = new HashMap();
    public String Name;
    public Vector Min = new Vector();
    public Vector Max = new Vector();
    public String World;
    public HashSet<Portal> portals = new HashSet();
    public Portal bluePortalDest;
    public Portal orangePortalDest;

    public Region(String name) {
        super("region_" + name);
        this.Name = name;
    }

    public void updateLocation() {
        String[] loc = this.getString(RegionSetting.LOCATION).split(":");
        String[] loc1 = loc[1].split(",");
        Vector one = new Vector(Double.parseDouble(loc1[0]), Double.parseDouble(loc1[1]), Double.parseDouble(loc1[2]));
        String[] loc2 = loc[2].split(",");
        Vector two = new Vector(Double.parseDouble(loc2[0]), Double.parseDouble(loc2[1]), Double.parseDouble(loc2[2]));
        this.Min.setX(one.getX() < two.getX() ? one.getX() : two.getX());
        this.Max.setX(one.getX() > two.getX() ? one.getX() : two.getX());
        this.Min.setY(one.getY() < two.getY() ? one.getY() : two.getY());
        this.Max.setY(one.getY() > two.getY() ? one.getY() : two.getY());
        this.Min.setZ(one.getZ() < two.getZ() ? one.getZ() : two.getZ());
        this.Max.setZ(one.getZ() > two.getZ() ? one.getZ() : two.getZ());
        this.World = loc[0];
    }

    public void setLocation(Location one, Location two) {
        this.settings.remove((Object)RegionSetting.LOCATION);
        this.settings.put(RegionSetting.LOCATION, one.getWorld().getName() + ":" + one.toVector().toString() + ":" + two.toVector().toString());
        this.updateLocation();
    }

    public void regionPortalOpened(Boolean orange) {
        for (Portal p : this.portals) {
            if (orange.booleanValue()) {
                if (p.getDestination() != this.getBluePortal() || this.getBluePortal() == null) continue;
                this.getBluePortal().open();
                if (this.orangePortalDest != null && this.orangePortalDest.isOpen().booleanValue()) break;
                this.orangePortalDest = p;
                break;
            }
            if (p.getDestination() != this.getOrangePortal() || this.getOrangePortal() == null) continue;
            this.getOrangePortal().open();
            if (this.bluePortalDest != null && this.bluePortalDest.isOpen().booleanValue()) break;
            this.bluePortalDest = p;
            break;
        }
    }

    public void regionPortalClosed(Boolean orange) {
        for (Portal p : this.portals) {
            if (orange.booleanValue()) {
                if (!p.isOpen().booleanValue() || p.getDestination() != this.getBluePortal() || this.getBluePortal() == null) continue;
                Util.info("test12");
                if (this.orangePortalDest != null && this.orangePortalDest.isOpen().booleanValue()) break;
                this.orangePortalDest = p;
                break;
            }
            if (!p.isOpen().booleanValue() || p.getDestination() != this.getOrangePortal() || this.getOrangePortal() == null) continue;
            Util.info("test13");
            if (this.bluePortalDest != null && this.bluePortalDest.isOpen().booleanValue()) break;
            this.bluePortalDest = p;
            break;
        }
        if (orange.booleanValue()) {
            if (this.getOrangePortal() != null) {
                this.getOrangePortal().close();
            }
            this.orangePortalDest = null;
        } else {
            if (this.getBluePortal() != null) {
                this.getBluePortal().close();
            }
            this.bluePortalDest = null;
        }
    }

    public void regionPortalDeleted(Portal portal) {
        for (Portal p : this.portals) {
            if (p.getDestination() != portal) continue;
            p.close();
        }
    }

    public void regionPortalCreated(Boolean orange) {
        for (Portal p : this.portals) {
            if (p.isOrange() == orange || p.getDestination() != null) continue;
            p.open();
        }
    }

    public boolean contains(Vector vector) {
        return vector.isInAABB(this.Min, this.Max);
    }

    public boolean getBoolean(RegionSetting setting) {
        return (Boolean)this.settings.get((Object)setting);
    }

    public int getInt(RegionSetting setting) {
        return (Integer)this.settings.get((Object)setting);
    }

    public List<?> getList(RegionSetting setting) {
        return (List)this.settings.get((Object)setting);
    }

    public String getString(RegionSetting setting) {
        return (String)this.settings.get((Object)setting);
    }

    public double getDouble(RegionSetting setting) {
        return (Double)this.settings.get((Object)setting);
    }
}

