/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Portal;
import com.matejdro.bukkit.portalstick.PortalCoord;
import com.matejdro.bukkit.portalstick.PortalStick;
import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.User;
import com.matejdro.bukkit.portalstick.UserManager;
import com.matejdro.bukkit.portalstick.util.Config;
import com.matejdro.bukkit.portalstick.util.Permission;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import com.matejdro.bukkit.portalstick.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.material.Wool;
import org.bukkit.util.Vector;

public class PortalManager {
    public static HashSet<Portal> portals = new HashSet();
    public static HashMap<Location, Portal> borderBlocks = new HashMap();
    public static HashMap<Location, Portal> behindBlocks = new HashMap();
    public static HashMap<Location, Portal> insideBlocks = new HashMap();
    public static HashMap<Location, Portal> awayBlocksGeneral = new HashMap();
    public static HashMap<Location, Portal> awayBlocksX = new HashMap();
    public static HashMap<Location, Portal> awayBlocksY = new HashMap();
    public static HashMap<Location, Portal> awayBlocksZ = new HashMap();
    public static HashMap<Location, Vector> vectors = new HashMap();

    public static void checkPlayerMove(Player player, Region regionFrom, Region regionTo) {
        User user = UserManager.getUser(player);
        if (user == null) {
            return;
        }
        if (user.getUsingTool().booleanValue()) {
            return;
        }
        if (!regionTo.Name.equals(regionFrom.Name)) {
            if (regionFrom.getBoolean(RegionSetting.DELETE_ON_EXITENTRANCE) || regionTo.getBoolean(RegionSetting.DELETE_ON_EXITENTRANCE)) {
                PortalManager.deletePortals(user);
            }
            UserManager.deleteDroppedItems(player);
            if (regionFrom.getBoolean(RegionSetting.UNIQUE_INVENTORY) || regionTo.getBoolean(RegionSetting.UNIQUE_INVENTORY)) {
                if (regionTo.Name.equalsIgnoreCase("global")) {
                    user.revertInventory(player);
                } else {
                    user.saveInventory(player);
                    PortalManager.setPortalInventory(player, regionTo);
                }
            }
        }
    }

    public static void deleteAll() {
        for (Portal p : portals.toArray(new Portal[0])) {
            p.delete();
        }
    }

    private static Boolean checkPortal(PortalCoord portal) {
        Region region;
        for (Block b : portal.border) {
            region = RegionManager.getRegion(b.getLocation());
            if (borderBlocks.containsKey(b.getLocation()) || insideBlocks.containsKey(b.getLocation()) || behindBlocks.containsKey(b.getLocation()) || !region.getList(RegionSetting.TRANSPARENT_BLOCKS).contains(b.getTypeId()) && (region.getBoolean(RegionSetting.ALL_BLOCKS_PORTAL) || region.getList(RegionSetting.PORTAL_BLOCKS).contains(b.getTypeId()))) continue;
            return false;
        }
        for (Block b : portal.inside) {
            region = RegionManager.getRegion(b.getLocation());
            if (borderBlocks.containsKey(b.getLocation()) || insideBlocks.containsKey(b.getLocation()) || behindBlocks.containsKey(b.getLocation()) || !region.getList(RegionSetting.TRANSPARENT_BLOCKS).contains(b.getTypeId()) && (region.getBoolean(RegionSetting.ALL_BLOCKS_PORTAL) || region.getList(RegionSetting.PORTAL_BLOCKS).contains(b.getTypeId()))) continue;
            return false;
        }
        return true;
    }

    public static void deletePortals(User user) {
        if (user.getBluePortal() != null) {
            user.getBluePortal().delete();
        }
        if (user.getOrangePortal() != null) {
            user.getOrangePortal().delete();
        }
    }

    private static PortalCoord generateHorizontalPortal(Block block, BlockFace face) {
        PortalCoord portal = PortalManager.generatePortal(block, face);
        if (PortalManager.checkPortal(portal).booleanValue()) {
            return portal;
        }
        portal = PortalManager.generatePortal(block = block.getRelative(0, 0, 0), face);
        if (PortalManager.checkPortal(portal).booleanValue()) {
            return portal;
        }
        portal = PortalManager.generatePortal(block = block.getRelative(0, 1, 0), face);
        if (PortalManager.checkPortal(portal).booleanValue()) {
            return portal;
        }
        portal = PortalManager.generatePortal(block = block.getRelative(0, -1, 0), face);
        if (PortalManager.checkPortal(portal).booleanValue()) {
            return portal;
        }
        portal = PortalManager.generatePortal(block = block.getRelative(0, -2, 0), face);
        if (PortalManager.checkPortal(portal).booleanValue()) {
            return portal;
        }
        portal = PortalManager.generatePortal(block = block.getRelative(0, 2, 0), face);
        if (PortalManager.checkPortal(portal).booleanValue()) {
            return portal;
        }
        if (!PortalManager.checkPortal(portal).booleanValue()) {
            portal.finished = true;
        }
        return portal;
    }

    private static PortalCoord generatePortal(Block block, BlockFace face) {
        PortalCoord portal = new PortalCoord();
        portal.block = block;
        if (face == BlockFace.DOWN || face == BlockFace.UP) {
            if (!Config.CompactPortal) {
                portal.border.add(block.getRelative(1, 0, 0));
                portal.border.add(block.getRelative(0, 0, 1));
                portal.border.add(block.getRelative(-1, 0, 0));
                portal.border.add(block.getRelative(0, 0, -1));
                portal.border.add(block.getRelative(1, 0, -1));
                portal.border.add(block.getRelative(-1, 0, 1));
                portal.border.add(block.getRelative(1, 0, 1));
                portal.border.add(block.getRelative(-1, 0, -1));
            }
            if (Config.FillPortalBack < 0 || !Config.CompactPortal) {
                portal.border.add(block.getRelative(1, 0, 0));
            }
            portal.inside.add(block);
            if (face == BlockFace.DOWN) {
                portal.destLoc = block.getRelative(0, -1, 0).getLocation();
                portal.behind.add(block.getRelative(0, 1, 0));
                portal.tpFace = BlockFace.UP;
            } else {
                portal.destLoc = block.getRelative(0, 1, 0).getLocation();
                portal.behind.add(block.getRelative(0, -1, 0));
                portal.tpFace = BlockFace.DOWN;
            }
            portal.vertical = true;
        } else {
            int x = 0;
            int z = 0;
            switch (face) {
                case NORTH: {
                    z = -1;
                    portal.tpFace = BlockFace.SOUTH;
                    break;
                }
                case EAST: {
                    x = -1;
                    portal.tpFace = BlockFace.WEST;
                    break;
                }
                case SOUTH: {
                    z = 1;
                    portal.tpFace = BlockFace.NORTH;
                    break;
                }
                case WEST: {
                    x = 1;
                    portal.tpFace = BlockFace.EAST;
                }
            }
            if (!Config.CompactPortal) {
                portal.border.add(block.getRelative(0, 1, 0));
                portal.border.add(block.getRelative(x * 1, 0, z * 1));
                portal.border.add(block.getRelative(x * -1, 0, z * -1));
                portal.border.add(block.getRelative(x * 1, 1, z * 1));
                portal.border.add(block.getRelative(x * -1, 1, z * -1));
                portal.border.add(block.getRelative(x * 1, -1, z * 1));
                portal.border.add(block.getRelative(x * -1, -1, z * -1));
                portal.border.add(block.getRelative(x * 1, -2, z * 1));
                portal.border.add(block.getRelative(x * -1, -2, z * -1));
            }
            if (Config.FillPortalBack < 0 || !Config.CompactPortal) {
                portal.border.add(block.getRelative(0, -2, 0));
            }
            portal.inside.add(block);
            portal.inside.add(block.getRelative(0, -1, 0));
            portal.destLoc = block.getRelative(z * 1, -1, x * 1).getLocation();
            portal.vertical = false;
            portal.behind.add(block.getRelative(z * -1, -1, x * -1));
            portal.behind.add(block.getRelative(z * -1, 0, x * -1));
        }
        return portal;
    }

    public static Boolean placePortal(Block block, BlockFace face, Player player, Boolean orange, Boolean end) {
        Region region = RegionManager.getRegion(block.getLocation());
        if (region.getBoolean(RegionSetting.CHECK_WORLDGUARD) && PortalStick.worldGuard != null && !PortalStick.worldGuard.canBuild(player, block)) {
            return false;
        }
        if (!region.getBoolean(RegionSetting.ENABLE_PORTALS)) {
            return false;
        }
        if (!Permission.placePortal(player)) {
            return false;
        }
        Boolean vertical = false;
        PortalCoord portalc = new PortalCoord();
        User owner = UserManager.getUser(player);
        if (face == BlockFace.DOWN || face == BlockFace.UP) {
            vertical = true;
            portalc = PortalManager.generatePortal(block, face);
            if (!PortalManager.checkPortal(portalc).booleanValue()) {
                if (end.booleanValue()) {
                    Util.sendMessage((CommandSender)player, Config.MessageCannotPlacePortal);
                }
                Util.PlaySound(Config.Sound.PORTAL_CANNOT_CREATE, player, block.getLocation());
                return false;
            }
        } else {
            portalc = PortalManager.generateHorizontalPortal(block, face);
            if (portalc.finished.booleanValue()) {
                if (end.booleanValue()) {
                    Util.sendMessage((CommandSender)player, Config.MessageCannotPlacePortal);
                }
                Util.PlaySound(Config.Sound.PORTAL_CANNOT_CREATE, player, block.getLocation());
                return false;
            }
        }
        portalc.destLoc.setX(portalc.destLoc.getX() + 0.5);
        portalc.destLoc.setZ(portalc.destLoc.getZ() + 0.5);
        Portal portal = new Portal(portalc.destLoc, portalc.block, portalc.border, portalc.inside, portalc.behind, owner, orange, vertical, portalc.tpFace);
        if (orange.booleanValue()) {
            if (owner.getOrangePortal() != null) {
                owner.getOrangePortal().delete();
            }
            owner.setOrangePortal(portal);
            Util.PlaySound(Config.Sound.PORTAL_CREATE_ORANGE, player, block.getLocation());
        } else {
            if (owner.getBluePortal() != null) {
                owner.getBluePortal().delete();
            }
            owner.setBluePortal(portal);
            Util.PlaySound(Config.Sound.PORTAL_CREATE_BLUE, player, block.getLocation());
        }
        portals.add(portal);
        region.portals.add(portal);
        portal.create();
        return true;
    }

    public static void placePortal(Block block, Player player, Boolean orange) {
        float dir = (float)Math.toDegrees(Math.atan2(player.getLocation().getBlockX() - block.getX(), block.getZ() - player.getLocation().getBlockZ()));
        if ((dir %= 360.0f) < 0.0f) {
            dir += 360.0f;
        }
        if (dir < 90.0f || dir > 270.0f ? PortalManager.placePortal(block, BlockFace.EAST, player, orange, false) != false : PortalManager.placePortal(block, BlockFace.WEST, player, orange, false) != false) {
            return;
        }
        if (dir < 180.0f ? PortalManager.placePortal(block, BlockFace.SOUTH, player, orange, false) != false : PortalManager.placePortal(block, BlockFace.NORTH, player, orange, false) != false) {
            return;
        }
        if (player.getEyeLocation().getY() >= block.getLocation().getY() ? PortalManager.placePortal(block, BlockFace.UP, player, orange, false) != false : PortalManager.placePortal(block, BlockFace.DOWN, player, orange, true) != false) {
            return;
        }
    }

    public static void setPortalInventory(Player player, Region region) {
        PlayerInventory inv = player.getInventory();
        for (int i = 0; i < 40; ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || item.getTypeId() == 0) continue;
            Boolean keep = false;
            for (Object is : region.getList(RegionSetting.GRILL_INVENTORY_CLEAR_EXCEPTIONS)) {
                ItemStack itemcheck = Util.getItemData((String)is);
                if (item.getTypeId() != itemcheck.getTypeId()) continue;
                keep = true;
                break;
            }
            if (keep.booleanValue()) continue;
            inv.clear(i);
        }
        for (Object is : region.getList(RegionSetting.UNIQUE_INVENTORY_ITEMS)) {
            ItemStack item = Util.getItemData((String)is);
            if (item.getTypeId() == Config.PortalTool) {
                inv.setItemInHand(item);
                continue;
            }
            inv.addItem(new ItemStack[]{item});
        }
    }

    public static void tryPlacingAutomatedPortal(Block b) {
        Wool wool = (Wool)Material.WOOL.getNewData(b.getData());
        if (wool.getColor() != DyeColor.BLACK && wool.getColor() != DyeColor.BLUE && wool.getColor() != DyeColor.ORANGE) {
            return;
        }
        Block firstIronBar = null;
        for (int i = 0; i < 6; ++i) {
            if (b.getRelative(BlockFace.values()[i], 2).getType() == Material.IRON_FENCE) {
                firstIronBar = b.getRelative(BlockFace.values()[i], 2);
                break;
            }
            if (b.getRelative(BlockFace.values()[i]).getType() != Material.IRON_FENCE) continue;
            firstIronBar = b.getRelative(BlockFace.values()[i]);
            break;
        }
        if (firstIronBar == null) {
            return;
        }
        ArrayList<Block> ironBars = new ArrayList<Block>();
        for (int i = 0; i < 6; ++i) {
            BlockFace face = BlockFace.values()[i];
            if (firstIronBar.getRelative(face).getType() != Material.IRON_FENCE) continue;
            while (firstIronBar.getRelative(face).getType() == Material.IRON_FENCE) {
                firstIronBar = firstIronBar.getRelative(face);
            }
            ironBars.add(firstIronBar);
            int counter = 1;
            while (firstIronBar.getRelative(face.getOppositeFace(), counter).getType() == Material.IRON_FENCE) {
                ironBars.add(firstIronBar.getRelative(face.getOppositeFace(), counter));
                ++counter;
            }
            break;
        }
        int size = Config.CompactPortal ? 2 : 4;
        BlockFace otherSide = null;
        for (int i = 0; i < 6; ++i) {
            BlockFace face = BlockFace.values()[i];
            if (firstIronBar.getRelative(face, size).getType() != Material.IRON_FENCE) continue;
            otherSide = face;
            break;
        }
        if (otherSide == null) {
            return;
        }
        for (Block ironBar : ironBars.toArray(new Block[0])) {
            if (ironBar.getRelative(otherSide, size).getType() != Material.IRON_FENCE) continue;
            ironBars.add(ironBar.getRelative(otherSide, size));
        }
        BlockFace portalFace = null;
        Portal oldPortal = null;
        for (int i = 0; i < 6; ++i) {
            BlockFace face2 = BlockFace.values()[i];
            if (face2 == otherSide || face2.getOppositeFace() == otherSide) continue;
            Block firstPortalBlock = firstIronBar.getRelative(otherSide).getRelative(face2);
            if (firstPortalBlock.getType() == Material.STONE) {
                portalFace = face2;
                break;
            }
            if (!borderBlocks.containsKey(firstPortalBlock.getLocation()) && !insideBlocks.containsKey(firstPortalBlock.getLocation())) continue;
            oldPortal = borderBlocks.get(firstPortalBlock.getLocation());
            if (oldPortal == null) {
                oldPortal = insideBlocks.get(firstPortalBlock.getLocation());
            }
            portalFace = face2;
            break;
        }
        if (portalFace == null) {
            return;
        }
        if (!Config.CompactPortal && ((portalFace == BlockFace.UP || portalFace == BlockFace.DOWN) && ironBars.size() != 6 || portalFace != BlockFace.UP && portalFace != BlockFace.DOWN && ironBars.size() != 8) || Config.CompactPortal && ((portalFace == BlockFace.UP || portalFace == BlockFace.DOWN) && ironBars.size() != 2 || portalFace != BlockFace.UP && portalFace != BlockFace.DOWN && ironBars.size() != 4)) {
            return;
        }
        if (wool.getColor() == DyeColor.BLACK) {
            if (oldPortal != null) {
                oldPortal.delete();
            }
            return;
        }
        PortalCoord portalc = new PortalCoord();
        for (int i = 0; i < ironBars.size() / 2; ++i) {
            portalc.border.add(((Block)ironBars.get(i)).getRelative(portalFace).getRelative(otherSide, 1));
            portalc.border.add(((Block)ironBars.get(i)).getRelative(portalFace).getRelative(otherSide, 3));
            if (i == 0 || i == ironBars.size() / 2 - 1) {
                portalc.border.add(((Block)ironBars.get(i)).getRelative(portalFace).getRelative(otherSide, 2));
                continue;
            }
            portalc.inside.add(((Block)ironBars.get(i)).getRelative(portalFace).getRelative(otherSide, 2));
        }
        portalc.vertical = portalFace == BlockFace.UP || portalFace == BlockFace.DOWN;
        portalc.block = portalc.inside.toArray(new Block[0])[0];
        if (portalc.border.size() == 0 || portalc.inside.size() == 0) {
            return;
        }
        for (Block tb : portalc.border) {
            if (tb.getType() == Material.STONE || borderBlocks.containsKey(tb.getLocation()) || insideBlocks.containsKey(tb.getLocation())) continue;
            return;
        }
        for (Block tb : portalc.inside) {
            if (tb.getType() == Material.STONE || borderBlocks.containsKey(tb.getLocation()) || insideBlocks.containsKey(tb.getLocation())) continue;
            return;
        }
        if (portalc.vertical.booleanValue()) {
            portalc.destLoc = portalc.inside.toArray(new Block[0])[0].getRelative(portalFace.getOppositeFace()).getLocation();
        } else {
            int y = 200;
            Block lBlock = null;
            for (Block lb : portalc.inside) {
                if (lBlock != null && lBlock.getY() >= y) continue;
                lBlock = lb;
            }
            portalc.destLoc = lBlock.getRelative(portalFace.getOppositeFace()).getLocation();
        }
        portalc.destLoc.setX(portalc.destLoc.getX() + 0.5);
        portalc.destLoc.setZ(portalc.destLoc.getZ() + 0.5);
        portalc.tpFace = portalFace;
        if (oldPortal != null) {
            oldPortal.delete();
        }
        Boolean orange = wool.getColor() == DyeColor.ORANGE;
        Region region = RegionManager.getRegion(b.getLocation());
        Portal portal = new Portal(portalc.destLoc, portalc.block, portalc.border, portalc.inside, portalc.behind, region, orange, portalc.vertical, portalc.tpFace);
        if (orange.booleanValue()) {
            if (region.getOrangePortal() != null) {
                region.getOrangePortal().delete();
            }
            region.setOrangePortal(portal);
        } else {
            if (region.getBluePortal() != null) {
                region.getBluePortal().delete();
            }
            region.setBluePortal(portal);
        }
        portals.add(portal);
        region.portals.add(portal);
        portal.create();
    }
}

