/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.FunnelBridgeManager;
import com.matejdro.bukkit.portalstick.PortalManager;
import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.User;
import com.matejdro.bukkit.portalstick.util.BlockUtil;
import com.matejdro.bukkit.portalstick.util.Config;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import com.matejdro.bukkit.portalstick.util.Util;
import java.util.HashMap;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class Portal {
    private Location teleport;
    private HashSet<Block> border;
    private HashSet<Block> inside;
    private HashSet<Block> behind;
    private boolean vertical;
    private Block centerBlock;
    private User owner;
    private Boolean orange = false;
    private Boolean open = false;
    private boolean disabled = false;
    private boolean transmitter = false;
    private boolean placetorch = false;
    BlockFace teleportFace;
    private HashSet<Location> awayBlocks = new HashSet();
    private HashMap<Location, String> oldBlocks = new HashMap();

    public Portal() {
        this.border = new HashSet();
        this.inside = new HashSet();
    }

    public Portal(Location Teleport, Block CenterBlock, HashSet<Block> Border, HashSet<Block> Inside, HashSet<Block> Behind, User Owner, Boolean Orange, Boolean Vertical, BlockFace Teleportface) {
        this.teleport = Teleport;
        this.border = Border;
        this.inside = Inside;
        this.orange = Orange;
        this.owner = Owner;
        this.vertical = Vertical;
        this.teleportFace = Teleportface;
        this.behind = Behind;
        this.centerBlock = CenterBlock;
    }

    public void delete() {
        if (this.orange != null && this.owner != null) {
            for (Block b : this.border) {
                if (this.oldBlocks.containsKey(b.getLocation())) {
                    BlockUtil.setBlockData(b, this.oldBlocks.get(b.getLocation()));
                }
                PortalManager.borderBlocks.remove(b.getLocation());
            }
            for (Block b : this.inside) {
                if (this.oldBlocks.containsKey(b.getLocation())) {
                    BlockUtil.setBlockData(b, this.oldBlocks.get(b.getLocation()));
                }
                PortalManager.insideBlocks.remove(b.getLocation());
            }
            if (Config.FillPortalBack > -1) {
                for (Block b : this.behind) {
                    if (this.oldBlocks.containsKey(b.getLocation())) {
                        BlockUtil.setBlockData(b, this.oldBlocks.get(b.getLocation()));
                    }
                    PortalManager.behindBlocks.remove(b.getLocation());
                }
            }
            for (Location l : this.awayBlocks) {
                PortalManager.awayBlocksGeneral.remove(l);
                PortalManager.awayBlocksX.remove(l);
                PortalManager.awayBlocksY.remove(l);
                PortalManager.awayBlocksZ.remove(l);
            }
            if (this.orange.booleanValue()) {
                this.owner.setOrangePortal(null);
            } else {
                this.owner.setBluePortal(null);
            }
            this.open = false;
            PortalManager.portals.remove(this);
            RegionManager.getRegion((Location)this.centerBlock.getLocation()).portals.remove(this);
            if (this.getDestination() != null && this.getDestination().isOpen().booleanValue()) {
                if (this.getDestination().isRegionPortal().booleanValue()) {
                    RegionManager.getRegion(this.getDestination().getCenterBlock().getLocation()).regionPortalClosed(this.orange);
                } else {
                    this.getDestination().close();
                }
            }
            if (this.isRegionPortal().booleanValue()) {
                RegionManager.getRegion(this.centerBlock.getLocation()).regionPortalDeleted(this);
            }
        }
    }

    public void open() {
        Region region = RegionManager.getRegion(((Block)this.inside.toArray()[0]).getLocation());
        for (Block b : this.inside) {
            b.setType(Material.AIR);
            if (!region.getBoolean(RegionSetting.ENABLE_REDSTONE_TRANSFER)) continue;
            for (int i = 0; i < 4; ++i) {
                Portal destination;
                BlockFace face = BlockFace.values()[i];
                if (b.getRelative(face).getBlockPower() <= 0 || (destination = this.getDestination()) == null || destination.isTransmitter().booleanValue()) continue;
                this.setTransmitter(true);
                if (destination.isOpen().booleanValue()) {
                    for (Block b2 : destination.getInside()) {
                        b2.setType(Material.REDSTONE_TORCH_ON);
                    }
                    continue;
                }
                destination.setPlaceTorch(true);
            }
        }
        if (this.placetorch) {
            ((Block)this.inside.toArray()[0]).setType(Material.REDSTONE_TORCH_ON);
            this.placetorch = false;
        }
        this.open = true;
        FunnelBridgeManager.reorientBridge(this);
    }

    public void close() {
        byte color = this.orange != false ? (byte)Util.getRightPortalColor(this.getOwner().getColorPreset()) : (byte)Util.getLeftPortalColor(this.getOwner().getColorPreset());
        for (Block b : this.inside) {
            b.setType(Material.WOOL);
            b.setData(color);
            this.open = false;
        }
        FunnelBridgeManager.reorientBridge(this);
    }

    public void recreate() {
        byte color = this.orange != false ? (byte)Util.getRightPortalColor(this.getOwner().getColorPreset()) : (byte)Util.getLeftPortalColor(this.getOwner().getColorPreset());
        for (Block b : this.border) {
            b.setData(color);
        }
        if (!this.isOpen().booleanValue()) {
            for (Block b : this.inside) {
                b.setData(color);
            }
        }
        if (Config.CompactPortal) {
            for (Block b : this.behind) {
                b.setData(color);
            }
        }
    }

    public void create() {
        byte color = this.orange != false ? (byte)Util.getRightPortalColor(this.getOwner().getColorPreset()) : (byte)Util.getLeftPortalColor(this.getOwner().getColorPreset());
        for (Block b : this.border) {
            if (PortalManager.borderBlocks.containsKey(b.getLocation())) {
                PortalManager.borderBlocks.get(b.getLocation()).delete();
            }
            if (PortalManager.insideBlocks.containsKey(b.getLocation())) {
                PortalManager.insideBlocks.get(b.getLocation()).delete();
            }
            if (PortalManager.behindBlocks.containsKey(b.getLocation())) {
                PortalManager.behindBlocks.get(b.getLocation()).delete();
            }
            this.oldBlocks.put(b.getLocation(), BlockUtil.getBlockData(b));
            b.setType(Material.WOOL);
            b.setData(color);
            PortalManager.borderBlocks.put(b.getLocation(), this);
        }
        for (Block b : this.inside) {
            this.oldBlocks.put(b.getLocation(), BlockUtil.getBlockData(b));
        }
        if (Config.FillPortalBack > -1) {
            for (Block b : this.behind) {
                if (PortalManager.borderBlocks.containsKey(b.getLocation())) {
                    PortalManager.borderBlocks.get(b.getLocation()).delete();
                }
                if (PortalManager.insideBlocks.containsKey(b.getLocation())) {
                    PortalManager.insideBlocks.get(b.getLocation()).delete();
                }
                if (PortalManager.behindBlocks.containsKey(b.getLocation())) {
                    PortalManager.behindBlocks.get(b.getLocation()).delete();
                }
                this.oldBlocks.put(b.getLocation(), BlockUtil.getBlockData(b));
                if (Config.CompactPortal) {
                    b.setType(Material.WOOL);
                    b.setData(color);
                } else {
                    b.setTypeId(Config.FillPortalBack);
                }
                PortalManager.behindBlocks.put(b.getLocation(), this);
            }
        }
        if (this.getDestination() == null) {
            this.close();
        } else {
            this.open();
            if (this.getDestination().isRegionPortal().booleanValue()) {
                RegionManager.getRegion(this.getCenterBlock().getLocation()).regionPortalOpened(this.orange);
            } else {
                this.getDestination().open();
            }
        }
        if (this.isRegionPortal().booleanValue()) {
            RegionManager.getRegion(this.centerBlock.getLocation()).regionPortalCreated(this.orange);
        }
        for (Block b : this.inside) {
            int z;
            int y;
            int x;
            PortalManager.insideBlocks.put(b.getLocation(), this);
            for (x = -2; x < 3; ++x) {
                for (y = -2; y < 3; ++y) {
                    for (int z2 = -2; z2 < 3; ++z2) {
                        PortalManager.awayBlocksGeneral.put(b.getRelative(x, y, z2).getLocation(), this);
                        this.awayBlocks.add(b.getRelative(x, y, z2).getLocation());
                    }
                }
            }
            for (int y2 = -2; y2 < 3; ++y2) {
                for (z = -2; z < 3; ++z) {
                    PortalManager.awayBlocksX.put(b.getRelative(3, y2, z).getLocation(), this);
                    PortalManager.awayBlocksX.put(b.getRelative(-3, y2, z).getLocation(), this);
                    this.awayBlocks.add(b.getRelative(3, y2, z).getLocation());
                    this.awayBlocks.add(b.getRelative(-3, y2, z).getLocation());
                }
            }
            for (x = -2; x < 3; ++x) {
                for (z = -2; z < 3; ++z) {
                    PortalManager.awayBlocksY.put(b.getRelative(x, 3, z).getLocation(), this);
                    PortalManager.awayBlocksY.put(b.getRelative(x, -3, z).getLocation(), this);
                    this.awayBlocks.add(b.getRelative(x, 3, z).getLocation());
                    this.awayBlocks.add(b.getRelative(x, -3, z).getLocation());
                }
            }
            for (x = -2; x < 3; ++x) {
                for (y = -2; y < 3; ++y) {
                    PortalManager.awayBlocksZ.put(b.getRelative(x, y, 3).getLocation(), this);
                    PortalManager.awayBlocksZ.put(b.getRelative(x, y, -3).getLocation(), this);
                    this.awayBlocks.add(b.getRelative(x, y, 3).getLocation());
                    this.awayBlocks.add(b.getRelative(x, y, -3).getLocation());
                }
            }
        }
    }

    public Location getTeleportLocation() {
        return this.teleport;
    }

    public User getOwner() {
        return this.owner;
    }

    public HashSet<Block> getBorder() {
        return this.border;
    }

    public HashSet<Block> getInside() {
        return this.inside;
    }

    public HashSet<Block> getBehind() {
        return this.behind;
    }

    public Boolean isOpen() {
        return this.open;
    }

    public Boolean isVertical() {
        return this.vertical;
    }

    public BlockFace getTeleportFace() {
        return this.teleportFace;
    }

    public Boolean isOrange() {
        return this.orange;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean input) {
        this.disabled = input;
    }

    public Boolean isTransmitter() {
        return this.transmitter;
    }

    public void setTransmitter(Boolean input) {
        this.transmitter = input;
    }

    public void setPlaceTorch(Boolean input) {
        this.placetorch = true;
    }

    public Portal getDestination() {
        Region region = RegionManager.getRegion(this.centerBlock.getLocation());
        if (this.isOrange().booleanValue()) {
            if (this.owner.getBluePortal() != null) {
                return this.owner.getBluePortal();
            }
            if (!this.isRegionPortal().booleanValue()) {
                return region.getBluePortal();
            }
            return region.bluePortalDest;
        }
        if (this.owner.getOrangePortal() != null) {
            return this.owner.getOrangePortal();
        }
        if (!this.isRegionPortal().booleanValue()) {
            return region.getOrangePortal();
        }
        return region.orangePortalDest;
    }

    public Block getCenterBlock() {
        return this.centerBlock;
    }

    public Boolean isRegionPortal() {
        return this.owner.name.startsWith("region_");
    }
}

