/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Grill;
import com.matejdro.bukkit.portalstick.PortalManager;
import com.matejdro.bukkit.portalstick.PortalStick;
import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.User;
import com.matejdro.bukkit.portalstick.UserManager;
import com.matejdro.bukkit.portalstick.util.BlockUtil;
import com.matejdro.bukkit.portalstick.util.Config;
import com.matejdro.bukkit.portalstick.util.Permission;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class GrillManager
implements Runnable {
    public static List<Grill> grills = new ArrayList<Grill>();
    public static HashMap<Location, Grill> insideBlocks = new HashMap();
    public static HashMap<Location, Grill> borderBlocks = new HashMap();
    public static PortalStick plugin;
    private static HashSet<Block> border;
    private static HashSet<Block> inside;
    private static boolean complete;
    private static int max;

    public GrillManager(PortalStick instance) {
        plugin = instance;
    }

    public static void loadGrill(String blockloc) {
        String[] locarr = blockloc.split(",");
        String world = locarr[0];
        Block b = plugin.getServer().getWorld(world).getBlockAt((int)Double.parseDouble(locarr[1]), (int)Double.parseDouble(locarr[2]), (int)Double.parseDouble(locarr[3]));
        if (!GrillManager.placeRecursiveEmancipationGrill(b)) {
            Config.deleteGrill(blockloc);
        }
    }

    public static void deleteAll() {
        for (Grill g : grills.toArray(new Grill[0])) {
            g.deleteInside();
        }
        grills = new ArrayList<Grill>();
        insideBlocks.clear();
        borderBlocks.clear();
    }

    public static List<Grill> getGrillList() {
        return grills;
    }

    public static boolean createGrill(Player player, Block block) {
        if (!Permission.createGrill(player)) {
            return false;
        }
        if (Config.DisabledWorlds.contains(player.getLocation().getWorld().getName())) {
            return false;
        }
        if (GrillManager.placeRecursiveEmancipationGrill(block)) {
            Config.saveAll();
            return true;
        }
        return false;
    }

    public static boolean placeRecursiveEmancipationGrill(Block initial) {
        Region region = RegionManager.getRegion(initial.getLocation());
        String borderID = region.getString(RegionSetting.GRILL_MATERIAL);
        if (!BlockUtil.compareBlockToString(initial, borderID)) {
            return false;
        }
        if (!region.getBoolean(RegionSetting.ENABLE_GRILLS)) {
            return false;
        }
        for (Grill grill : grills) {
            if (!grill.getBorder().contains(initial)) continue;
            return false;
        }
        GrillManager.startRecurse(initial, borderID, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.DOWN, BlockFace.UP);
        if (!complete) {
            GrillManager.startRecurse(initial, borderID, BlockFace.UP, BlockFace.WEST, BlockFace.EAST, BlockFace.DOWN, BlockFace.SOUTH, BlockFace.NORTH);
        }
        if (!complete) {
            GrillManager.startRecurse(initial, borderID, BlockFace.UP, BlockFace.SOUTH, BlockFace.NORTH, BlockFace.DOWN, BlockFace.EAST, BlockFace.WEST);
        }
        if (!complete) {
            return false;
        }
        Grill grill = new Grill(border, inside, initial);
        grills.add(grill);
        grill.create();
        return true;
    }

    private static void startRecurse(Block initial, String id, BlockFace one, BlockFace two, BlockFace three, BlockFace four, BlockFace iOne, BlockFace iTwo) {
        border = new HashSet();
        inside = new HashSet();
        max = 0;
        complete = false;
        GrillManager.recurse(initial, id, initial, one, two, three, four);
        GrillManager.generateInsideBlocks(id, initial, iOne, iTwo);
        if (inside.size() == 0) {
            complete = false;
        }
    }

    private static void generateInsideBlocks(String borderID, Block initial, BlockFace iOne, BlockFace iTwo) {
        Vector max = border.toArray(new Block[0])[0].getLocation().toVector();
        Vector min = border.toArray(new Block[0])[0].getLocation().toVector();
        for (Block block : border.toArray(new Block[0])) {
            if ((double)block.getX() >= max.getX()) {
                max.setX(block.getX());
            }
            if ((double)block.getY() >= max.getY()) {
                max.setY(block.getY());
            }
            if ((double)block.getZ() >= max.getZ()) {
                max.setZ(block.getZ());
            }
            if ((double)block.getX() <= min.getX()) {
                min.setX(block.getX());
            }
            if ((double)block.getY() <= min.getY()) {
                min.setY(block.getY());
            }
            if (!((double)block.getZ() <= min.getZ())) continue;
            min.setZ(block.getZ());
        }
        for (int y = (int)min.getY(); y <= (int)max.getY(); ++y) {
            for (int x = (int)min.getX(); x <= (int)max.getX(); ++x) {
                for (int z = (int)min.getZ(); z <= (int)max.getZ(); ++z) {
                    Block block;
                    block = initial.getWorld().getBlockAt(x, y, z);
                    if (border.contains(block) || inside.contains(block)) continue;
                    boolean add = true;
                    for (BlockFace face : new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST}) {
                        if (face == iOne || face == iTwo) continue;
                        Block temp = block.getRelative(face);
                        while (temp.getLocation().toVector().isInAABB(min, max) && !BlockUtil.compareBlockToString(temp, borderID)) {
                            temp = temp.getRelative(face);
                        }
                        if (BlockUtil.compareBlockToString(temp, borderID)) continue;
                        add = false;
                        break;
                    }
                    if (!add) continue;
                    inside.add(block);
                }
            }
        }
    }

    private static void recurse(Block initial, String id, Block block, BlockFace one, BlockFace two, BlockFace three, BlockFace four) {
        if (max >= 100) {
            return;
        }
        if (block.equals(initial) && border.size() > 2) {
            complete = true;
            return;
        }
        if (BlockUtil.compareBlockToString(block, id) && !border.contains(block)) {
            border.add(block);
            ++max;
            GrillManager.recurse(initial, id, block.getRelative(one), one, two, three, four);
            GrillManager.recurse(initial, id, block.getRelative(two), one, two, three, four);
            GrillManager.recurse(initial, id, block.getRelative(three), one, two, three, four);
            GrillManager.recurse(initial, id, block.getRelative(four), one, two, three, four);
        }
    }

    public static void emancipate(Player player) {
        User user = UserManager.getUser(player);
        Region region = RegionManager.getRegion(player.getLocation());
        PortalManager.deletePortals(user);
        if (region.getBoolean(RegionSetting.GRILLS_CLEAR_INVENTORY) && !user.getUsingTool().booleanValue()) {
            PortalManager.setPortalInventory(player, region);
        }
        if (region.getBoolean(RegionSetting.GRILLS_CLEAR_ITEM_DROPS)) {
            UserManager.deleteDroppedItems(player);
        }
    }

    @Override
    public void run() {
        for (Grill g : grills.toArray(new Grill[0])) {
            if (g.isDisabled().booleanValue() || !g.getFirstBlock().getWorld().isChunkLoaded(g.getFirstBlock().getChunk()) || g.create()) continue;
            Block b = g.getFirstBlock();
            g.delete();
            GrillManager.placeRecursiveEmancipationGrill(b);
        }
    }

    static {
        max = 0;
    }
}

