/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.GrillManager;
import com.matejdro.bukkit.portalstick.util.Config;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class Grill {
    private HashSet<Block> border;
    private HashSet<Block> inside;
    private Block firstBlock;
    private Boolean disabled;

    public Grill(HashSet<Block> Border, HashSet<Block> Inside, Block FirstBlock) {
        this.border = Border;
        this.inside = Inside;
        this.firstBlock = FirstBlock;
        this.disabled = false;
    }

    public void delete() {
        this.deleteInside();
        Config.deleteGrill(this.getStringLocation());
        GrillManager.grills.remove(this);
        Config.saveAll();
        for (Block b : this.border) {
            GrillManager.borderBlocks.remove(b.getLocation());
        }
    }

    public void deleteInside() {
        for (Block b : this.inside) {
            b.setType(Material.AIR);
            GrillManager.insideBlocks.remove(b.getLocation());
        }
    }

    public void disable() {
        for (Block b : this.inside) {
            b.setType(Material.AIR);
            this.disabled = true;
        }
    }

    public void enable() {
        for (Block b : this.inside) {
            b.setType(Material.SUGAR_CANE_BLOCK);
            this.disabled = false;
        }
    }

    public boolean create() {
        boolean complete = true;
        for (Block b : this.inside) {
            GrillManager.insideBlocks.put(b.getLocation(), this);
            if (b.getType() == Material.SUGAR_CANE_BLOCK) continue;
            b.setType(Material.SUGAR_CANE_BLOCK);
            complete = false;
        }
        for (Block b : this.border) {
            GrillManager.borderBlocks.put(b.getLocation(), this);
        }
        return complete;
    }

    public String getStringLocation() {
        Location loc = this.firstBlock.getLocation();
        return loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
    }

    public HashSet<Block> getBorder() {
        return this.border;
    }

    public HashSet<Block> getInside() {
        return this.inside;
    }

    public Block getFirstBlock() {
        return this.firstBlock;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }
}

