/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Bridge;
import com.matejdro.bukkit.portalstick.FunnelBridgeManager;
import com.matejdro.bukkit.portalstick.Portal;
import com.matejdro.bukkit.portalstick.PortalManager;
import java.util.HashSet;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;

public class Funnel
extends Bridge {
    private Boolean reversed = false;

    public Funnel(Block CreationBlock, Block startingBlock, BlockFace face, HashSet<Block> machineBlocks) {
        super(CreationBlock, startingBlock, face, machineBlocks);
    }

    public void setReverse(Boolean value) {
        this.reversed = value;
        this.activate();
    }

    public Boolean isReversed(Boolean value) {
        return this.reversed;
    }

    public BlockFace getDirection(Block block) {
        if (!this.bridgeBlocks.containsKey(block)) {
            return null;
        }
        int curnum = (Integer)this.bridgeBlocks.get(block);
        BlockFace face = null;
        for (BlockFace check : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Block cblock = block.getRelative(check);
            if (!this.bridgeBlocks.containsKey(cblock) || curnum - (Integer)this.bridgeBlocks.get(cblock) != 1 && (Integer)this.bridgeBlocks.get(cblock) <= curnum + 1) continue;
            face = check;
            break;
        }
        if (face == null) {
            return null;
        }
        if (this.reversed.booleanValue()) {
            face = face.getOppositeFace();
        }
        return face;
    }

    public BlockFace getDirection(Entity entity) {
        Block eb = entity.getLocation().getBlock();
        BlockFace face = this.getDirection(eb);
        if (face == null) {
            BlockFace check;
            BlockFace[] arr$ = BlockFace.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (face = this.getDirection(eb.getRelative(check = arr$[i$]))) == null; ++i$) {
            }
        }
        return face;
    }

    public int getCounter(Block block) {
        return (Integer)this.bridgeBlocks.get(block);
    }

    @Override
    public void activate() {
        int counter;
        this.deactivate();
        BlockFace face = this.facingSide;
        Block nextBlock = this.startBlock;
        int n = counter = this.reversed != false ? 1 : 8;
        while (true) {
            Portal portal;
            if ((portal = PortalManager.insideBlocks.get(nextBlock.getLocation())) == null) {
                portal = PortalManager.borderBlocks.get(nextBlock.getLocation());
            }
            if (portal != null && portal.isOpen().booleanValue()) {
                nextBlock = portal.getDestination().getTeleportLocation().getBlock();
                face = portal.getDestination().getTeleportFace().getOppositeFace();
                this.involvedPortals.add(portal);
                FunnelBridgeManager.involvedPortals.put(portal, this);
                continue;
            }
            if (nextBlock.getY() > 127 || !nextBlock.isLiquid() && nextBlock.getType() != Material.AIR) break;
            if (!nextBlock.getWorld().isChunkLoaded(nextBlock.getChunk())) {
                return;
            }
            if (this.reversed.booleanValue()) {
                if (counter < 0) {
                    counter = 8;
                }
                if (counter > 0) {
                    nextBlock.setType(Material.WATER);
                    if (face != BlockFace.UP && face != BlockFace.DOWN) {
                        nextBlock.setData((byte)(counter - 1));
                    }
                }
                --counter;
            } else {
                if (counter < 0) {
                    counter = 8;
                }
                if (counter > 0) {
                    nextBlock.setType(Material.WATER);
                    if (face != BlockFace.UP && face != BlockFace.DOWN) {
                        nextBlock.setData((byte)(8 - counter));
                    }
                }
                --counter;
            }
            this.bridgeBlocks.put(nextBlock, counter);
            FunnelBridgeManager.bridgeBlocks.put(nextBlock, this);
            nextBlock = nextBlock.getRelative(face);
        }
    }

    @Override
    public void deactivate() {
        for (Block b : this.bridgeBlocks.keySet()) {
            b.setType(Material.AIR);
        }
        for (Block b : this.bridgeBlocks.keySet()) {
            FunnelBridgeManager.bridgeBlocks.remove(b);
        }
        this.bridgeBlocks.clear();
        for (Portal p : this.involvedPortals) {
            FunnelBridgeManager.involvedPortals.remove(p);
        }
        for (Entity e : FunnelBridgeManager.glassBlocks.keySet()) {
            FunnelBridgeManager.EntityExitsFunnel(e);
        }
        this.involvedPortals.clear();
    }
}

