/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.Portal;
import com.matejdro.bukkit.portalstick.PortalManager;
import com.matejdro.bukkit.portalstick.PortalStick;
import com.matejdro.bukkit.portalstick.Region;
import com.matejdro.bukkit.portalstick.RegionManager;
import com.matejdro.bukkit.portalstick.util.Config;
import com.matejdro.bukkit.portalstick.util.RegionSetting;
import com.matejdro.bukkit.portalstick.util.Util;
import java.util.HashSet;
import net.minecraft.server.EntityFallingBlock;
import net.minecraft.server.EntityItem;
import net.minecraft.server.Item;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.craftbukkit.entity.CraftFallingSand;
import org.bukkit.craftbukkit.entity.CraftItem;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingSand;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Vehicle;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityManager
implements Runnable {
    private PortalStick plugin;
    private HashSet<org.bukkit.World> processingWorlds = new HashSet();
    private static HashSet<Entity> blockedEntities = new HashSet();

    public EntityManager(PortalStick instance) {
        this.plugin = instance;
    }

    public static Location teleport(Entity entity, Location LocTo, Vector vector) {
        if (entity == null || entity.isDead()) {
            return null;
        }
        if (blockedEntities.contains(entity)) {
            return null;
        }
        if (entity.isDead()) {
            return null;
        }
        Region regionTo = RegionManager.getRegion(LocTo);
        Portal portal = PortalManager.insideBlocks.get(LocTo);
        if (portal == null && (Math.abs(vector.getX()) > 0.5 || Math.abs(vector.getY()) > 1.0 || Math.abs(vector.getZ()) > 0.5 || entity instanceof Boat)) {
            portal = PortalManager.awayBlocksGeneral.get(LocTo);
            if (portal == null && Math.abs(vector.getX()) > 0.5) {
                portal = PortalManager.awayBlocksX.get(LocTo);
            }
            if (portal == null && Math.abs(vector.getY()) > 1.0) {
                portal = PortalManager.awayBlocksY.get(LocTo);
            }
            if (portal == null && Math.abs(vector.getZ()) > 0.5) {
                portal = PortalManager.awayBlocksZ.get(LocTo);
            }
        }
        if (portal == null && (entity instanceof FallingSand || entity instanceof TNTPrimed)) {
            portal = PortalManager.awayBlocksY.get(LocTo);
        }
        if (portal != null) {
            if (!portal.isOpen().booleanValue() || portal.isDisabled().booleanValue()) {
                return null;
            }
            if (Math.abs(vector.getY()) > 1.0 && !portal.isVertical().booleanValue()) {
                return null;
            }
            for (Block b : portal.getInside()) {
                if (!portal.isVertical().booleanValue()) {
                    if ((double)b.getX() + 0.5 < entity.getLocation().getX() && vector.getX() > 0.0) {
                        return null;
                    }
                    if ((double)b.getX() - 0.5 > entity.getLocation().getX() && vector.getX() < 0.0) {
                        return null;
                    }
                    if ((double)b.getZ() + 0.5 < entity.getLocation().getZ() && vector.getZ() > 0.0) {
                        return null;
                    }
                    if (!((double)b.getZ() - 0.5 > entity.getLocation().getZ()) || !(vector.getZ() < 0.0)) continue;
                    return null;
                }
                if ((double)b.getY() + 0.5 < entity.getLocation().getY() && vector.getY() > 0.0) {
                    return null;
                }
                if (!((double)b.getY() - 0.5 > entity.getLocation().getY()) || !(vector.getY() < -0.1)) continue;
                return null;
            }
            Portal destination = portal.getDestination();
            Location teleport = destination.getTeleportLocation().clone();
            if (destination.getTeleportFace() == BlockFace.DOWN) {
                teleport = teleport.add(0.0, 1.0, 0.0);
            }
            float yaw = entity.getLocation().getYaw();
            float pitch = entity.getLocation().getPitch();
            float startyaw = yaw;
            switch (portal.getTeleportFace()) {
                case EAST: {
                    yaw -= 90.0f;
                    break;
                }
                case SOUTH: {
                    yaw -= 180.0f;
                    break;
                }
                case WEST: {
                    yaw = -270.0f;
                    break;
                }
                case DOWN: {
                    yaw = pitch;
                    pitch = 0.0f;
                    break;
                }
                case UP: {
                    yaw = pitch;
                    pitch = 0.0f;
                }
            }
            Double momentum = 0.0;
            switch (portal.getTeleportFace()) {
                case SOUTH: 
                case NORTH: {
                    momentum = vector.getX();
                    break;
                }
                case EAST: 
                case WEST: {
                    momentum = vector.getZ();
                    break;
                }
                case DOWN: 
                case UP: {
                    momentum = vector.getY();
                }
            }
            momentum = Math.abs(momentum);
            momentum = momentum * regionTo.getDouble(RegionSetting.VELOCITY_MULTIPLIER);
            Vector outvector = entity.getVelocity().zero();
            switch (destination.getTeleportFace()) {
                case NORTH: {
                    yaw += 180.0f;
                    outvector = outvector.setX(momentum.doubleValue());
                    break;
                }
                case EAST: {
                    yaw += 270.0f;
                    outvector = outvector.setZ(momentum.doubleValue());
                    break;
                }
                case SOUTH: {
                    yaw += 360.0f;
                    outvector = outvector.setX(-momentum.doubleValue());
                    break;
                }
                case WEST: {
                    yaw += 430.0f;
                    outvector = outvector.setZ(-momentum.doubleValue());
                    break;
                }
                case DOWN: {
                    if (portal.getTeleportFace() != BlockFace.UP || portal.getTeleportFace() != BlockFace.DOWN) {
                        pitch = startyaw;
                        yaw = 0.0f;
                    } else {
                        startyaw = pitch = yaw;
                    }
                    outvector = outvector.setY(momentum.doubleValue());
                    break;
                }
                case UP: {
                    if (portal.getTeleportFace() != BlockFace.UP || portal.getTeleportFace() != BlockFace.DOWN) {
                        pitch = startyaw + 180.0f;
                        yaw = 0.0f;
                    } else {
                        startyaw = pitch = yaw;
                    }
                    outvector = outvector.setY(-momentum.doubleValue());
                }
            }
            if (!(entity instanceof Player || !(momentum < 0.5) || portal.getTeleportFace() != BlockFace.UP && portal.getTeleportFace() != BlockFace.DOWN || destination.getTeleportFace() != BlockFace.UP && destination.getTeleportFace() != BlockFace.DOWN)) {
                return null;
            }
            entity.setFallDistance(0.0f);
            entity.setVelocity(entity.getVelocity().zero());
            teleport.setPitch(pitch);
            teleport.setYaw(yaw);
            if (entity instanceof Arrow) {
                teleport.setY(teleport.getY() + 0.5);
                entity.remove();
                teleport.getWorld().spawnArrow(teleport, outvector, (float)(momentum * 1.0), 12.0f);
            } else if (entity instanceof FallingSand) {
                WorldServer world = ((CraftWorld)teleport.getWorld()).getHandle();
                EntityFallingBlock sand = ((CraftFallingSand)entity).getHandle();
                EntityFallingBlock newsand = new EntityFallingBlock((World)world, teleport.getX(), teleport.getY(), teleport.getZ(), sand.id, sand.data);
                Material db = teleport.getBlock().getType();
                if (db == Material.AIR || db == Material.WATER || db == Material.STATIONARY_WATER || db == Material.LAVA || db == Material.STATIONARY_LAVA) {
                    entity.remove();
                    world.addEntity((net.minecraft.server.Entity)newsand);
                    newsand.getBukkitEntity().setVelocity(outvector);
                }
            } else if (entity instanceof Item) {
                WorldServer world = ((CraftWorld)teleport.getWorld()).getHandle();
                EntityItem item = ((CraftItem)entity).getHandle();
                EntityItem newitem = new EntityItem((World)world, teleport.getX(), teleport.getY(), teleport.getZ(), item.itemStack);
                entity.remove();
                world.addEntity((net.minecraft.server.Entity)newitem);
                newitem.getBukkitEntity().setVelocity(outvector);
            } else if (entity instanceof Player || entity instanceof Vehicle) {
                blockedEntities.add(entity);
                final Location tploc = teleport;
                final Vector outVector = outvector;
                final Entity Entity2 = entity;
                PortalStick.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)PortalStick.instance, new Runnable(){

                    @Override
                    public void run() {
                        Entity2.teleport(tploc);
                        Entity2.setVelocity(outVector);
                        PortalStick.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)PortalStick.instance, new Runnable(){

                            @Override
                            public void run() {
                                blockedEntities.remove(Entity2);
                            }
                        }, 1L);
                    }
                }, 1L);
            } else {
                org.bukkit.World oldworld = entity.getWorld();
                entity.teleport(teleport);
                if (oldworld != teleport.getWorld()) {
                    net.minecraft.server.Entity bentity = ((CraftEntity)entity).getHandle();
                    WorldServer world = ((CraftWorld)teleport.getWorld()).getHandle();
                    world.addEntity(bentity);
                }
                entity.setVelocity(outvector);
            }
            destination.setDisabled(true);
            PortalStick.instance.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)PortalStick.instance, (Runnable)new enablePortal(destination), 10L);
            if (portal.isOrange().booleanValue()) {
                Util.PlaySound(Config.Sound.PORTAL_EXIT_ORANGE, entity instanceof Player ? (Player)entity : null, teleport);
            } else {
                Util.PlaySound(Config.Sound.PORTAL_EXIT_BLUE, entity instanceof Player ? (Player)entity : null, teleport);
            }
            return teleport;
        }
        return null;
    }

    @Override
    public void run() {
    }

    public static class enablePortal
    implements Runnable {
        Portal portal;

        public enablePortal(Portal instance) {
            this.portal = instance;
        }

        @Override
        public void run() {
            if (this.portal != null) {
                this.portal.setDisabled(false);
            }
        }
    }
}

