/*
 * Decompiled with CFR 0.152.
 */
package com.matejdro.bukkit.portalstick;

import com.matejdro.bukkit.portalstick.FunnelBridgeManager;
import com.matejdro.bukkit.portalstick.Portal;
import com.matejdro.bukkit.portalstick.PortalManager;
import java.util.HashSet;
import java.util.LinkedHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class Bridge {
    protected LinkedHashMap<Block, Integer> bridgeBlocks = new LinkedHashMap();
    protected HashSet<Portal> involvedPortals = new HashSet();
    protected HashSet<Block> bridgeMachineBlocks;
    protected Block startBlock;
    protected Block creationBlock;
    protected BlockFace facingSide;

    public Bridge(Block CreationBlock, Block startingBlock, BlockFace face, HashSet<Block> machineBlocks) {
        this.startBlock = startingBlock;
        this.facingSide = face;
        this.bridgeMachineBlocks = machineBlocks;
        this.creationBlock = CreationBlock;
    }

    public Block getCreationBlock() {
        return this.creationBlock;
    }

    public void activate() {
        this.deactivate();
        BlockFace face = this.facingSide;
        Block nextBlock = this.startBlock;
        while (true) {
            Portal portal;
            if ((portal = PortalManager.insideBlocks.get(nextBlock.getLocation())) == null) {
                portal = PortalManager.borderBlocks.get(nextBlock.getLocation());
            }
            if (portal != null && portal.isOpen().booleanValue()) {
                nextBlock = portal.getDestination().getTeleportLocation().getBlock();
                face = portal.getDestination().getTeleportFace().getOppositeFace();
                this.involvedPortals.add(portal);
                FunnelBridgeManager.involvedPortals.put(portal, this);
                continue;
            }
            if (nextBlock.getY() > 127 || !nextBlock.isLiquid() && nextBlock.getType() != Material.AIR) break;
            if (!nextBlock.getWorld().isChunkLoaded(nextBlock.getChunk())) {
                return;
            }
            nextBlock.setType(Material.GLASS);
            this.bridgeBlocks.put(nextBlock, 0);
            FunnelBridgeManager.bridgeBlocks.put(nextBlock, this);
            nextBlock = nextBlock.getRelative(face);
        }
    }

    public void deactivate() {
        for (Block b : this.bridgeBlocks.keySet()) {
            b.setType(Material.AIR);
        }
        for (Block b : this.bridgeBlocks.keySet()) {
            FunnelBridgeManager.bridgeBlocks.remove(b);
        }
        this.bridgeBlocks.clear();
        for (Portal p : this.involvedPortals) {
            FunnelBridgeManager.involvedPortals.remove(p);
        }
        this.involvedPortals.clear();
    }

    public void delete() {
        this.deactivate();
        for (Block b : this.bridgeMachineBlocks) {
            FunnelBridgeManager.bridgeMachineBlocks.remove(b);
        }
    }

    public Boolean isBlockNextToBridge(Block check) {
        for (Block b : this.bridgeBlocks.keySet()) {
            for (BlockFace face : new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
                if (b.getRelative(face) != check) continue;
                return true;
            }
        }
        return false;
    }

    public String getStringLocation() {
        Location loc = this.creationBlock.getLocation();
        return loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
    }
}

