/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.CustomAnimation;
import com.pclewis.mcpatcher.mod.TileSize;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.ColorizerFoliage;
import net.minecraft.src.ColorizerGrass;
import net.minecraft.src.ColorizerWater;
import net.minecraft.src.Compass;
import net.minecraft.src.Fire;
import net.minecraft.src.FlowLava;
import net.minecraft.src.FlowWater;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.GLAllocation;
import net.minecraft.src.Portal;
import net.minecraft.src.StillLava;
import net.minecraft.src.StillWater;
import net.minecraft.src.TextureFX;
import net.minecraft.src.TexturePackBase;
import net.minecraft.src.TexturePackCustom;
import net.minecraft.src.TexturePackDefault;
import net.minecraft.src.TexturePackFolder;
import net.minecraft.src.TexturePackList;
import net.minecraft.src.Watch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextureUtils {
    private static boolean animatedFire;
    private static boolean animatedLava;
    private static boolean animatedWater;
    private static boolean animatedPortal;
    private static boolean customFire;
    private static boolean customLava;
    private static boolean customWater;
    private static boolean customPortal;
    private static boolean customOther;
    public static final int LAVA_STILL_TEXTURE_INDEX = 237;
    public static final int LAVA_FLOWING_TEXTURE_INDEX = 238;
    public static final int WATER_STILL_TEXTURE_INDEX = 205;
    public static final int WATER_FLOWING_TEXTURE_INDEX = 206;
    public static final int FIRE_E_W_TEXTURE_INDEX = 31;
    public static final int FIRE_N_S_TEXTURE_INDEX = 47;
    public static final int PORTAL_TEXTURE_INDEX = 14;
    private static HashMap<String, Integer> expectedColumns;
    private static boolean useTextureCache;
    private static boolean reclaimGLMemory;
    private static boolean autoRefreshTextures;
    private static TexturePackBase lastTexturePack;
    private static HashMap<String, BufferedImage> cache;
    private static int textureRefreshCount;
    private static final String ALL_ITEMS = "/gui/allitems.png";
    private static final String ALL_ITEMSX = "/gui/allitemsx.png";
    public static boolean oldCreativeGui;
    private static boolean bindImageReentry;

    public static boolean setTileSize() {
        MCPatcherUtils.debug("\nchanging skin to %s", TextureUtils.getTexturePackName(TextureUtils.getSelectedTexturePack()));
        int size = TextureUtils.getTileSize();
        if (size == TileSize.int_size) {
            MCPatcherUtils.debug("tile size %d unchanged", size);
            return false;
        }
        MCPatcherUtils.debug("setting tile size to %d (was %d)", size, TileSize.int_size);
        TileSize.setTileSize(size);
        return true;
    }

    private static void setFontRenderer(Minecraft minecraft, FontRenderer fontRenderer, String filename) {
        boolean saveUnicode = fontRenderer.isUnicode;
        fontRenderer.initialize(minecraft.gameSettings, filename, minecraft.renderEngine);
        fontRenderer.isUnicode = saveUnicode;
    }

    public static void setFontRenderer() {
        MCPatcherUtils.debug("setFontRenderer()", new Object[0]);
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        TextureUtils.setFontRenderer(minecraft, minecraft.fontRenderer, "/font/default.png");
        if (minecraft.alternateFontRenderer != minecraft.fontRenderer) {
            TextureUtils.setFontRenderer(minecraft, minecraft.alternateFontRenderer, "/font/alternate.png");
        }
    }

    public static void registerTextureFX(List<TextureFX> textureList, TextureFX textureFX) {
        TextureFX fx = TextureUtils.refreshTextureFX(textureFX);
        if (fx != null) {
            MCPatcherUtils.debug("registering new TextureFX class %s", textureFX.getClass().getName());
            textureList.add(fx);
            fx.onTick();
        }
    }

    private static TextureFX refreshTextureFX(TextureFX textureFX) {
        if (textureFX instanceof Compass || textureFX instanceof Watch || textureFX instanceof StillLava || textureFX instanceof FlowLava || textureFX instanceof StillWater || textureFX instanceof FlowWater || textureFX instanceof Fire || textureFX instanceof Portal) {
            return null;
        }
        MCPatcherUtils.info("attempting to refresh unknown animation %s", textureFX.getClass().getName());
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        Class<?> textureFXClass = textureFX.getClass();
        for (int i = 0; i < 3; ++i) {
            try {
                switch (i) {
                    case 0: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class, Integer.TYPE);
                        return (TextureFX)constructor.newInstance(minecraft, TileSize.int_size);
                    }
                    case 1: {
                        Constructor<?> constructor = textureFXClass.getConstructor(Minecraft.class);
                        return (TextureFX)constructor.newInstance(minecraft);
                    }
                    case 2: {
                        Constructor<?> constructor = textureFXClass.getConstructor(new Class[0]);
                        return (TextureFX)constructor.newInstance(new Object[0]);
                    }
                }
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (textureFX.imageData.length != TileSize.int_numBytes) {
            MCPatcherUtils.debug("resizing %s buffer from %d to %d bytes", textureFXClass.getName(), textureFX.imageData.length, TileSize.int_numBytes);
            textureFX.imageData = new byte[TileSize.int_numBytes];
        }
        return textureFX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshTextureFX(List<TextureFX> textureList) {
        boolean isDefault;
        MCPatcherUtils.debug("refreshTextureFX()", new Object[0]);
        ArrayList<TextureFX> savedTextureFX = new ArrayList<TextureFX>();
        for (TextureFX t : textureList) {
            TextureFX fx = TextureUtils.refreshTextureFX(t);
            if (fx == null) continue;
            savedTextureFX.add(fx);
        }
        textureList.clear();
        CustomAnimation.clear();
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        textureList.add((TextureFX)new Compass(minecraft));
        textureList.add((TextureFX)new Watch(minecraft));
        TexturePackBase selectedTexturePack = TextureUtils.getSelectedTexturePack();
        boolean bl = isDefault = selectedTexturePack == null || selectedTexturePack instanceof TexturePackDefault;
        if (!isDefault && customLava) {
            CustomAnimation.addStripOrTile("/terrain.png", "lava_still", 237, 1, -1, -1);
            CustomAnimation.addStripOrTile("/terrain.png", "lava_flowing", 238, 2, 3, 6);
        } else if (animatedLava) {
            textureList.add((TextureFX)new StillLava());
            textureList.add((TextureFX)new FlowLava());
        }
        if (!isDefault && customWater) {
            CustomAnimation.addStripOrTile("/terrain.png", "water_still", 205, 1, -1, -1);
            CustomAnimation.addStripOrTile("/terrain.png", "water_flowing", 206, 2, 0, 0);
        } else if (animatedWater) {
            textureList.add((TextureFX)new StillWater());
            textureList.add((TextureFX)new FlowWater());
        }
        if (!isDefault && customFire && TextureUtils.hasResource("/anim/custom_fire_e_w.png") && TextureUtils.hasResource("/anim/custom_fire_n_s.png")) {
            CustomAnimation.addStrip("/terrain.png", "fire_n_s", 47, 1);
            CustomAnimation.addStrip("/terrain.png", "fire_e_w", 31, 1);
        } else if (animatedFire) {
            textureList.add((TextureFX)new Fire(0));
            textureList.add((TextureFX)new Fire(1));
        }
        if (!isDefault && customPortal && TextureUtils.hasResource("/anim/custom_portal.png")) {
            CustomAnimation.addStrip("/terrain.png", "portal", 14, 1);
        } else if (animatedPortal) {
            textureList.add((TextureFX)new Portal());
        }
        if (customOther) {
            TextureUtils.addOtherTextureFX("/terrain.png", "terrain");
            TextureUtils.addOtherTextureFX("/gui/items.png", "item");
            if (!(selectedTexturePack instanceof TexturePackDefault)) {
                File folder;
                if (selectedTexturePack instanceof TexturePackCustom) {
                    TexturePackCustom custom = (TexturePackCustom)selectedTexturePack;
                    for (ZipEntry zipEntry : Collections.list(custom.zipFile.entries())) {
                        String name = "/" + zipEntry.getName();
                        if (!name.startsWith("/anim/") || !name.endsWith(".properties") || TextureUtils.isCustomTerrainItemResource(name)) continue;
                        InputStream inputStream = null;
                        try {
                            inputStream = custom.zipFile.getInputStream(zipEntry);
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            CustomAnimation.addStrip(properties);
                        }
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                MCPatcherUtils.close(inputStream);
                                throw throwable;
                            }
                            MCPatcherUtils.close(inputStream);
                            continue;
                        }
                        MCPatcherUtils.close(inputStream);
                    }
                } else if (selectedTexturePack instanceof TexturePackFolder && (folder = ((TexturePackFolder)selectedTexturePack).getFolder()) != null && (folder = new File(folder, "anim")).isDirectory()) {
                    for (File file : folder.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".properties") && !TextureUtils.isCustomTerrainItemResource("/anim/" + name);
                        }
                    })) {
                        FileInputStream inputStream = null;
                        try {
                            inputStream = new FileInputStream(file);
                            Properties properties = new Properties();
                            properties.load(inputStream);
                            CustomAnimation.addStrip(properties);
                        }
                        catch (IOException e) {
                            try {
                                e.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                MCPatcherUtils.close(inputStream);
                                throw throwable;
                            }
                            MCPatcherUtils.close(inputStream);
                            continue;
                        }
                        MCPatcherUtils.close(inputStream);
                    }
                }
            }
        }
        for (TextureFX t : savedTextureFX) {
            textureList.add(t);
        }
        for (TextureFX t : textureList) {
            t.onTick();
        }
        CustomAnimation.updateAll();
        if (ColorizerWater.colorBuffer != ColorizerFoliage.colorBuffer) {
            TextureUtils.refreshColorizer(ColorizerWater.colorBuffer, "/misc/watercolor.png");
        }
        TextureUtils.refreshColorizer(ColorizerGrass.colorBuffer, "/misc/grasscolor.png");
        TextureUtils.refreshColorizer(ColorizerFoliage.colorBuffer, "/misc/foliagecolor.png");
        System.gc();
    }

    private static void addOtherTextureFX(String textureName, String imageName) {
        for (int tileNum = 0; tileNum < 256; ++tileNum) {
            String resource = "/anim/custom_" + imageName + "_" + tileNum + ".png";
            if (!TextureUtils.hasResource(resource)) continue;
            CustomAnimation.addStrip(textureName, imageName + "_" + tileNum, tileNum, 1);
        }
    }

    public static TexturePackBase getSelectedTexturePack() {
        Minecraft minecraft = MCPatcherUtils.getMinecraft();
        return minecraft == null ? null : (minecraft.texturePackList == null ? null : minecraft.texturePackList.getSelectedTexturePack());
    }

    public static String getTexturePackName(TexturePackBase texturePack) {
        return texturePack == null ? "Default" : texturePack.texturePackFileName;
    }

    public static ByteBuffer getByteBuffer(ByteBuffer buffer, byte[] data) {
        buffer.clear();
        int have = buffer.capacity();
        int needed = data.length;
        if (needed > have || reclaimGLMemory && have >= 4 * needed) {
            buffer = GLAllocation.createDirectByteBuffer((int)needed);
        }
        buffer.put(data);
        buffer.position(0).limit(needed);
        TileSize.int_glBufferSize = needed;
        return buffer;
    }

    public static boolean isRequiredResource(String resource) {
        return resource.equals("/terrain.png") || resource.equals("/gui/items.png");
    }

    static boolean isCustomTerrainItemResource(String resource) {
        return (resource = resource.replaceFirst("^/anim", "").replaceFirst("\\.(png|properties)$", "")).equals("/custom_lava_still") || resource.equals("/custom_lava_flowing") || resource.equals("/custom_water_still") || resource.equals("/custom_water_flowing") || resource.equals("/custom_fire_n_s") || resource.equals("/custom_fire_e_w") || resource.equals("/custom_portal") || resource.matches("^/custom_(terrain|item)_\\d+$");
    }

    public static InputStream getResourceAsStream(TexturePackBase texturePack, String resource) {
        InputStream is = null;
        if (oldCreativeGui && resource.equals(ALL_ITEMS) && (is = TextureUtils.getResourceAsStream(texturePack, ALL_ITEMSX)) != null) {
            return is;
        }
        if (texturePack != null) {
            try {
                is = texturePack.getInputStream(resource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (is == null) {
            is = TextureUtils.class.getResourceAsStream(resource);
        }
        if (is == null && resource.startsWith("/anim/custom_")) {
            is = TextureUtils.getResourceAsStream(texturePack, resource.substring(5));
        }
        if (is == null && TextureUtils.isRequiredResource(resource)) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            MCPatcherUtils.warn("falling back on thread class loader for %s: %s", resource, is == null ? "failed" : "success");
        }
        return is;
    }

    public static InputStream getResourceAsStream(String resource) {
        return TextureUtils.getResourceAsStream(TextureUtils.getSelectedTexturePack(), resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceAsBufferedImage(TexturePackBase texturePack, String resource) throws IOException {
        InputStream is;
        BufferedImage image = null;
        boolean cached = false;
        if (useTextureCache && texturePack == lastTexturePack && (image = cache.get(resource)) != null) {
            cached = true;
        }
        if (image == null && (is = TextureUtils.getResourceAsStream(texturePack, resource)) != null) {
            try {
                image = ImageIO.read(is);
            }
            finally {
                MCPatcherUtils.close(is);
            }
        }
        if (image == null) {
            if (TextureUtils.isRequiredResource(resource)) {
                throw new IOException(resource + " image is null");
            }
            return null;
        }
        if (useTextureCache && !cached && texturePack != lastTexturePack) {
            MCPatcherUtils.debug("clearing texture cache (%d items)", cache.size());
            cache.clear();
        }
        MCPatcherUtils.debug("opened %s %dx%d from %s", resource, image.getWidth(), image.getHeight(), cached ? "cache" : TextureUtils.getTexturePackName(texturePack));
        if (!cached) {
            Integer i = TextureUtils.isCustomTerrainItemResource(resource) ? Integer.valueOf(1) : expectedColumns.get(resource);
            if (i != null && image.getWidth() != i * TileSize.int_size) {
                image = TextureUtils.resizeImage(image, i * TileSize.int_size);
            }
            if (useTextureCache) {
                lastTexturePack = texturePack;
                cache.put(resource, image);
            }
            if (resource.matches("^/mob/.*_eyes\\d*\\.png$")) {
                int p = 0;
                for (int x = 0; x < image.getWidth(); ++x) {
                    for (int y = 0; y < image.getHeight(); ++y) {
                        int argb = image.getRGB(x, y);
                        if ((argb & 0xFF000000) != 0 || argb == 0) continue;
                        image.setRGB(x, y, 0);
                        ++p;
                    }
                }
                if (p > 0) {
                    MCPatcherUtils.debug("  fixed %d transparent pixels", p, resource);
                }
            }
        }
        return image;
    }

    public static BufferedImage getResourceAsBufferedImage(String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(TextureUtils.getSelectedTexturePack(), resource);
    }

    public static BufferedImage getResourceAsBufferedImage(Object o1, String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(resource);
    }

    public static BufferedImage getResourceAsBufferedImage(Object o1, Object o2, String resource) throws IOException {
        return TextureUtils.getResourceAsBufferedImage(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTileSize(TexturePackBase texturePack) {
        int size = 0;
        for (Map.Entry<String, Integer> entry : expectedColumns.entrySet()) {
            InputStream is;
            block5: {
                is = null;
                try {
                    is = TextureUtils.getResourceAsStream(texturePack, entry.getKey());
                    if (is == null) break block5;
                    BufferedImage bi = ImageIO.read(is);
                    int newSize = bi.getWidth() / entry.getValue();
                    MCPatcherUtils.debug("  %s tile size is %d", entry.getKey(), newSize);
                    size = Math.max(size, newSize);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        MCPatcherUtils.close(is);
                        throw throwable;
                    }
                    MCPatcherUtils.close(is);
                    continue;
                }
            }
            MCPatcherUtils.close(is);
        }
        return size > 0 ? size : 16;
    }

    public static int getTileSize() {
        return TextureUtils.getTileSize(TextureUtils.getSelectedTexturePack());
    }

    public static boolean hasResource(TexturePackBase texturePack, String resource) {
        InputStream is = TextureUtils.getResourceAsStream(texturePack, resource);
        boolean has = is != null;
        MCPatcherUtils.close(is);
        return has;
    }

    public static boolean hasResource(String s) {
        return TextureUtils.hasResource(TextureUtils.getSelectedTexturePack(), s);
    }

    static BufferedImage resizeImage(BufferedImage image, int width) {
        int height = image.getHeight() * width / image.getWidth();
        MCPatcherUtils.debug("  resizing to %dx%d", width, height);
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    private static void refreshColorizer(int[] colorBuffer, String resource) {
        try {
            BufferedImage bi = TextureUtils.getResourceAsBufferedImage(resource);
            if (bi != null) {
                bi.getRGB(0, 0, 256, 256, colorBuffer, 0, 256);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openTexturePackFile(TexturePackCustom pack) {
        block7: {
            if (!autoRefreshTextures || pack.zipFile == null) {
                return;
            }
            FileInputStream input = null;
            FileOutputStream output = null;
            ZipFile newZipFile = null;
            try {
                int nread;
                pack.lastModified = pack.file.lastModified();
                pack.tmpFile = File.createTempFile("tmpmc", ".zip");
                pack.tmpFile.deleteOnExit();
                MCPatcherUtils.close(pack.zipFile);
                input = new FileInputStream(pack.file);
                output = new FileOutputStream(pack.tmpFile);
                byte[] buffer = new byte[65536];
                while ((nread = ((InputStream)input).read(buffer)) > 0) {
                    ((OutputStream)output).write(buffer, 0, nread);
                }
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                newZipFile = new ZipFile(pack.tmpFile);
                pack.origZip = pack.zipFile;
                pack.zipFile = newZipFile;
                newZipFile = null;
                MCPatcherUtils.debug("copied %s to %s, lastModified = %d", pack.file.getPath(), pack.tmpFile.getPath(), pack.lastModified);
                MCPatcherUtils.close(input);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(output);
                MCPatcherUtils.close(newZipFile);
            }
            MCPatcherUtils.close(output);
            MCPatcherUtils.close(newZipFile);
        }
    }

    public static void closeTexturePackFile(TexturePackCustom pack) {
        if (pack.origZip != null) {
            MCPatcherUtils.close(pack.zipFile);
            pack.zipFile = pack.origZip;
            pack.origZip = null;
            pack.tmpFile.delete();
            MCPatcherUtils.debug("deleted %s", pack.tmpFile.getPath());
            pack.tmpFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void checkTexturePackChange(Minecraft minecraft) {
        if (!autoRefreshTextures || ++textureRefreshCount < 16) {
            return;
        }
        textureRefreshCount = 0;
        TexturePackList list = minecraft.texturePackList;
        if (!(list.getSelectedTexturePack() instanceof TexturePackCustom)) {
            return;
        }
        TexturePackCustom pack = (TexturePackCustom)list.getSelectedTexturePack();
        long lastModified = pack.file.lastModified();
        if (lastModified == pack.lastModified || lastModified == 0L || pack.lastModified == 0L) {
            return;
        }
        MCPatcherUtils.debug("%s lastModified changed from %d to %d", pack.file.getPath(), pack.lastModified, lastModified);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(pack.file);
        }
        catch (IOException e) {
            MCPatcherUtils.close(zipFile);
            return;
            catch (Throwable throwable) {
                MCPatcherUtils.close(zipFile);
                throw throwable;
            }
        }
        MCPatcherUtils.close(zipFile);
        pack.closeTexturePackFile();
        list.updateAvailableTexturePacks();
        for (TexturePackBase tp : list.availableTexturePacks()) {
            if (!(tp instanceof TexturePackCustom)) continue;
            TexturePackCustom tpc = (TexturePackCustom)tp;
            if (!tpc.file.equals(pack.file)) continue;
            MCPatcherUtils.debug("setting new texture pack", new Object[0]);
            list.setTexturePack((TexturePackBase)tpc);
            minecraft.renderEngine.setTileSize(minecraft);
            return;
        }
        MCPatcherUtils.debug("selected texture pack not found after refresh, switching to default", new Object[0]);
        list.setTexturePack(list.getDefaultTexturePack());
        minecraft.renderEngine.setTileSize(minecraft);
    }

    public static boolean bindImageBegin() {
        if (bindImageReentry) {
            MCPatcherUtils.warn("caught TextureFX.bindImage recursion", new Object[0]);
            return false;
        }
        bindImageReentry = true;
        return true;
    }

    public static void bindImageEnd() {
        bindImageReentry = false;
    }

    static {
        expectedColumns = new HashMap();
        lastTexturePack = null;
        cache = new HashMap();
        animatedFire = MCPatcherUtils.getBoolean("HD Textures", "animatedFire", true);
        animatedLava = MCPatcherUtils.getBoolean("HD Textures", "animatedLava", true);
        animatedWater = MCPatcherUtils.getBoolean("HD Textures", "animatedWater", true);
        animatedPortal = MCPatcherUtils.getBoolean("HD Textures", "animatedPortal", true);
        customFire = MCPatcherUtils.getBoolean("HD Textures", "customFire", true);
        customLava = MCPatcherUtils.getBoolean("HD Textures", "customLava", true);
        customWater = MCPatcherUtils.getBoolean("HD Textures", "customWater", true);
        customPortal = MCPatcherUtils.getBoolean("HD Textures", "customPortal", true);
        customOther = MCPatcherUtils.getBoolean("HD Textures", "customOther", true);
        useTextureCache = MCPatcherUtils.getBoolean("HD Textures", "useTextureCache", false);
        reclaimGLMemory = MCPatcherUtils.getBoolean("HD Textures", "reclaimGLMemory", false);
        autoRefreshTextures = MCPatcherUtils.getBoolean("HD Textures", "autoRefreshTextures", false);
        expectedColumns.put("/terrain.png", 16);
        expectedColumns.put("/gui/items.png", 16);
        expectedColumns.put("/misc/dial.png", 1);
    }
}

