/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.MobOverlay;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.TexturePackBase;

public class MobRandomizer {
    private static final HashMap<String, MobInfo> mobHash = new HashMap();
    private static TexturePackBase lastTexturePack;
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static Method getBiomeNameAt;

    public static void reset() {
        MCPatcherUtils.debug("reset random mobs list", new Object[0]);
        mobHash.clear();
        MobOverlay.reset(lastTexturePack);
    }

    public static String randomTexture(EntityLiving entity) {
        return MobRandomizer.randomTexture(entity, entity.getEntityTexture());
    }

    public static String randomTexture(EntityLiving entity, String texture) {
        MobInfo mobInfo;
        TexturePackBase selectedTexturePack = MCPatcherUtils.getMinecraft().texturePackList.getSelectedTexturePack();
        if (lastTexturePack != selectedTexturePack) {
            lastTexturePack = selectedTexturePack;
            MobRandomizer.reset();
        }
        if (lastTexturePack == null || !texture.startsWith("/mob/") || !texture.endsWith(".png")) {
            return texture;
        }
        if (!entity.randomMobsSkinSet) {
            entity.randomMobsSkin = MobRandomizer.getSkinId(entity.entityId);
            entity.origX = (int)entity.posX;
            entity.origY = (int)entity.posY;
            entity.origZ = (int)entity.posZ;
            entity.randomMobsSkinSet = true;
        }
        if (entity.origBiome == null && getBiomeNameAt != null) {
            try {
                entity.origBiome = (String)getBiomeNameAt.invoke(null, entity.origX, entity.origY, entity.origZ);
            }
            catch (Throwable e) {
                getBiomeNameAt = null;
                e.printStackTrace();
            }
            if (entity.origBiome != null) {
                entity.origBiome = entity.origBiome.toLowerCase().replace(" ", "");
            }
        }
        if ((mobInfo = mobHash.get(texture)) == null) {
            mobInfo = new MobInfo(texture);
            mobHash.put(texture, mobInfo);
        }
        return mobInfo.getSkin(entity.randomMobsSkin, entity.origX, entity.origY, entity.origZ, entity.origBiome);
    }

    private static long getSkinId(int entityId) {
        long n = entityId;
        n = n ^ n << 16 ^ n << 32 ^ n << 48;
        n = 25214903917L * n + 11L;
        n = 25214903917L * n + 11L;
        return (n &= 0xFFFFFFFFFFFFL) >> 32 ^ n;
    }

    static {
        Method method = null;
        try {
            Class<?> biomeHelperClass = Class.forName("com.pclewis.mcpatcher.mod.BiomeHelper");
            method = biomeHelperClass.getDeclaredMethod("getBiomeNameAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        getBiomeNameAt = method;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SkinEntry {
        final int[] skins;
        final HashSet<String> biomes;
        final int minHeight;
        final int maxHeight;

        static SkinEntry load(Properties properties, int index, int limit) {
            int i;
            int[] skins;
            String skinList = properties.getProperty("skins." + index, "").trim().toLowerCase();
            if (skinList.equals("*") || skinList.equals("all") || skinList.equals("any")) {
                skins = new int[limit];
                for (i = 0; i < skins.length; ++i) {
                    skins[i] = i;
                }
            } else {
                skins = MCPatcherUtils.parseIntegerList(skinList, 1, limit);
                if (skins.length <= 0) {
                    return null;
                }
                i = 0;
                while (i < skins.length) {
                    int n = i++;
                    skins[n] = skins[n] - 1;
                }
            }
            HashSet<String> biomes = new HashSet<String>();
            String biomeList = properties.getProperty("biomes." + index, "").trim().toLowerCase();
            if (!biomeList.equals("")) {
                Collections.addAll(biomes, biomeList.split("\\s+"));
            }
            if (biomes.isEmpty()) {
                biomes = null;
            }
            int maxHeight = -1;
            int minHeight = -1;
            try {
                maxHeight = Integer.parseInt(properties.getProperty("maxHeight." + index, "-1").trim());
                minHeight = Integer.parseInt(properties.getProperty("minHeight." + index, "-1").trim());
                if (minHeight < 0 || minHeight > maxHeight) {
                    minHeight = -1;
                    maxHeight = -1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            return new SkinEntry(skins, biomes, minHeight, maxHeight);
        }

        SkinEntry(int[] skins, HashSet<String> biomes, int minHeight, int maxHeight) {
            this.skins = skins;
            this.biomes = biomes;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        boolean match(int i, int j, int k, String biome) {
            if (this.biomes != null && this.biomes.contains(biome)) {
                return false;
            }
            return this.minHeight < 0 || j >= this.minHeight && j <= this.maxHeight;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("skins:");
            for (int i : this.skins) {
                sb.append(' ').append(i + 1);
            }
            if (this.biomes != null) {
                sb.append(", biomes:");
                for (String s : this.biomes) {
                    sb.append(' ').append(s);
                }
            }
            if (this.minHeight >= 0) {
                sb.append(", height: ").append(this.minHeight).append('-').append(this.maxHeight);
            }
            return sb.toString();
        }
    }

    private static class MobInfo {
        final String baseSkin;
        final ArrayList<String> allSkins;
        final int skinCount;
        final ArrayList<SkinEntry> entries;

        MobInfo(String baseSkin) {
            this.baseSkin = baseSkin;
            this.allSkins = new ArrayList();
            this.allSkins.add(baseSkin);
            int i = 2;
            while (true) {
                String skin = baseSkin.replace(".png", "" + i + ".png");
                if (MCPatcherUtils.readImage(lastTexturePack.getInputStream(skin)) == null) break;
                this.allSkins.add(skin);
                ++i;
            }
            this.skinCount = this.allSkins.size();
            if (this.skinCount <= 1) {
                this.entries = null;
                return;
            }
            MCPatcherUtils.debug("found %d variations for %s", this.skinCount, baseSkin);
            String filename = baseSkin.replace(".png", ".properties");
            String altFilename = filename.replaceFirst("_(eyes|overlay|tame|angry)\\.properties$", ".properties");
            Properties properties = MCPatcherUtils.readProperties(lastTexturePack.getInputStream(filename));
            if (properties == null && !filename.equals(altFilename) && (properties = MCPatcherUtils.readProperties(lastTexturePack.getInputStream(altFilename))) != null) {
                MCPatcherUtils.debug("using %s for %s", altFilename, baseSkin);
            }
            ArrayList<SkinEntry> tmpEntries = new ArrayList<SkinEntry>();
            if (properties != null) {
                int i2 = 0;
                while (true) {
                    SkinEntry entry;
                    if ((entry = SkinEntry.load(properties, i2, this.skinCount)) == null) {
                        if (i2 > 0) {
                            break;
                        }
                    } else {
                        MCPatcherUtils.debug("  %s", entry.toString());
                        tmpEntries.add(entry);
                    }
                    ++i2;
                }
            }
            this.entries = tmpEntries.isEmpty() ? null : tmpEntries;
        }

        String getSkin(long key, int i, int j, int k, String biome) {
            if (this.entries == null) {
                int index = (int)(key % (long)this.skinCount);
                if (index < 0) {
                    index += this.skinCount;
                }
                return this.allSkins.get(index);
            }
            for (SkinEntry entry : this.entries) {
                if (!entry.match(i, j, k, biome)) continue;
                int n = entry.skins.length;
                int index = (int)(key % (long)n);
                if (index < 0) {
                    index += n;
                }
                return this.allSkins.get(entry.skins[index]);
            }
            return this.baseSkin;
        }
    }
}

