/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.MobRandomizer;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TexturePackBase;

public class MobOverlay {
    private static final String MOOSHROOM_OVERLAY = "/mob/redcow_overlay.png";
    private static final String SNOWMAN_OVERLAY = "/mob/snowman_overlay.png";
    private static final double MOO_X0 = -0.45;
    private static final double MOO_X1 = 0.45;
    private static final double MOO_Y0 = -0.5;
    private static final double MOO_Y1 = 0.5;
    private static final double MOO_Z0 = -0.45;
    private static final double MOO_Z1 = 0.45;
    private static final double SNOW_X0 = -0.5;
    private static final double SNOW_X1 = 0.5;
    private static final double SNOW_Y0 = -0.5;
    private static final double SNOW_Y1 = 0.5;
    private static final double SNOW_Z0 = -0.5;
    private static final double SNOW_Z1 = 0.5;
    private static boolean overlayActive;
    private static int overlayCounter;
    private static boolean haveMooshroom;
    private static boolean haveSnowman;
    public static String snowmanOverlayTexture;

    static void reset(TexturePackBase texturePack) {
        haveMooshroom = MCPatcherUtils.readImage(texturePack.getInputStream(MOOSHROOM_OVERLAY)) != null;
        haveSnowman = MCPatcherUtils.readImage(texturePack.getInputStream(SNOWMAN_OVERLAY)) != null;
    }

    public static String setupMooshroom(EntityLiving entity, String defaultTexture) {
        overlayCounter = 0;
        if (haveMooshroom) {
            overlayActive = true;
            return MobRandomizer.randomTexture(entity, MOOSHROOM_OVERLAY);
        }
        overlayActive = false;
        return defaultTexture;
    }

    public static boolean renderMooshroomOverlay() {
        if (overlayActive && overlayCounter < 3) {
            float tileX0 = (float)overlayCounter / 3.0f;
            float tileX1 = (float)(++overlayCounter) / 3.0f;
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-0.45, 0.5, -0.45, (double)tileX0, 0.0);
            tessellator.addVertexWithUV(-0.45, -0.5, -0.45, (double)tileX0, 1.0);
            tessellator.addVertexWithUV(0.45, -0.5, 0.45, (double)tileX1, 1.0);
            tessellator.addVertexWithUV(0.45, 0.5, 0.45, (double)tileX1, 0.0);
            tessellator.addVertexWithUV(0.45, 0.5, 0.45, (double)tileX0, 0.0);
            tessellator.addVertexWithUV(0.45, -0.5, 0.45, (double)tileX0, 1.0);
            tessellator.addVertexWithUV(-0.45, -0.5, -0.45, (double)tileX1, 1.0);
            tessellator.addVertexWithUV(-0.45, 0.5, -0.45, (double)tileX1, 0.0);
            tessellator.addVertexWithUV(-0.45, 0.5, 0.45, (double)tileX0, 0.0);
            tessellator.addVertexWithUV(-0.45, -0.5, 0.45, (double)tileX0, 1.0);
            tessellator.addVertexWithUV(0.45, -0.5, -0.45, (double)tileX1, 1.0);
            tessellator.addVertexWithUV(0.45, 0.5, -0.45, (double)tileX1, 0.0);
            tessellator.addVertexWithUV(0.45, 0.5, -0.45, (double)tileX0, 0.0);
            tessellator.addVertexWithUV(0.45, -0.5, -0.45, (double)tileX0, 1.0);
            tessellator.addVertexWithUV(-0.45, -0.5, 0.45, (double)tileX1, 1.0);
            tessellator.addVertexWithUV(-0.45, 0.5, 0.45, (double)tileX1, 0.0);
            tessellator.draw();
        }
        return overlayActive;
    }

    public static void finishMooshroom() {
        overlayCounter = 0;
        overlayActive = false;
    }

    public static boolean setupSnowman(EntityLiving entity) {
        if (haveSnowman) {
            snowmanOverlayTexture = MobRandomizer.randomTexture(entity, SNOWMAN_OVERLAY);
            return true;
        }
        snowmanOverlayTexture = null;
        return false;
    }

    public static void renderSnowmanOverlay() {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        double[] c = new double[4];
        MobOverlay.getTileCoordinates(0, c);
        tessellator.addVertexWithUV(0.5, -0.5, -0.5, c[0], c[2]);
        tessellator.addVertexWithUV(0.5, -0.5, 0.5, c[1], c[2]);
        tessellator.addVertexWithUV(-0.5, -0.5, 0.5, c[1], c[3]);
        tessellator.addVertexWithUV(-0.5, -0.5, -0.5, c[0], c[3]);
        MobOverlay.getTileCoordinates(1, c);
        tessellator.addVertexWithUV(-0.5, 0.5, -0.5, c[0], c[2]);
        tessellator.addVertexWithUV(-0.5, 0.5, 0.5, c[1], c[2]);
        tessellator.addVertexWithUV(0.5, 0.5, 0.5, c[1], c[3]);
        tessellator.addVertexWithUV(0.5, 0.5, -0.5, c[0], c[3]);
        MobOverlay.getTileCoordinates(2, c);
        tessellator.addVertexWithUV(-0.5, 0.5, 0.5, c[0], c[2]);
        tessellator.addVertexWithUV(-0.5, 0.5, -0.5, c[1], c[2]);
        tessellator.addVertexWithUV(-0.5, -0.5, -0.5, c[1], c[3]);
        tessellator.addVertexWithUV(-0.5, -0.5, 0.5, c[0], c[3]);
        MobOverlay.getTileCoordinates(3, c);
        tessellator.addVertexWithUV(-0.5, 0.5, -0.5, c[0], c[2]);
        tessellator.addVertexWithUV(0.5, 0.5, -0.5, c[1], c[2]);
        tessellator.addVertexWithUV(0.5, -0.5, -0.5, c[1], c[3]);
        tessellator.addVertexWithUV(-0.5, -0.5, -0.5, c[0], c[3]);
        MobOverlay.getTileCoordinates(4, c);
        tessellator.addVertexWithUV(0.5, 0.5, -0.5, c[0], c[2]);
        tessellator.addVertexWithUV(0.5, 0.5, 0.5, c[1], c[2]);
        tessellator.addVertexWithUV(0.5, -0.5, 0.5, c[1], c[3]);
        tessellator.addVertexWithUV(0.5, -0.5, -0.5, c[0], c[3]);
        MobOverlay.getTileCoordinates(5, c);
        tessellator.addVertexWithUV(0.5, 0.5, 0.5, c[0], c[2]);
        tessellator.addVertexWithUV(-0.5, 0.5, 0.5, c[1], c[2]);
        tessellator.addVertexWithUV(-0.5, -0.5, 0.5, c[1], c[3]);
        tessellator.addVertexWithUV(0.5, -0.5, 0.5, c[0], c[3]);
        tessellator.draw();
    }

    private static void getTileCoordinates(int tileNum, double[] c) {
        c[0] = (double)(tileNum % 3) / 3.0;
        c[1] = c[0] + 0.3333333333333333;
        c[2] = (double)(tileNum / 3) / 2.0;
        c[3] = c[2] + 0.5;
    }
}

