/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FixedBytecodeSignature;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.OrSignature;
import java.io.IOException;
import javassist.bytecode.BadBytecode;

public class GLSLShader
extends Mod {
    private final boolean haveNewWorld;

    public GLSLShader(MinecraftVersion minecraftVersion) {
        this.name = "GLSL Shaders";
        this.author = "daxnitro";
        this.description = "Adds graphical shaders to the game.  Based on daxnitro's mod.";
        this.version = "2.0";
        this.website = "http://daxnitro.wikia.com/wiki/Shaders_2.0";
        this.defaultEnabled = false;
        this.haveNewWorld = minecraftVersion.compareTo("12w18a") >= 0;
        this.classMods.add(new MinecraftMod(minecraftVersion));
        this.classMods.add(new BaseMod.GLAllocationMod());
        this.classMods.add(new RenderEngineMod());
        this.classMods.add(new RenderGlobalMod());
        this.classMods.add(new RenderLivingMod());
        this.classMods.add(new EntityRendererMod());
        this.classMods.add(new EntityLivingMod());
        this.classMods.add(new BlockMod());
        this.classMods.add(new GameSettingsMod());
        this.classMods.add(new TessellatorMod());
        this.classMods.add(new RenderBlocksMod());
        this.classMods.add(new EntityPlayerMod());
        this.classMods.add(new EntityPlayerSPMod());
        if (this.haveNewWorld) {
            this.classMods.add(new EntityPlayerSPSubMod());
        }
        this.classMods.add(new InventoryPlayerMod(minecraftVersion));
        this.classMods.add(new ItemStackMod());
        this.classMods.add(new WorldMod());
        if (this.haveNewWorld) {
            this.classMods.add(new BaseMod.WorldServerMod(minecraftVersion));
            this.classMods.add(new BaseMod.WorldServerMPMod(minecraftVersion));
        }
        this.classMods.add(new WorldRendererMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.Shaders"));
    }

    private class WorldRendererMod
    extends ClassMod {
        WorldRendererMod() {
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            this.classSignatures.add(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.000001f)));
                }
            }.setMethod(updateRenderer));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "worldObj", "LWorld;")));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "call Tessellator.setEntity";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, BytecodeMatcher.anyALOAD, BinaryRegex.capture(BytecodeMatcher.anyALOAD), BytecodeMatcher.anyILOAD, BytecodeMatcher.anyILOAD, BytecodeMatcher.anyILOAD, this.reference(182, new MethodRef("RenderBlocks", "renderBlockByRenderType", "(LBlock;III)Z")), 128, BytecodeMatcher.anyISTORE);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), this.getCaptureGroup(1), this.reference(180, new FieldRef("Block", "blockID", "I")), this.reference(182, new MethodRef("Tessellator", "setEntity", "(I)V")));
                }
            }.targetMethod(updateRenderer));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "clear Tessellator.setEntity";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177, BinaryRegex.end());
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), 2, this.reference(182, new MethodRef("Tessellator", "setEntity", "(I)V")));
                }
            }.targetMethod(updateRenderer));
        }
    }

    private class WorldMod
    extends BaseMod.WorldMod {
        WorldMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(12, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf((float)Math.PI)), 106, 13, 106, BytecodeMatcher.anyReference(184), 13, 106, BinaryRegex.or(BinaryRegex.build(this.push(Float.valueOf(0.75f))), BinaryRegex.build(this.push(Float.valueOf(0.25f)))), 98, 102);
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "getStarBrightness", "(F)F")));
            this.classSignatures.add(new FixedBytecodeSignature(BinaryRegex.begin(), 42, 27, 28, 29, 4, BytecodeMatcher.anyReference(182), 172, BinaryRegex.end()).setMethod(new MethodRef(this.getDeobfClass(), "getBlockLightValue", "(III)I")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, 43, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(181), 43, 43, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(181), 43, 43, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(181));
                }
            }.addXref(1, new FieldRef("Entity", "posX", "D")).addXref(2, new FieldRef("Entity", "lastTickPosX", "D")).addXref(3, new FieldRef("Entity", "posY", "D")).addXref(4, new FieldRef("Entity", "lastTickPosY", "D")).addXref(5, new FieldRef("Entity", "posZ", "D")).addXref(6, new FieldRef("Entity", "lastTickPosZ", "D")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 35, BytecodeMatcher.captureReference(182), 69, 36, this.push(Float.valueOf((float)Math.PI)), 106, this.push(Float.valueOf(2.0f)), 106, 174, BinaryRegex.end());
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "getCelestialAngleRadians", "(F)F")).addXref(1, new MethodRef(this.getDeobfClass(), "getCelestialAngle", "(F)F")));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getSeed", "()J"), new MethodRef(this.getDeobfClass(), "getWorldTime", "()J")));
        }
    }

    private class ItemStackMod
    extends ClassMod {
        ItemStackMod() {
            this.classSignatures.add(new ConstSignature("id"));
            this.classSignatures.add(new ConstSignature("Count"));
            this.classSignatures.add(new ConstSignature("Damage"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "stackSize", "I"), new FieldRef(this.getDeobfClass(), "animationsToGo", "I"), new FieldRef(this.getDeobfClass(), "itemID", "I")).accessFlag(1, true));
        }
    }

    private class InventoryPlayerMod
    extends ClassMod {
        InventoryPlayerMod(MinecraftVersion minecraftVersion) {
            if (minecraftVersion.compareTo("12w04a") >= 0) {
                this.classSignatures.add(new ConstSignature("container.inventory"));
            } else {
                this.classSignatures.add(new ConstSignature("Inventory"));
            }
            this.classSignatures.add(new ConstSignature("Slot"));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getCurrentItem", "()LItemStack;")));
        }
    }

    private class EntityPlayerSPSubMod
    extends ClassMod {
        EntityPlayerSPSubMod() {
            this.parentClass = "EntityPlayerSP";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(-999.0), this.push(-999.0));
                }
            });
        }
    }

    private class EntityPlayerSPMod
    extends ClassMod {
        EntityPlayerSPMod() {
            this.parentClass = "EntityPlayer";
            this.classSignatures.add(new OrSignature(new ConstSignature("http://s3.amazonaws.com/MinecraftSkins/"), new ConstSignature("http://skins.minecraft.net/MinecraftSkins/")));
            this.classSignatures.add(new ConstSignature("portal.trigger"));
        }
    }

    private class EntityPlayerMod
    extends ClassMod {
        EntityPlayerMod() {
            this.classSignatures.add(new ConstSignature("humanoid"));
            this.classSignatures.add(new ConstSignature("/mob/char.png"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "inventory", "LInventoryPlayer;")));
        }
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        private final MethodRef[] faceMethods = new MethodRef[6];

        RenderBlocksMod() {
            this.setupBlockFace(0, "Bottom", 0, -1, 0);
            this.setupBlockFace(1, "Top", 0, 1, 0);
            this.setupBlockFace(2, "North", 0, 0, -1);
            this.setupBlockFace(3, "South", 0, 0, 1);
            this.setupBlockFace(4, "West", -1, 0, 0);
            this.setupBlockFace(5, "East", 1, 0, 0);
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, this.faceMethods));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "renderBlockByRenderType", "(LBlock;III)Z")));
        }

        private void setupBlockFace(int face, final String direction, final int x, final int y, final int z) {
            this.faceMethods[face] = new MethodRef(this.getDeobfClass(), "render" + direction + "Face", "(LBlock;DDDI)V");
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "set normal when rendering block " + direction.toLowerCase() + " face";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), 58, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(25, this.getCaptureGroup(1), this.push(Float.valueOf(x)), this.push(Float.valueOf(y)), this.push(Float.valueOf(z)), this.reference(182, new MethodRef("Tessellator", "setNormal", "(FFF)V")));
                }
            }.targetMethod(this.faceMethods[face]));
        }
    }

    private class TessellatorMod
    extends ClassMod {
        TessellatorMod() {
            MethodRef reset = new MethodRef(this.getDeobfClass(), "reset", "()V");
            MethodRef draw = new MethodRef(this.getDeobfClass(), "draw", "()I");
            MethodRef addVertex = new MethodRef(this.getDeobfClass(), "addVertex", "(DDD)V");
            final FieldRef drawMode = new FieldRef(this.getDeobfClass(), "drawMode", "I");
            final FieldRef addedVertices = new FieldRef(this.getDeobfClass(), "addedVertices", "I");
            final FieldRef convertQuadsToTriangles = new FieldRef(this.getDeobfClass(), "convertQuadsToTriangles", "Z");
            final FieldRef hasNormals = new FieldRef(this.getDeobfClass(), "hasNormals", "Z");
            final FieldRef rawBuffer = new FieldRef(this.getDeobfClass(), "rawBuffer", "[I");
            final FieldRef rawBufferIndex = new FieldRef(this.getDeobfClass(), "rawBufferIndex", "I");
            final FieldRef shadersBuffer = new FieldRef(this.getDeobfClass(), "shadersBuffer", "Ljava/nio/ByteBuffer;");
            final FieldRef shadersShortBuffer = new FieldRef(this.getDeobfClass(), "shadersShortBuffer", "Ljava/nio/ShortBuffer;");
            final FieldRef shadersData = new FieldRef(this.getDeobfClass(), "shadersData", "[S");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("Not tesselating!"));
                }
            }.setMethod(draw));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, new MethodRef("java/nio/ByteBuffer", "clear", "()Ljava/nio/Buffer;"))});
                }
            }.setMethod(reset));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, 4, BytecodeMatcher.captureReference(181), 35, this.push(Float.valueOf(127.0f)), 106, 139, 145, BytecodeMatcher.anyISTORE, 36, this.push(Float.valueOf(127.0f)), 106, 139, 145, BytecodeMatcher.anyISTORE, 37, this.push(Float.valueOf(127.0f)), 106, 139, 145, BytecodeMatcher.anyISTORE, 42, BinaryRegex.any(0, 30), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "setNormal", "(FFF)V")).addXref(1, hasNormals).addXref(2, new FieldRef(this.getDeobfClass(), "normal", "I")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181), 42, BytecodeMatcher.captureReference(180), this.push(7), 160, BinaryRegex.any(2));
                }
            }.setMethod(addVertex).addXref(1, addedVertices).addXref(2, drawMode));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 3, 42, BytecodeMatcher.captureReference(180), this.reference(182, new MethodRef("java/nio/IntBuffer", "put", "([III)Ljava/nio/IntBuffer;")));
                }
            }.addXref(1, rawBuffer).addXref(2, rawBufferIndex));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.anyReference(180), this.push(7), 160, BinaryRegex.any(2), BytecodeMatcher.captureReference(178), 153, BinaryRegex.any(2));
                }
            }.addXref(1, convertQuadsToTriangles));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "instance", "LTessellator;")).accessFlag(8, true));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "shadersBuffer", "Ljava.nio.ByteBuffer;")));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "shadersShortBuffer", "Ljava.nio.ShortBuffer;")));
            this.patches.add(new AddFieldPatch(shadersData));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "initialize shadersData";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(177);
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, 5, 188, 9, 89, 3, 2, 86, this.reference(181, shadersData), 42, 27, this.push(8), 108, 7, 104, this.reference(184, new MethodRef("GLAllocation", "createDirectByteBuffer", "(I)Ljava/nio/ByteBuffer;")), this.reference(181, shadersBuffer), 42, 42, this.reference(180, shadersBuffer), this.reference(182, new MethodRef("java/nio/ByteBuffer", "asShortBuffer", "()Ljava/nio/ShortBuffer;")), this.reference(181, shadersShortBuffer));
                }
            });
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "setEntity", "(I)V")){

                public byte[] generateMethod() throws BadBytecode, IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Shaders", "entityAttrib", "I")), 155, TessellatorMod.this.branch("A"), 42, this.reference(180, shadersData), 3, 27, 147, 86, TessellatorMod.this.label("A"), 177);
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "clear shadersBuffer";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, shadersBuffer), this.reference(182, new MethodRef("java/nio/ByteBuffer", "clear", "()Ljava/nio/Buffer;")), 87);
                }
            }.targetMethod(reset));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap glDrawArrays";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glDrawArrays", "(III)V"))});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, shadersShortBuffer), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "glDrawArraysWrapper", "(IIILjava/nio/ShortBuffer;)V")));
                }
            }.targetMethod(draw));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "call Shaders.addVertex";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, drawMode), this.push(7), 160, TessellatorMod.this.branch("A"), this.reference(178, convertQuadsToTriangles), 153, TessellatorMod.this.branch("A"), 42, this.reference(180, addedVertices), 4, 96, 7, 112, 154, TessellatorMod.this.branch("A"), 42, this.reference(180, hasNormals), 153, TessellatorMod.this.branch("A"), this.getRawBufferCode(6, -18), this.getShaderBufferCode(), this.getRawBufferCode(14, -2), this.getShaderBufferCode(), TessellatorMod.this.label("A"), this.getShaderBufferCode());
                }

                private byte[] getRawBufferCode(int offset1, int offset2) throws IOException {
                    return this.buildCode(42, this.reference(180, rawBuffer), 42, this.reference(180, rawBufferIndex), this.push(offset1), 96, 42, this.reference(180, rawBuffer), 42, this.reference(180, rawBufferIndex), this.push(offset2), 96, 46, 79);
                }

                private byte[] getShaderBufferCode() throws IOException {
                    return this.buildCode(42, this.reference(180, shadersBuffer), 42, this.reference(180, shadersData), 3, 53, this.reference(182, new MethodRef("java/nio/ByteBuffer", "putShort", "(S)Ljava/nio/ByteBuffer;")), 42, this.reference(180, shadersData), 4, 53, this.reference(182, new MethodRef("java/nio/ByteBuffer", "putShort", "(S)Ljava/nio/ByteBuffer;")), 87);
                }
            }.targetMethod(addVertex));
        }
    }

    private class GameSettingsMod
    extends BaseMod.GameSettingsMod {
        GameSettingsMod() {
            this.mapOption("viewDistance", "renderDistance", "I");
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "lightOpacity", "[I"), new FieldRef(this.getDeobfClass(), "lightValue", "[I")).accessFlag(1, true).accessFlag(8, true).accessFlag(16, true));
        }
    }

    private class EntityLivingMod
    extends ClassMod {
        EntityLivingMod() {
            this.parentClass = "Entity";
            this.classSignatures.add(new ConstSignature("/mob/char.png"));
            this.classSignatures.add(new ConstSignature("bubble"));
        }
    }

    private class EntityRendererMod
    extends ClassMod {
        EntityRendererMod() {
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new ConstSignature("/environment/snow.png"));
            this.classSignatures.add(new ConstSignature("ambient.weather.rain"));
            final MethodRef setupCameraTransform = new MethodRef(this.getDeobfClass(), "setupCameraTransform", "(FI)V");
            MethodRef renderWorld = new MethodRef(this.getDeobfClass(), "renderWorld", "(FJ)V");
            final MethodRef renderRainSnow = new MethodRef(this.getDeobfClass(), "renderRainSnow", "(F)V");
            final MethodRef renderHand = new MethodRef(this.getDeobfClass(), "renderHand", "(FI)V");
            final FieldRef fogColorRed = new FieldRef(this.getDeobfClass(), "fogColorRed", "F");
            final FieldRef fogColorGreen = new FieldRef(this.getDeobfClass(), "fogColorGreen", "F");
            final FieldRef fogColorBlue = new FieldRef(this.getDeobfClass(), "fogColorBlue", "F");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(2918), 42, 42, BytecodeMatcher.captureReference(180), 42, BytecodeMatcher.captureReference(180), 42, BytecodeMatcher.captureReference(180), this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyReference(183), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glFog", "(ILjava/nio/FloatBuffer;)V")));
                }
            }.addXref(1, fogColorRed).addXref(2, fogColorGreen).addXref(3, fogColorBlue));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(5889), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glMatrixMode", "(I)V")), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glLoadIdentity", "()V")));
                }
            }.setMethod(setupCameraTransform));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/environment/snow.png"));
                }
            }.setMethod(renderRainSnow));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(256), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glClear", "(I)V")), 42, 35, BytecodeMatcher.anyILOAD, BytecodeMatcher.captureReference(183));
                }
            }.setMethod(renderWorld).addXref(1, renderHand));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;")));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, renderWorld));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "disableLightmap", "(D)V"), new MethodRef(this.getDeobfClass(), "enableLightmap", "(D)V")));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "call beginRender";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, new FieldRef(EntityRendererMod.this.getDeobfClass(), "mc", "LMinecraft;")), 35, 32, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "beginRender", "(LMinecraft;FJ)V")));
                }
            }.targetMethod(renderWorld));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "call endRender";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "endRender", "()V"))});
                }
            }.targetMethod(renderWorld));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "call setClearColor / setCamera";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 35, BytecodeMatcher.anyILOAD, this.reference(183, setupCameraTransform));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, fogColorRed), 42, this.reference(180, fogColorGreen), 42, this.reference(180, fogColorBlue), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "setClearColor", "(FFF)V")), this.getMatch(), 35, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "setCamera", "(F)V")));
                }
            }.targetMethod(renderWorld));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap terrain and water rendering";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, new MethodRef("RenderGlobal", "sortAndRender", "(LEntityLiving;ID)I"))});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "sortAndRenderWrapper", "(LRenderGlobal;LEntityLiving;ID)I"))});
                }
            }.targetMethod(renderWorld));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap water rendering";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, BinaryRegex.or(BinaryRegex.build(4), BinaryRegex.build(42, BytecodeMatcher.anyReference(180))), 35, 141, this.reference(182, new MethodRef("RenderGlobal", "renderAllRenderLists", "(ID)V")));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "beginWater", "()V")), this.getMatch(), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "endWater", "()V")));
                }
            }.targetMethod(renderWorld));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap weather rendering";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 35, this.reference(182, renderRainSnow));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "beginWeather", "()V")), this.getMatch(), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "endWeather", "()V")));
                }
            }.targetMethod(renderWorld));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap hand rendering";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 35, BytecodeMatcher.anyILOAD, this.reference(183, renderHand));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "beginHand", "()V")), this.getMatch(), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "endHand", "()V")));
                }
            }.targetMethod(renderWorld));
            this.addLightmapPatch("enableLightmap");
            this.addLightmapPatch("disableLightmap");
        }

        private void addLightmapPatch(final String name) {
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "wrap " + name;
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", name, "()V"))});
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), name, "(D)V")));
        }
    }

    private class RenderLivingMod
    extends ClassMod {
        RenderLivingMod() {
            this.classSignatures.add(new ConstSignature("deadmau5"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(514), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glDepthFunc", "(I)V")));
                }
            });
            this.addGLWrapper("glEnable");
            this.addGLWrapper("glDisable");
        }

        private void addGLWrapper(final String name) {
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap " + name;
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", name, "(I)V"))});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", name + "Wrapper", "(I)V"))});
                }
            });
        }
    }

    private class RenderGlobalMod
    extends ClassMod {
        RenderGlobalMod() {
            MethodRef renderSky = new MethodRef(this.getDeobfClass(), "renderSky", "(F)V");
            final String worldClass = GLSLShader.this.haveNewWorld ? "WorldServerMP" : "World";
            final FieldRef worldObj = new FieldRef(this.getDeobfClass(), "worldObj", "L" + worldClass + ";");
            this.classSignatures.add(new ConstSignature("smoke"));
            this.classSignatures.add(new ConstSignature("/environment/clouds.png"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.2f)), 106, this.push(Float.valueOf(0.04f)), 98, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.2f)), 106, this.push(Float.valueOf(0.04f)), 98, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.1f)), 98, this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glColor3f", "(FFF)V")));
                }
            }.setMethod(renderSky));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "sortAndRender", "(LEntityLiving;ID)I")));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "renderAllRenderLists", "(ID)V")));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, worldObj));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "call setCelestialPosition";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, worldObj), 35, this.reference(182, new MethodRef(worldClass, "getStarBrightness", "(F)F")), BytecodeMatcher.anyFLOAD, 106, BytecodeMatcher.anyFSTORE);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", "setCelestialPosition", "()V"))});
                }
            }.targetMethod(renderSky));
            this.addGLWrapper("glEnable");
            this.addGLWrapper("glDisable");
        }

        private void addGLWrapper(final String name) {
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "wrap " + name;
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", name, "(I)V"))});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Shaders", name + "Wrapper", "(I)V"))});
                }
            });
        }
    }

    private class RenderEngineMod
    extends ClassMod {
        RenderEngineMod() {
            this.classSignatures.add(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().equals("()V") && !this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(this.push("%clamp%"));
                    }
                    return null;
                }
            }.setMethodName("refreshTextures"));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getTexture", "(Ljava/lang/String;)I")));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod(MinecraftVersion minecraftVersion) {
            final FieldRef thePlayer = new FieldRef(this.getDeobfClass(), "thePlayer", "LEntityPlayerSP;");
            final FieldRef playerSub = new FieldRef(this.getDeobfClass(), "playerSub", "LEntityPlayerSPSub;");
            MethodRef getPlayer = new MethodRef(this.getDeobfClass(), "getPlayer", "()LEntityPlayerSP;");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(184, new MethodRef("org/lwjgl/input/Keyboard", "getEventKey", "()I")), this.push(63), 160, BinaryRegex.any(2), 42, BytecodeMatcher.anyReference(180), 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181));
                }
            }.addXref(1, new FieldRef("GameSettings", "thirdPersonView", "I")));
            this.addWorldGetter(minecraftVersion);
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;")));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "gameSettings", "LGameSettings;")));
            if (GLSLShader.this.haveNewWorld) {
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, playerSub));
            } else {
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, thePlayer));
            }
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "entityRenderer", "LEntityRenderer;")));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "renderViewEntity", "LEntityLiving;")));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "displayWidth", "I"), new FieldRef(this.getDeobfClass(), "displayHeight", "I")).accessFlag(1, true).accessFlag(8, false).accessFlag(16, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getAppDir", "(Ljava/lang/String;)Ljava/io/File;")).accessFlag(1, true).accessFlag(8, true));
            this.patches.add(new AddMethodPatch(getPlayer){

                public byte[] generateMethod() throws BadBytecode, IOException {
                    return this.buildCode(42, this.reference(180, GLSLShader.this.haveNewWorld ? playerSub : thePlayer), 176);
                }
            });
        }
    }
}

