/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.FontRenderer;

public class FontUtils {
    private static final int ROWS = 16;
    private static final int COLS = 16;
    public static final char[] AVERAGE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123467890".toCharArray();
    public static final int[] SPACERS = new int[]{33721342, 0x2808080, 0xDFFFFFF};
    private static final boolean showLines = false;
    private static Method getResource;

    public static float[] computeCharWidths(String filename, BufferedImage image, int[] rgb, int[] charWidth, int fontHeight) {
        int ch;
        MCPatcherUtils.debug("computeCharWidths(%s)", filename);
        float[] charWidthf = new float[charWidth.length];
        int width = image.getWidth();
        int height = image.getHeight();
        int colWidth = width / 16;
        int rowHeight = height / 16;
        block2: for (ch = 0; ch < charWidth.length; ++ch) {
            int row = ch / 16;
            int col = ch % 16;
            for (int colIdx = colWidth - 1; colIdx >= 0; --colIdx) {
                int x = col * colWidth + colIdx;
                for (int rowIdx = 0; rowIdx < rowHeight; ++rowIdx) {
                    int y = row * rowHeight + rowIdx;
                    int pixel = rgb[x + y * width];
                    if (!FontUtils.isOpaque(pixel)) continue;
                    if (FontUtils.printThis(ch)) {
                        MCPatcherUtils.debug("'%c' pixel (%d, %d) = %08x, colIdx = %d", Character.valueOf((char)ch), x, y, pixel, colIdx);
                    }
                    charWidthf[ch] = 128.0f * (float)(colIdx + 1) / (float)width + 1.0f;
                    continue block2;
                }
            }
        }
        for (ch = 0; ch < charWidthf.length; ++ch) {
            if (charWidthf[ch] <= 0.0f) {
                charWidthf[ch] = 2.0f;
                continue;
            }
            if (!(charWidthf[ch] >= 7.99f)) continue;
            charWidthf[ch] = 7.99f;
        }
        boolean[] isOverride = new boolean[charWidth.length];
        try {
            FontUtils.getCharWidthOverrides(filename, charWidthf, isOverride);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!isOverride[32]) {
            charWidthf[32] = FontUtils.defaultSpaceWidth(charWidthf);
        }
        float fontScale = (float)fontHeight / 8.0f;
        for (int ch2 = 0; ch2 < charWidth.length; ++ch2) {
            charWidth[ch2] = Math.round(charWidthf[ch2]);
            int n = ch2;
            charWidthf[n] = charWidthf[n] * fontScale;
            if (!FontUtils.printThis(ch2)) continue;
            MCPatcherUtils.debug("charWidth['%c'] = %f", Character.valueOf((char)ch2), Float.valueOf(charWidthf[ch2]));
        }
        return charWidthf;
    }

    public static float getCharWidthf(FontRenderer fontRenderer, char ch) {
        float width = fontRenderer.getCharWidth(ch);
        if (width < 0.0f || ch >= fontRenderer.charWidthf.length || ch < '\u0000') {
            return width;
        }
        return fontRenderer.charWidthf[ch];
    }

    public static float getStringWidthf(FontRenderer fontRenderer, String s) {
        float totalWidth = 0.0f;
        if (s != null) {
            boolean isLink = false;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                float cWidth = fontRenderer.getCharWidth(c);
                if (cWidth < 0.0f && i < s.length() - 1) {
                    c = s.charAt(i + 1);
                    if (c == 'l' || c == 'L') {
                        isLink = true;
                    } else if (c == 'r' || c == 'R' || c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') {
                        isLink = false;
                    }
                    cWidth = fontRenderer.getCharWidth(c);
                }
                totalWidth += cWidth;
                if (!isLink) continue;
                totalWidth += 1.0f;
            }
        }
        return totalWidth;
    }

    private static boolean isOpaque(int pixel) {
        for (int i : SPACERS) {
            if (pixel != i) continue;
            return false;
        }
        return (pixel >> 24 & 0xF0) > 0;
    }

    private static boolean printThis(int ch) {
        return "ABCDEF abcdef".indexOf(ch) >= 0;
    }

    private static float defaultSpaceWidth(float[] charWidthf) {
        float sum = 0.0f;
        int n = 0;
        for (char ch : AVERAGE_CHARS) {
            if (!(charWidthf[ch] > 0.0f)) continue;
            sum += charWidthf[ch];
            ++n;
        }
        if (n > 0) {
            return sum / (float)n * 0.5f;
        }
        return 4.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getCharWidthOverrides(String font, float[] charWidthf, boolean[] isOverride) {
        InputStream is;
        if (getResource == null) {
            return;
        }
        String textFile = font.replace(".png", ".properties");
        try {
            Object o = getResource.invoke(null, textFile);
            if (!(o instanceof InputStream)) {
                return;
            }
            is = (InputStream)o;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        MCPatcherUtils.debug("reading character widths from %s", textFile);
        try {
            Properties props = new Properties();
            props.load(is);
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString().trim();
                String value = entry.getValue().toString().trim();
                if (!key.matches("^width\\.\\d+$") || value.equals("")) continue;
                try {
                    int ch = Integer.parseInt(key.substring(6));
                    float width = Float.parseFloat(value);
                    if (ch < 0 || ch >= charWidthf.length) continue;
                    MCPatcherUtils.debug("    setting charWidthf[%d] to %f", ch, Float.valueOf(width));
                    charWidthf[ch] = width;
                    isOverride[ch] = true;
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MCPatcherUtils.close(is);
        }
    }

    static {
        try {
            Class<?> utils = Class.forName("com.pclewis.mcpatcher.mod.TextureUtils");
            try {
                getResource = utils.getDeclaredMethod("getResourceAsStream", String.class);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

