/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FixedBytecodeSignature;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModConfigPanel;
import com.pclewis.mcpatcher.OrSignature;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomColors
extends Mod {
    private boolean haveSpawnerEggs;
    private boolean haveNewBiomes;
    private boolean haveFontColor;
    private boolean renderStringReturnsInt;
    private boolean haveNewWorld;
    private boolean renderBlockFallingSandTakes4Ints;
    private String getColorFromDamageDescriptor;
    private int getColorFromDamageParams;

    public CustomColors(MinecraftVersion minecraftVersion) {
        this.name = "Custom Colors";
        this.author = "MCPatcher";
        this.description = "Gives texture packs control over hardcoded colors in the game.";
        this.version = "1.4";
        if (minecraftVersion.compareTo("Beta 1.9 Prerelease 4") < 0) {
            this.addError("Requires Minecraft Beta 1.9 or newer.");
            return;
        }
        this.haveSpawnerEggs = minecraftVersion.compareTo("12w01a") >= 0 || minecraftVersion.compareTo("1.0.1") >= 0;
        this.haveNewBiomes = minecraftVersion.compareTo("12w07a") >= 0;
        this.haveFontColor = minecraftVersion.compareTo("11w49a") >= 0;
        this.haveNewWorld = minecraftVersion.compareTo("12w18a") >= 0;
        this.renderStringReturnsInt = minecraftVersion.compareTo("1.2.4") >= 0;
        this.renderBlockFallingSandTakes4Ints = minecraftVersion.compareTo("12w22a") >= 0;
        this.configPanel = new ConfigPanel();
        this.classMods.add(new BaseMod.TexturePackListMod(minecraftVersion));
        this.classMods.add(new BaseMod.TexturePackBaseMod(minecraftVersion));
        this.classMods.add(new MinecraftMod(minecraftVersion));
        this.classMods.add(new IBlockAccessMod());
        this.classMods.add(new BlockMod());
        this.classMods.add(new BiomeGenBaseMod());
        this.classMods.add(new BiomeGenSwampMod());
        this.classMods.add(new BlockFluidMod());
        this.classMods.add(new BlockCauldronMod());
        this.classMods.add(new ItemMod());
        this.classMods.add(new ItemBlockMod());
        this.classMods.add(new ItemRendererMod());
        this.classMods.add(new PotionMod());
        this.classMods.add(new PotionHelperMod());
        this.classMods.add(new ColorizerFoliageMod());
        this.classMods.add(new BlockLeavesMod());
        this.classMods.add(new WorldMod());
        if (this.haveNewWorld) {
            this.classMods.add(new BaseMod.WorldServerMod(minecraftVersion));
        }
        this.classMods.add(new WorldProviderMod());
        this.classMods.add(new WorldProviderHellMod());
        this.classMods.add(new WorldProviderEndMod());
        this.classMods.add(new WorldChunkManagerMod());
        this.classMods.add(new EntityMod());
        this.classMods.add(new EntityFXMod());
        this.classMods.add(new EntityRainFXMod());
        this.classMods.add(new EntityDropParticleFXMod());
        this.classMods.add(new EntitySplashFXMod());
        this.classMods.add(new EntityBubbleFXMod());
        this.classMods.add(new EntitySuspendFXMod());
        this.classMods.add(new EntityPortalFXMod());
        this.classMods.add(new EntityAuraFXMod());
        this.classMods.add(new EntityLivingMod());
        this.classMods.add(new EntityRendererMod());
        this.classMods.add(new BlockLilyPadMod());
        this.classMods.add(new BlockRedstoneWireMod());
        this.classMods.add(new RenderBlocksMod());
        this.classMods.add(new EntityReddustFXMod());
        this.classMods.add(new RenderGlobalMod());
        this.classMods.add(new BlockStemMod());
        this.classMods.add(new MapColorMod());
        this.classMods.add(new ItemDyeMod());
        this.classMods.add(new EntitySheepMod());
        if (this.haveSpawnerEggs) {
            this.classMods.add(new EntityListMod());
            this.classMods.add(new ItemSpawnerEggMod());
        }
        if (this.haveFontColor) {
            this.classMods.add(new FontRendererMod());
            this.classMods.add(new TileEntitySignRendererMod());
        }
        this.classMods.add(new RenderXPOrbMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.Colorizer"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.ColorMap"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.BiomeHelper"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.BiomeHelper$Stub"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.BiomeHelper$Old"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.BiomeHelper$New"));
    }

    private class RenderXPOrbMod
    extends ClassMod {
        RenderXPOrbMod() {
            MethodRef render = new MethodRef(this.getDeobfClass(), "render", "(LEntityXPOrb;DDDFF)V");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/item/xporb.png"));
                }
            }.setMethod(render));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override xp orb color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(BinaryRegex.capture(BytecodeMatcher.anyFLOAD), this.push(Float.valueOf(0.0f)), 98, BytecodeMatcher.anyReference(184), BinaryRegex.any(0, 200)), true), BinaryRegex.capture(BytecodeMatcher.anyILOAD), BinaryRegex.lookAhead(BinaryRegex.build(this.push(128), BytecodeMatcher.anyReference(182)), true));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(2), this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeXPOrb", "(IF)I")));
                }
            });
        }
    }

    private class TileEntitySignRendererMod
    extends ClassMod {
        TileEntitySignRendererMod() {
            MethodRef renderTileSignEntityAt = new MethodRef(this.getDeobfClass(), "renderTileSignEntityAt", "(LTileEntitySign;DDDF)V");
            final MethodRef glDepthMask = new MethodRef("org.lwjgl.opengl.GL11", "glDepthMask", "(Z)V");
            this.classSignatures.add(new ConstSignature(glDepthMask));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/item/sign.png"));
                }
            }.setMethod(renderTileSignEntityAt));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override sign text color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(3, this.reference(184, glDepthMask), 3, BinaryRegex.capture(BytecodeMatcher.anyISTORE));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(3, this.reference(184, glDepthMask), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeSignText", "()I")), this.getCaptureGroup(1));
                }
            });
        }
    }

    private class FontRendererMod
    extends BaseMod.FontRendererMod {
        FontRendererMod() {
            MethodRef renderString = new MethodRef(this.getDeobfClass(), "renderString", "(Ljava/lang/String;IIIZ)" + (CustomColors.this.renderStringReturnsInt ? "I" : "V"));
            final MethodRef glColor4f = new MethodRef("org.lwjgl.opengl.GL11", "glColor4f", "(FFFF)V");
            final FieldRef colorCode = new FieldRef(this.getDeobfClass(), "colorCode", "[I");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(32), 188, 10, BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, colorCode));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(-16777216), BinaryRegex.any(0, 100), this.reference(184, glColor4f));
                }
            }.setMethod(renderString));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override text color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 3, BytecodeMatcher.anyReference(181));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(21, 4, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeText", "(I)I")), 54, 4);
                }
            }.targetMethod(renderString));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override text color codes";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, colorCode), BinaryRegex.capture(BytecodeMatcher.anyILOAD), 46);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeText", "(II)I")));
                }
            });
        }
    }

    private class EntitySheepMod
    extends ClassMod {
        EntitySheepMod() {
            this.classSignatures.add(new ConstSignature("/mob/sheep.png"));
            this.classSignatures.add(new ConstSignature("mob.sheep"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "fleeceColorTable", "[[F")).accessFlag(8, true));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "origFleeceColorTable", "[[F"), 9));
            this.patches.add(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "fleeceColorTable", "[[F")){

                public int getNewFlags(int oldFlags) {
                    return oldFlags & 0xFFFFFFEF;
                }
            });
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "clone fleeceColorTable";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef(EntitySheepMod.this.getDeobfClass(), "fleeceColorTable", "[[F")), this.reference(182, new MethodRef("java/lang/Object", "clone", "()Ljava/lang/Object;")), this.reference(192, new ClassRef("[[F")), this.reference(179, new FieldRef(EntitySheepMod.this.getDeobfClass(), "origFleeceColorTable", "[[F")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "<clinit>", "()V")));
        }
    }

    private class ItemDyeMod
    extends ClassMod {
        ItemDyeMod() {
            this.parentClass = "Item";
            this.classSignatures.add(new ConstSignature("black"));
            this.classSignatures.add(new ConstSignature("purple"));
            this.classSignatures.add(new ConstSignature("cyan"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "dyeColorNames", "[Ljava/lang/String;")).accessFlag(8, true));
        }
    }

    private class MapColorMod
    extends ClassMod {
        MapColorMod() {
            this.classSignatures.add(new ConstSignature(8368696));
            this.classSignatures.add(new ConstSignature(16247203));
            this.classSignatures.add(new ConstSignature(0xA7A7A7));
            this.classSignatures.add(new ConstSignature(0xFF0000));
            this.classSignatures.add(new ConstSignature(0xA0A0FF));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "mapColorArray", "[LMapColor;")).accessFlag(8, true));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "colorValue", "I"), new FieldRef(this.getDeobfClass(), "colorIndex", "I")).accessFlag(8, false));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "origColorValue", "I")));
            this.patches.add(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "colorValue", "I")){

                public int getNewFlags(int oldFlags) {
                    return oldFlags & 0xFFFFFFEF;
                }
            });
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "set map origColorValue";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 28, this.reference(181, new FieldRef(MapColorMod.this.getDeobfClass(), "colorValue", "I")));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, 28, this.reference(181, new FieldRef(MapColorMod.this.getDeobfClass(), "origColorValue", "I")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "<init>", "(II)V")));
        }
    }

    private class ItemSpawnerEggMod
    extends ClassMod {
        ItemSpawnerEggMod() {
            this.parentClass = "Item";
            this.classSignatures.add(new ConstSignature(".name"));
            this.classSignatures.add(new ConstSignature("entity."));
            MethodRef getItemNameIS = new MethodRef(this.getDeobfClass(), "getItemNameIS", "(LItemStack;)Ljava/lang/String;");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, BytecodeMatcher.captureReference(182), BytecodeMatcher.captureReference(184), 78, 45);
                }
            }.setMethod(getItemNameIS).addXref(1, new MethodRef("ItemStack", "getItemDamage", "()I")).addXref(2, new MethodRef("EntityList", "getEntityString", "(I)Ljava/lang/String;")));
            this.classSignatures.add(new OrSignature(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(16, 64, 27, this.push(2423535), 104, this.push(192), 126, 96);
                }
            }.setMethodName("getColorFromDamage"), new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0xFFFFFF), 172);
                }
            }.setMethodName("getColorFromDamage")));
            this.patches.add(new BytecodePatch.InsertBefore(){
                private MethodRef getColorFromDamage;

                public String getDescription() {
                    return "override spawner egg color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(172);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(27, CustomColors.this.getColorFromDamageParams >= 2 ? 28 : 3, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeSpawnerEgg", "(III)I")));
                }

                public MethodRef getTargetMethod() {
                    if (this.getColorFromDamage == null) {
                        this.getColorFromDamage = new MethodRef(ItemSpawnerEggMod.this.getDeobfClass(), "getColorFromDamage", CustomColors.this.getColorFromDamageDescriptor);
                    }
                    return this.getColorFromDamage;
                }
            });
        }
    }

    private class EntityListMod
    extends ClassMod {
        EntityListMod() {
            this.classSignatures.add(new ConstSignature("Skipping Entity with id "));
            MethodRef addMapping = new MethodRef(this.getDeobfClass(), "addMapping", "(Ljava/lang/Class;Ljava/lang/String;III)V");
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, addMapping).accessFlag(8, true));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "set up mapping for spawnable entities";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, 28, 29, 21, 4, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setupSpawnerEgg", "(Ljava/lang/String;III)V")));
                }
            }.targetMethod(addMapping));
        }
    }

    private class RenderGlobalMod
    extends ClassMod {
        RenderGlobalMod() {
            this.classSignatures.add(new ConstSignature("/environment/clouds.png"));
            MethodRef renderClouds = new MethodRef(this.getDeobfClass(), "renderClouds", "(F)V");
            MethodRef renderSky = new MethodRef(this.getDeobfClass(), "renderSky", "(F)V");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(32), BytecodeMatcher.anyISTORE, this.push(256), BytecodeMatcher.anyILOAD, 108, BytecodeMatcher.anyISTORE, BinaryRegex.any(1, 50), this.push("/environment/clouds.png"));
                }
            }.setMethod(renderClouds));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/misc/tunnel.png"));
                }
            }.setMethod(renderSky));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override cloud type";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.any(21), false), BinaryRegex.capture(BinaryRegex.build(42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyReference(180), BytecodeMatcher.anyReference(180))), BinaryRegex.capture(BinaryRegex.build(153, BinaryRegex.any(2))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "drawFancyClouds", "(Z)Z")), this.getCaptureGroup(2));
                }
            }.targetMethod(renderClouds));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override end sky color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(this.push(0x181818)), BinaryRegex.build(this.push(0x282828))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "endSkyColor", "I"))});
                }
            }.targetMethod(renderSky));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override mycelium particle color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(43, this.push("townaura"), this.reference(182, new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z")), 153, BinaryRegex.any(2), this.reference(187, new ClassRef("EntityAuraFX")), 89, 42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, this.reference(183, new MethodRef("EntityAuraFX", "<init>", "(LWorld;DDDDDD)V"))), true));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(182, new MethodRef("EntityAuraFX", "colorize", "()LEntityAuraFX;"))});
                }
            });
        }
    }

    public class BlockStemMod
    extends ClassMod {
        BlockStemMod() {
            MethodRef getRenderColor = new MethodRef(this.getDeobfClass(), "getRenderColor", "(I)I");
            this.classSignatures.add(new FixedBytecodeSignature(BinaryRegex.begin(), 27, 16, 32, 104, 61, 17, 0, 255, 27, 16, 8, 104, 100, 62, 27, 7, 104, 54, 4, 28, 16, 16, 120, 29, 16, 8, 120, 128, 21, 4, 128, 172, BinaryRegex.end()).setMethod(getRenderColor));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "override pumpkin and melon stem color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(172, BinaryRegex.end());
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(27, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeStem", "(II)I")));
                }
            }.targetMethod(getRenderColor));
        }
    }

    private class EntityReddustFXMod
    extends ClassMod {
        EntityReddustFXMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.reference(184, new MethodRef("java/lang/Math", "random", "()D")), this.push(0.2f), 107, 144, this.push(Float.valueOf(0.8f)), 98, BytecodeMatcher.anyFLOAD, 106, BytecodeMatcher.anyFLOAD, 106, BytecodeMatcher.anyReference(181));
                    }
                    return null;
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override redstone particle color";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(12, 56, 9, this.reference(184, new MethodRef("java/lang/Math", "random", "()D")));
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(12, 56, 9, 16, 15, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeRedstoneWireColor", "(I)Z")), 153, EntityReddustFXMod.this.branch("A"), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, 56, 9, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, 56, 10, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, 56, 11, EntityReddustFXMod.this.label("A"), this.reference(184, new MethodRef("java/lang/Math", "random", "()D")));
                }
            });
        }
    }

    private class RenderBlocksMod
    extends RedstoneWireClassMod {
        RenderBlocksMod() {
            super("override redstone wire color", new MethodRef("RenderBlocks", "renderBlockRedstoneWire", "(LBlock;III)Z"));
            this.classSignatures.add(new ConstSignature(0.1875));
            this.classSignatures.add(new ConstSignature(0.01));
            MethodRef renderBlockFallingSand = new MethodRef(this.getDeobfClass(), "renderBlockFallingSand", "(LBlock;LWorld;III" + (CustomColors.this.renderBlockFallingSandTakes4Ints ? "I" : "") + ")V");
            final int renderBlockFallingSandOffset = CustomColors.this.renderBlockFallingSandTakes4Ints ? 1 : 0;
            final MethodRef setColorOpaque_F = new MethodRef("Tessellator", "setColorOpaque_F", "(FFF)V");
            MethodRef renderBlockFluids = new MethodRef(this.getDeobfClass(), "renderBlockFluids", "(LBlock;III)Z");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, 42, BytecodeMatcher.captureReference(180), 28, 29, 21, 4, BytecodeMatcher.captureReference(182), 54, 6);
                }
            }.setMethod(renderBlockFluids).addXref(1, new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;")).addXref(2, new MethodRef("Block", "colorMultiplier", "(LIBlockAccess;III)I")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(25, 5, 23, 6, 23, 8, 106, 23, 6, 23, 9, 106, 23, 6, 23, 10, 106, BytecodeMatcher.captureReference(182));
                }
            }.addXref(1, setColorOpaque_F));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(Float.valueOf(0.5f)), 56, 6 + renderBlockFallingSandOffset, 12, 56, 7 + renderBlockFallingSandOffset, this.push(Float.valueOf(0.8f)), 56, 8 + renderBlockFallingSandOffset, this.push(Float.valueOf(0.6f)), 56, 9 + renderBlockFallingSandOffset);
                }
            }.setMethod(renderBlockFallingSand));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "renderBlockCauldron", "(LBlockCauldron;III)Z")));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "colorize cauldron water color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(205), 54, BinaryRegex.any());
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeWaterColor", "()V")), 25, 5, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "waterColor", "[F")), 3, 48, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "waterColor", "[F")), 4, 48, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "waterColor", "[F")), 5, 48, this.reference(182, setColorOpaque_F));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "renderBlockCauldron", "(LBlockCauldron;III)Z")));
            this.patches.add(new BytecodePatch(){
                private boolean done;

                public String getDescription() {
                    return "colorize falling sand and gravel";
                }

                public String getMatchExpression() {
                    return this.buildExpression(25, 10 + renderBlockFallingSandOffset, BinaryRegex.capture(BytecodeMatcher.anyFLOAD), 23, 12 + renderBlockFallingSandOffset, 106, BinaryRegex.backReference(1), 23, 12 + renderBlockFallingSandOffset, 106, BinaryRegex.backReference(1), 23, 12 + renderBlockFallingSandOffset, 106, this.reference(182, setColorOpaque_F));
                }

                public byte[] getReplacementBytes() throws IOException {
                    byte[] extraCode;
                    if (this.done) {
                        extraCode = new byte[]{};
                    } else {
                        this.done = true;
                        extraCode = this.buildCode(43, 29, 21, 4, 21, 5, 3, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBlock", "(LBlock;IIII)I")), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setColorF", "(I)V")));
                    }
                    return this.buildCode(extraCode, 25, 10 + renderBlockFallingSandOffset, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, 23, 12 + renderBlockFallingSandOffset, 106, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, 23, 12 + renderBlockFallingSandOffset, 106, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, 23, 12 + renderBlockFallingSandOffset, 106, this.reference(182, setColorOpaque_F));
                }
            }.targetMethod(renderBlockFallingSand));
            final int[] savedRegisters = new int[]{7, 8, 9};
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "save water color registers";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyILOAD), this.push(16), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.backReference(1), this.push(8), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.backReference(1), this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    savedRegisters[0] = this.getCaptureGroup(2)[0] & 0xFF;
                    savedRegisters[1] = this.getCaptureGroup(3)[0] & 0xFF;
                    savedRegisters[2] = this.getCaptureGroup(4)[0] & 0xFF;
                    Logger.log(3, "water color registers: %d %d %d", savedRegisters[0], savedRegisters[1], savedRegisters[2]);
                    return null;
                }
            }.targetMethod(renderBlockFluids));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "colorize bottom of water block";
                }

                public String getMatchExpression() {
                    return this.buildExpression(25, 5, 23, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.capture(BinaryRegex.any()), 106, 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(2), 106, 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(2), 106, this.reference(182, setColorOpaque_F));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(25, 5, 23, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 106, 23, savedRegisters[0], 106, 23, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 106, 23, savedRegisters[1], 106, 23, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 106, 23, savedRegisters[2], 106, this.reference(182, setColorOpaque_F));
                }
            }.targetMethod(renderBlockFluids));
        }
    }

    private class BlockRedstoneWireMod
    extends RedstoneWireClassMod {
        BlockRedstoneWireMod() {
            super("override redstone wire particle color", new MethodRef("BlockRedstoneWire", "randomDisplayTick", "(LWorld;IIILjava/util/Random;)V"));
            this.parentClass = "Block";
            this.classSignatures.add(new ConstSignature("reddust"));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override redstone color multiplier";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0x800000));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, 28, 29, 21, 4, this.push(0x800000), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeRedstoneWire", "(LIBlockAccess;IIII)I")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I")));
        }
    }

    private abstract class RedstoneWireClassMod
    extends ClassMod {
        RedstoneWireClassMod(final String description, MethodRef method) {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, 134, this.push(Float.valueOf(15.0f)), 110, BytecodeMatcher.anyFSTORE, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.4f)), 98, BytecodeMatcher.anyFSTORE);
                }
            }.setMethod(method));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return description;
                }

                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), 134, this.push(Float.valueOf(15.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(2), this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.4f)), 98, 56, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.any(0, 10), 23, BinaryRegex.backReference(2), 23, BinaryRegex.backReference(2), 106, this.push(Float.valueOf(0.7f)), 106, this.push(Float.valueOf(0.5f)), 102, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(2), 23, BinaryRegex.backReference(2), 106, this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.7f)), 102, 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(21, this.getCaptureGroup(1), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeRedstoneWireColor", "(I)Z")), 153, RedstoneWireClassMod.this.branch("A"), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, 56, this.getCaptureGroup(3), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, 56, this.getCaptureGroup(4), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, 56, this.getCaptureGroup(5), 167, RedstoneWireClassMod.this.branch("B"), RedstoneWireClassMod.this.label("A"), this.getMatch(), RedstoneWireClassMod.this.label("B"));
                }
            }.targetMethod(method));
        }
    }

    private class EntityRendererMod
    extends ClassMod {
        EntityRendererMod() {
            int updateLightmapOffset;
            MethodRef updateLightmap;
            boolean updateLightmapTakesFloat;
            boolean bl = updateLightmapTakesFloat = Mod.getMinecraftVersion().compareTo("12w32a") >= 0;
            if (updateLightmapTakesFloat) {
                updateLightmap = new MethodRef(this.getDeobfClass(), "updateLightmap", "(F)V");
                updateLightmapOffset = 1;
            } else {
                updateLightmap = new MethodRef(this.getDeobfClass(), "updateLightmap", "()V");
                updateLightmapOffset = 0;
            }
            this.classSignatures.add(new ConstSignature("ambient.weather.rain"));
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.registerLoadStore(25, 1 + updateLightmapOffset), 12, BytecodeMatcher.captureReference(182), this.push(Float.valueOf(0.95f)), 106, this.push(Float.valueOf(0.05f)), 98, BytecodeMatcher.registerLoadStore(56, 3 + updateLightmapOffset), BytecodeMatcher.registerLoadStore(25, 1 + updateLightmapOffset), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.registerLoadStore(21, 2 + updateLightmapOffset), 16, 16, 108, 48, BytecodeMatcher.registerLoadStore(23, 3 + updateLightmapOffset), 106, BytecodeMatcher.registerLoadStore(56, 4 + updateLightmapOffset), BinaryRegex.any(0, 20), BytecodeMatcher.registerLoadStore(21, 2 + updateLightmapOffset), 16, 16, 112, 48, 42, BytecodeMatcher.captureReference(180), BinaryRegex.any(0, 200), BytecodeMatcher.registerLoadStore(25, 1 + updateLightmapOffset), BytecodeMatcher.captureReference(180), 158, BinaryRegex.any(2), BinaryRegex.any(0, 200), BytecodeMatcher.registerLoadStore(25, 1 + updateLightmapOffset), BinaryRegex.backReference(2), BytecodeMatcher.captureReference(180), 4, 160, BinaryRegex.any(2), BinaryRegex.any(0, 200), 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.registerLoadStore(56, 15 + updateLightmapOffset), BinaryRegex.any(0, 300), 42, BinaryRegex.backReference(7), BytecodeMatcher.captureReference(180), 42, BytecodeMatcher.captureReference(180), 16, 16, 16, 16, 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(updateLightmap).addXref(1, new MethodRef("World", "getSunAngle", "(F)F")).addXref(2, new FieldRef("World", "worldProvider", "LWorldProvider;")).addXref(3, new FieldRef("WorldProvider", "lightBrightnessTable", "[F")).addXref(4, new FieldRef(this.getDeobfClass(), "torchFlickerX", "F")).addXref(5, new FieldRef("World", "lightningFlash", "I")).addXref(6, new FieldRef("WorldProvider", "worldType", "I")).addXref(7, new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;")).addXref(8, new FieldRef("Minecraft", "gameSettings", "LGameSettings;")).addXref(9, new FieldRef("GameSettings", "gammaSetting", "F")).addXref(10, new FieldRef("Minecraft", "renderEngine", "LRenderEngine;")).addXref(11, new FieldRef(this.getDeobfClass(), "lightmapColors", "[I")).addXref(12, new FieldRef(this.getDeobfClass(), "lightmapTexture", "I")).addXref(13, new MethodRef("RenderEngine", "createTextureFromBytes", "([IIII)V")));
            MethodRef updateFogColor = new MethodRef(this.getDeobfClass(), "updateFogColor", "(F)V");
            final FieldRef fogColorRed = new FieldRef(this.getDeobfClass(), "fogColorRed", "F");
            final FieldRef fogColorGreen = new FieldRef(this.getDeobfClass(), "fogColorGreen", "F");
            final FieldRef fogColorBlue = new FieldRef(this.getDeobfClass(), "fogColorBlue", "F");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.02f)), BytecodeMatcher.captureReference(181), 42, this.push(Float.valueOf(0.02f)), BytecodeMatcher.captureReference(181), 42, this.push(Float.valueOf(0.2f)), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(updateFogColor).addXref(1, fogColorRed).addXref(2, fogColorGreen).addXref(3, fogColorBlue));
            this.patches.add(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "torchFlickerX", "F")));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override lightmap";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{BytecodeMatcher.registerLoadStore(58, 1 + updateLightmapOffset)});
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, BytecodeMatcher.registerLoadStore(25, 1 + updateLightmapOffset), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeLightmap", "(LEntityRenderer;LWorld;)Z")), 153, EntityRendererMod.this.branch("A"), 177, EntityRendererMod.this.label("A"));
                }
            }.targetMethod(updateLightmap));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "override fog color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.0f)), 23, BinaryRegex.capture(BinaryRegex.any()), 141, this.push(0.25), this.reference(184, new MethodRef("java/lang/Math", "pow", "(DD)D")), 144, 102, 56, BinaryRegex.backReference(1), BinaryRegex.any(0, 100), 42, BytecodeMatcher.anyALOAD, BytecodeMatcher.anyReference(180), 144, this.reference(181, fogColorBlue));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(45, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setupForFog", "(LEntity;)V")), 44, 35, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeFogColor", "(LWorld;F)Z")), 153, EntityRendererMod.this.branch("A"), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, this.reference(181, fogColorRed), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, this.reference(181, fogColorGreen), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, this.reference(181, fogColorBlue), EntityRendererMod.this.label("A"));
                }
            }.targetMethod(updateFogColor));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override underwater ambient color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.02f)), this.reference(181, fogColorRed), 42, this.push(Float.valueOf(0.02f)), this.reference(181, fogColorGreen), 42, this.push(Float.valueOf(0.2f)), this.reference(181, fogColorBlue));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_UNDERWATER", "I")), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeFogColor", "(I)Z")), 153, EntityRendererMod.this.branch("A"), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, this.reference(181, fogColorRed), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, this.reference(181, fogColorGreen), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, this.reference(181, fogColorBlue), EntityRendererMod.this.label("A"));
                }
            }.targetMethod(updateFogColor));
        }
    }

    private class EntityLivingMod
    extends ClassMod {
        EntityLivingMod() {
            this.parentClass = "Entity";
            this.classSignatures.add(new ConstSignature("/mob/char.png"));
            this.classSignatures.add(new ConstSignature("bubble"));
            this.classSignatures.add(new ConstSignature("explode"));
        }
    }

    private class BlockLilyPadMod
    extends ClassMod {
        private static final int MAGIC = 2129968;

        BlockLilyPadMod() {
            this.classSignatures.add(new ConstSignature(2129968));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.5f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.015625f)));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override lily pad color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(2129968));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "getLilyPadColor", "()I"))});
                }
            });
        }
    }

    private class EntityAuraFXMod
    extends ClassMod {
        EntityAuraFXMod() {
            this.parentClass = "EntityFX";
            this.classSignatures.add(new ConstSignature(0.02f));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(Float.valueOf(0.02f)), this.push(Float.valueOf(0.02f)), BytecodeMatcher.anyReference(182));
                    }
                    return null;
                }
            });
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "colorize", "()LEntityAuraFX;")){

                public byte[] generateMethod() throws BadBytecode, IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeMyceliumParticleColor", "()Z")), 153, EntityAuraFXMod.this.branch("A"), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, this.reference(181, new FieldRef(EntityAuraFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, this.reference(181, new FieldRef(EntityAuraFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, this.reference(181, new FieldRef(EntityAuraFXMod.this.getDeobfClass(), "particleBlue", "F")), EntityAuraFXMod.this.label("A"), 42, 176);
                }
            });
        }
    }

    private class EntityPortalFXMod
    extends ClassMod {
        EntityPortalFXMod() {
            this.parentClass = "EntityFX";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 89, 180, BinaryRegex.capture(BinaryRegex.any(2)), this.push(Float.valueOf(0.3f)), 106, 181, BinaryRegex.backReference(1), 42, 89, 180, BinaryRegex.capture(BinaryRegex.any(2)), this.push(Float.valueOf(0.9f)), 106, 181, BinaryRegex.backReference(2));
                    }
                    return null;
                }
            });
            this.addPortalPatch(0.9f, 0, "red");
            this.addPortalPatch(0.3f, 1, "green");
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "override portal particle color (blue)";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(177);
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "portalColor", "[F")), 5, 48, this.reference(181, new FieldRef(EntityPortalFXMod.this.getDeobfClass(), "particleBlue", "F")));
                }
            });
        }

        private void addPortalPatch(final float origValue, final int index, final String color) {
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override portal particle color (" + color + ")";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(this.push(Float.valueOf(origValue)));
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "portalColor", "[F")), this.push(index), 48);
                }
            });
        }
    }

    private class EntitySuspendFXMod
    extends ClassMod {
        EntitySuspendFXMod() {
            this.parentClass = "EntityFX";
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.4f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.7f)));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(Float.valueOf(0.01f)), this.push(Float.valueOf(0.01f)), BytecodeMatcher.anyReference(182));
                    }
                    return null;
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override underwater suspend particle color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.4f)), this.reference(181, new FieldRef(EntitySuspendFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.push(Float.valueOf(0.4f)), this.reference(181, new FieldRef(EntitySuspendFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.push(Float.valueOf(0.7f)), this.reference(181, new FieldRef(EntitySuspendFXMod.this.getDeobfClass(), "particleBlue", "F")));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(0x6666B2), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_UNDERWATER", "I")), 40, 142, 24, 4, 142, 24, 6, 142, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBiome", "(IIIII)I")), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setColorF", "(I)V")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, this.reference(181, new FieldRef(EntitySuspendFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, this.reference(181, new FieldRef(EntitySuspendFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, this.reference(181, new FieldRef(EntitySuspendFXMod.this.getDeobfClass(), "particleBlue", "F")));
                }
            });
        }
    }

    private class EntityBubbleFXMod
    extends WaterFXMod {
        EntityBubbleFXMod() {
            this.parentClass = "EntityFX";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(32), BytecodeMatcher.anyReference(182), 42, this.push(Float.valueOf(0.02f)), this.push(Float.valueOf(0.02f)), BytecodeMatcher.anyReference(182));
                    }
                    return null;
                }
            });
            this.addWaterColorPatch("bubble", new float[]{1.0f, 1.0f, 1.0f});
        }
    }

    private class EntitySplashFXMod
    extends WaterFXMod {
        EntitySplashFXMod() {
            this.parentClass = "EntityRainFX";
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.04f)));
            this.classSignatures.add(new ConstSignature(0.1));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 42, BytecodeMatcher.anyReference(182), 4, 96, BytecodeMatcher.anyReference(182));
                    }
                    return null;
                }
            });
            this.addWaterColorPatch("splash", null);
        }
    }

    private class EntityDropParticleFXMod
    extends WaterFXMod {
        EntityDropParticleFXMod() {
            this.parentClass = "EntityFX";
            MethodRef onUpdate = new MethodRef(this.getDeobfClass(), "onUpdate", "()V");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.2f)), BytecodeMatcher.anyReference(181), 42, this.push(Float.valueOf(0.3f)), BytecodeMatcher.anyReference(181), 42, this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyReference(181), BinaryRegex.any(0, 30), this.push(40), 42, BytecodeMatcher.captureReference(180), 100);
                }
            }.setMethod(onUpdate).addXref(1, new FieldRef(this.getDeobfClass(), "timer", "I")));
            this.addWaterColorPatch("water drop", new float[]{0.0f, 0.0f, 1.0f}, new float[]{0.2f, 0.3f, 1.0f});
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "remove water drop color update";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.2f)), this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.push(Float.valueOf(0.3f)), this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.push(Float.valueOf(1.0f)), this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleBlue", "F")));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[0]);
                }
            }.targetMethod(onUpdate));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override lava drop color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(1.0f)), this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.push(Float.valueOf(16.0f)), BinaryRegex.any(0, 20), this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.push(Float.valueOf(4.0f)), BinaryRegex.any(0, 20), this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleBlue", "F")));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(40), 42, this.reference(180, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "timer", "I")), 100, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeLavaDropColor", "(I)Z")), 153, EntityDropParticleFXMod.this.branch("A"), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, this.reference(181, new FieldRef(EntityDropParticleFXMod.this.getDeobfClass(), "particleBlue", "F")), 167, EntityDropParticleFXMod.this.branch("B"), EntityDropParticleFXMod.this.label("A"), this.getMatch(), EntityDropParticleFXMod.this.label("B"));
                }
            }.targetMethod(onUpdate));
        }
    }

    private class EntityRainFXMod
    extends WaterFXMod {
        EntityRainFXMod() {
            this.parentClass = "EntityFX";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(this.reference(184, new MethodRef("java/lang/Math", "random", "()D")), 144, this.push(Float.valueOf(0.2f)), 106, this.push(Float.valueOf(0.1f)), 98, 141);
                    }
                    return null;
                }
            });
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(this.push(19), 42, BytecodeMatcher.anyReference(180), 7, this.reference(182, new MethodRef("java/util/Random", "nextInt", "(I)I")), 96);
                    }
                    return null;
                }
            });
            this.addWaterColorPatch("rain drop", new float[]{1.0f, 1.0f, 1.0f}, new float[]{0.2f, 0.3f, 1.0f});
        }
    }

    private abstract class WaterFXMod
    extends ClassMod {
        private WaterFXMod() {
        }

        void addWaterColorPatch(String name, float[] particleColors) {
            this.addWaterColorPatch(name, particleColors, particleColors);
        }

        void addWaterColorPatch(final String name, final float[] origColors, final float[] newColors) {
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override " + name + " color";
                }

                public String getMatchExpression() {
                    if (!this.getMethodInfo().isConstructor()) {
                        return null;
                    }
                    if (origColors == null) {
                        return this.buildExpression(177);
                    }
                    return this.buildExpression(42, this.push(Float.valueOf(origColors[0])), this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.push(Float.valueOf(origColors[1])), this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.push(Float.valueOf(origColors[2])), this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleBlue", "F")));
                }

                public byte[] getReplacementBytes() throws IOException {
                    byte[] byArray;
                    Object[] objectArray = new Object[30];
                    objectArray[0] = 42;
                    objectArray[1] = this.reference(180, new FieldRef(WaterFXMod.this.getDeobfClass(), "posX", "D"));
                    objectArray[2] = 42;
                    objectArray[3] = this.reference(180, new FieldRef(WaterFXMod.this.getDeobfClass(), "posY", "D"));
                    objectArray[4] = 42;
                    objectArray[5] = this.reference(180, new FieldRef(WaterFXMod.this.getDeobfClass(), "posZ", "D"));
                    objectArray[6] = this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeWaterColor", "(DDD)Z"));
                    objectArray[7] = 153;
                    objectArray[8] = WaterFXMod.this.branch("A");
                    objectArray[9] = 42;
                    objectArray[10] = this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "waterColor", "[F"));
                    objectArray[11] = 3;
                    objectArray[12] = 48;
                    objectArray[13] = this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleRed", "F"));
                    objectArray[14] = 42;
                    objectArray[15] = this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "waterColor", "[F"));
                    objectArray[16] = 4;
                    objectArray[17] = 48;
                    objectArray[18] = this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleGreen", "F"));
                    objectArray[19] = 42;
                    objectArray[20] = this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "waterColor", "[F"));
                    objectArray[21] = 5;
                    objectArray[22] = 48;
                    objectArray[23] = this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleBlue", "F"));
                    objectArray[24] = 167;
                    objectArray[25] = WaterFXMod.this.branch("B");
                    objectArray[26] = WaterFXMod.this.label("A");
                    objectArray[27] = newColors == null ? new byte[]{} : this.buildCode(42, this.push(Float.valueOf(newColors[0])), this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleRed", "F")), 42, this.push(Float.valueOf(newColors[1])), this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleGreen", "F")), 42, this.push(Float.valueOf(newColors[2])), this.reference(181, new FieldRef(WaterFXMod.this.getDeobfClass(), "particleBlue", "F")));
                    objectArray[28] = WaterFXMod.this.label("B");
                    if (origColors == null) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = -79;
                    } else {
                        byArray = new byte[]{};
                    }
                    objectArray[29] = byArray;
                    return this.buildCode(objectArray);
                }
            });
        }
    }

    private class EntityFXMod
    extends ClassMod {
        EntityFXMod() {
            this.parentClass = "Entity";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(Float.valueOf(0.2f)), this.push(Float.valueOf(0.2f)), BytecodeMatcher.anyReference(182));
                    }
                    return null;
                }
            });
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 42, 42, 12, 90, BytecodeMatcher.captureReference(181), 90, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "particleBlue", "F")).addXref(2, new FieldRef(this.getDeobfClass(), "particleGreen", "F")).addXref(3, new FieldRef(this.getDeobfClass(), "particleRed", "F")));
        }
    }

    private class EntityMod
    extends ClassMod {
        EntityMod() {
            this.classSignatures.add(new ConstSignature("tilecrack_"));
            this.classSignatures.add(new ConstSignature("random.splash"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 42, 39, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 41, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 24, 5, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "setPositionAndRotation", "(DDDFF)V")).addXref(1, new FieldRef(this.getDeobfClass(), "posX", "D")).addXref(2, new FieldRef(this.getDeobfClass(), "prevPosX", "D")).addXref(3, new FieldRef(this.getDeobfClass(), "posY", "D")).addXref(4, new FieldRef(this.getDeobfClass(), "prevPosY", "D")).addXref(5, new FieldRef(this.getDeobfClass(), "posZ", "D")).addXref(6, new FieldRef(this.getDeobfClass(), "prevPosZ", "D")));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "worldObj", "LWorld;")));
        }
    }

    private class WorldChunkManagerMod
    extends ClassMod {
        WorldChunkManagerMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(21, 4, 21, 5, 104, 188, 6, 76);
                }
            });
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 27, 29, 100, 5, 122, 54, 6);
                }
            });
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBiomeGenAt", "(II)LBiomeGenBase;")));
        }
    }

    private class WorldProviderEndMod
    extends ClassMod {
        WorldProviderEndMod() {
            this.parentClass = "WorldProvider";
            this.classSignatures.add(new OrSignature(new ConstSignature(0x8080A0), new ConstSignature(0xA080A0)));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141);
                }
            });
            MethodRef getFogColor = new MethodRef(this.getDeobfClass(), "getFogColor", "(FF)LVec3D;");
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override end fog color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "endFogColor", "[F")), 3, 48, 141, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "endFogColor", "[F")), 4, 48, 141, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "endFogColor", "[F")), 5, 48, 141);
                }
            }.targetMethod(getFogColor));
        }
    }

    private class WorldProviderHellMod
    extends ClassMod {
        WorldProviderHellMod() {
            this.parentClass = "WorldProvider";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0.2f), this.push(0.03f), this.push(0.03f));
                }
            });
            MethodRef getFogColor = new MethodRef(this.getDeobfClass(), "getFogColor", "(FF)LVec3D;");
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override nether fog color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0.2f), this.push(0.03f), this.push(0.03f));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "netherFogColor", "[F")), 3, 48, 141, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "netherFogColor", "[F")), 4, 48, 141, this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "netherFogColor", "[F")), 5, 48, 141);
                }
            }.targetMethod(getFogColor));
        }
    }

    private class WorldProviderMod
    extends ClassMod {
        WorldProviderMod() {
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.06f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.09f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.91f)));
            this.classSignatures.add(new ConstSignature(Float.valueOf(0.94f)));
            MethodRef getFogColor = new MethodRef(this.getDeobfClass(), "getFogColor", "(FF)LVec3D;");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.capture(BinaryRegex.any()), 37, this.push(Float.valueOf(0.94f)), 106, this.push(Float.valueOf(0.06f)), 98, 106, 56, BinaryRegex.backReference(1));
                }
            }.setMethod(getFogColor));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override fog color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(0.7529412f)), 56, BinaryRegex.capture(BinaryRegex.any()), this.push(Float.valueOf(0.84705883f)), 56, BinaryRegex.capture(BinaryRegex.any()), this.push(Float.valueOf(1.0f)), 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_FOG0", "I")), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeFogColor", "(I)Z")), 153, WorldProviderMod.this.branch("A"), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, 56, this.getCaptureGroup(1), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, 56, this.getCaptureGroup(2), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, 56, this.getCaptureGroup(3), 167, WorldProviderMod.this.branch("B"), WorldProviderMod.this.label("A"), this.getMatch(), WorldProviderMod.this.label("B"));
                }
            }.targetMethod(getFogColor));
        }
    }

    private class WorldMod
    extends BaseMod.WorldMod {
        WorldMod() {
            this.interfaces = new String[]{"IBlockAccess"};
            MethodRef getSkyColor = new MethodRef(this.getDeobfClass(), "getSkyColor", "(LEntity;F)LVec3D;");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.any(), this.push(Float.valueOf(0.3f)), 106, 23, BinaryRegex.any(), this.push(Float.valueOf(0.59f)), 106, 98, 23, BinaryRegex.any(), this.push(Float.valueOf(0.11f)), 106, 98, this.push(Float.valueOf(0.6f)), 106, 56, BinaryRegex.any());
                }
            }.setMethod(getSkyColor));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getWorldChunkManager", "()LWorldChunkManager;")));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override sky color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), this.push(16), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), this.push(8), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(43, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setupForFog", "(LEntity;)V")), 42, 36, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "computeSkyColor", "(LWorld;F)Z")), 153, WorldMod.this.branch("A"), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 3, 48, 56, this.getCaptureGroup(2), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 4, 48, 56, this.getCaptureGroup(3), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "setColor", "[F")), 5, 48, 56, this.getCaptureGroup(4), 167, WorldMod.this.branch("B"), WorldMod.this.label("A"), this.getMatch(), WorldMod.this.label("B"));
                }
            }.targetMethod(getSkyColor));
        }
    }

    private class BlockLeavesMod
    extends ClassMod {
        BlockLeavesMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(185), 54, 5, 21, 5, BinaryRegex.subset(new byte[]{4, 6}, true), 126, 4, 160, BinaryRegex.any(2), BytecodeMatcher.captureReference(184), 172, 21, 5, BinaryRegex.subset(new byte[]{5, 6}, true), 126, 5, 160, BinaryRegex.any(2), BytecodeMatcher.captureReference(184), 172);
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I")).addXref(1, new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I")).addXref(2, new MethodRef("ColorizerFoliage", "getFoliageColorPine", "()I")).addXref(3, new MethodRef("ColorizerFoliage", "getFoliageColorBirch", "()I")));
            if (CustomColors.this.haveNewBiomes) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(43, 28, BytecodeMatcher.anyILOAD, 96, 21, 4, BytecodeMatcher.anyILOAD, 96, BytecodeMatcher.captureReference(185), BytecodeMatcher.captureReference(182));
                    }
                }.addXref(1, new InterfaceMethodRef("IBlockAccess", "getBiomeGenAt", "(II)LBiomeGenBase;")).addXref(2, new MethodRef("BiomeGenBase", "getFoliageColor", "()I")));
            } else {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(43, BytecodeMatcher.captureReference(185), 28, BinaryRegex.any(0, 3), 21, 4, BinaryRegex.any(0, 3), BytecodeMatcher.captureReference(182), 43, 28, BinaryRegex.any(0, 3), 29, 21, 4, BinaryRegex.any(0, 3), BytecodeMatcher.captureReference(182));
                    }
                }.addXref(1, new InterfaceMethodRef("IBlockAccess", "getWorldChunkManager", "()LWorldChunkManager;")).addXref(2, new MethodRef("WorldChunkManager", "getBiomeGenAt", "(II)LBiomeGenBase;")).addXref(3, new MethodRef("BiomeGenBase", "getFoliageColor", "(LIBlockAccess;III)I")));
            }
            this.addFoliagePatch("PINE", "Pine");
            this.addFoliagePatch("BIRCH", "Birch");
        }

        private void addFoliagePatch(final String index, final String name) {
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override biome " + name.toLowerCase() + " foliage color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("ColorizerFoliage", "getFoliageColor" + name, "()I"))});
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_" + index, "I")), 28, 29, 21, 4, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBiomeWithBlending", "(IIIII)I")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I")));
        }
    }

    private class ColorizerFoliageMod
    extends ClassMod {
        ColorizerFoliageMod() {
            this.setupColor("PINE", 0x619961, "Pine");
            this.setupColor("BIRCH", 8431445, "Birch");
            this.setupColor("FOLIAGE", 4764952, "Basic");
        }

        private void setupColor(final String index, final int color, final String name) {
            this.classSignatures.add(new ConstSignature(color));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override default " + name.toLowerCase() + " foliage color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(color), 172, BinaryRegex.end());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(color), this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_" + index, "I")), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBiome", "(II)I")), 172);
                }
            });
        }
    }

    private class PotionHelperMod
    extends ClassMod {
        private static final int MAGIC = 3694022;

        PotionHelperMod() {
            this.classSignatures.add(new ConstSignature("potion.prefix.mundane"));
            this.classSignatures.add(new ConstSignature(3694022));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override water bottle color";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(3694022), 60);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "getWaterBottleColor", "()I")), 60);
                }
            });
        }
    }

    private class PotionMod
    extends ClassMod {
        PotionMod() {
            this.classSignatures.add(new ConstSignature("potion.moveSpeed"));
            this.classSignatures.add(new ConstSignature("potion.moveSlowdown"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().startsWith("(Ljava/lang/String;)")) {
                        return this.buildExpression(BinaryRegex.begin(), 42, 43, BytecodeMatcher.captureReference(181), 42, 176, BinaryRegex.end());
                    }
                    return null;
                }
            }.setMethodName("setPotionName").addXref(1, new FieldRef(this.getDeobfClass(), "name", "Ljava/lang/String;")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "id", "I")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 29, BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "color", "I")));
            this.patches.add(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "name", "Ljava/lang/String;")));
            this.patches.add(new AddFieldPatch(new FieldRef(this.getDeobfClass(), "origColor", "I")));
            this.patches.add(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "color", "I")){

                public int getNewFlags(int oldFlags) {
                    return super.getNewFlags(oldFlags) & 0xFFFFFFEF;
                }
            });
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "map potions by name";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 176, BinaryRegex.end());
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setupPotion", "(LPotion;)V")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "setPotionName", "(Ljava/lang/String;)LPotion;")));
        }
    }

    private class ItemRendererMod
    extends ClassMod {
        ItemRendererMod() {
            final FieldRef itemID = new FieldRef("ItemStack", "itemID", "I");
            MethodRef renderItem = new MethodRef(this.getDeobfClass(), "renderItem", "(LEntityLiving;LItemStack;I)V");
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new ConstSignature("/gui/items.png"));
            this.classSignatures.add(new ConstSignature("%blur%/misc/glint.png"));
            this.classSignatures.add(new ConstSignature("/misc/mapbg.png"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(44, BytecodeMatcher.captureReference(180), BinaryRegex.or(BinaryRegex.build(this.push(256)), BinaryRegex.build(50)), BinaryRegex.any(0, 400), this.push(Float.valueOf(-0.9375f)), this.push(Float.valueOf(-0.0625f)), 11, this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V")));
                }
            }.addXref(1, itemID).setMethod(renderItem));
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override water block color in third person";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(-0.9375f)), this.push(Float.valueOf(-0.0625f)), 11, this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V")));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(44, 198, ItemRendererMod.this.branch("A"), 44, this.reference(180, itemID), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeWaterBlockGL", "(I)V")), ItemRendererMod.this.label("A"));
                }
            }.targetMethod(renderItem));
        }
    }

    private class ItemBlockMod
    extends ClassMod {
        ItemBlockMod() {
            this.parentClass = "Item";
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 27, this.push(256), 96, BytecodeMatcher.anyReference(181));
                    }
                    return null;
                }
            });
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "blockID", "I")).accessFlag(2, true));
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "getColorFromDamage", null)){

                public byte[] generateMethod() throws BadBytecode, IOException {
                    byte[] byArray;
                    Object[] objectArray = new Object[9];
                    objectArray[0] = 42;
                    objectArray[1] = 27;
                    if (CustomColors.this.getColorFromDamageParams >= 2) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 28;
                    } else {
                        byArray = new byte[]{};
                    }
                    objectArray[2] = byArray;
                    objectArray[3] = this.reference(183, new MethodRef("Item", "getColorFromDamage", CustomColors.this.getColorFromDamageDescriptor));
                    objectArray[4] = 42;
                    objectArray[5] = this.reference(180, new FieldRef(ItemBlockMod.this.getDeobfClass(), "blockID", "I"));
                    objectArray[6] = 27;
                    objectArray[7] = this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "getItemColorFromDamage", "(III)I"));
                    objectArray[8] = 172;
                    return this.buildCode(objectArray);
                }

                public String getDescriptor() {
                    return CustomColors.this.getColorFromDamageDescriptor;
                }
            });
        }
    }

    private class ItemMod
    extends BaseMod.ItemMod {
        private String lastDescriptor;

        ItemMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    String descriptor = this.getMethodInfo().getDescriptor();
                    if (descriptor.equals("(I)I") || descriptor.equals("(II)I")) {
                        ItemMod.this.lastDescriptor = descriptor;
                        return this.buildExpression(BinaryRegex.begin(), this.push(0xFFFFFF), 172, BinaryRegex.end());
                    }
                    return null;
                }

                public void afterMatch(ClassFile classFile) {
                    CustomColors.this.getColorFromDamageParams = ItemMod.this.lastDescriptor.length() - 3;
                    CustomColors.this.getColorFromDamageDescriptor = ItemMod.this.lastDescriptor;
                    Logger.log(3, "getColorFromDamage%s has %d params", CustomColors.this.getColorFromDamageDescriptor, CustomColors.this.getColorFromDamageParams);
                }
            }.setMethodName("getColorFromDamage"));
        }
    }

    private class BlockCauldronMod
    extends ClassMod {
        BlockCauldronMod() {
            this.parentClass = "Block";
            for (final int i : new int[]{138, 154, 155}) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        if (this.getMethodInfo().getDescriptor().equals("(II)I")) {
                            return this.buildExpression(this.push(i));
                        }
                        return null;
                    }
                });
            }
        }
    }

    private class BlockFluidMod
    extends ClassMod {
        BlockFluidMod() {
            this.classSignatures.add(new ConstSignature("splash"));
            this.classSignatures.add(new ConstSignature("liquid.water"));
            MethodRef colorMultiplier = new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I");
            final FieldRef waterColorMultiplier = new FieldRef("BiomeGenBase", "waterColorMultiplier", "I");
            if (CustomColors.this.haveNewBiomes) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(43, 28, BytecodeMatcher.anyILOAD, 96, 21, 4, BytecodeMatcher.anyILOAD, 96, BytecodeMatcher.anyReference(185), BytecodeMatcher.captureReference(180));
                    }
                }.setMethod(colorMultiplier).addXref(1, waterColorMultiplier));
                this.patches.add(new BytecodePatch(){

                    public String getDescription() {
                        return "override water color";
                    }

                    public String getMatchExpression() {
                        return this.buildExpression(this.reference(185, new InterfaceMethodRef("IBlockAccess", "getBiomeGenAt", "(II)LBiomeGenBase;")), this.reference(180, waterColorMultiplier));
                    }

                    public byte[] getReplacementBytes() throws IOException {
                        return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeWater", "(Ljava/lang/Object;II)I"))});
                    }
                }.targetMethod(colorMultiplier));
            } else {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(43, BytecodeMatcher.anyReference(185), 28, BinaryRegex.any(0, 3), 21, 4, BinaryRegex.any(0, 3), BytecodeMatcher.anyReference(182), BinaryRegex.optional(BinaryRegex.build(58, 5, 25, 5)), BytecodeMatcher.anyReference(180));
                    }
                }.setMethod(colorMultiplier));
                this.patches.add(new BytecodePatch(){

                    public String getDescription() {
                        return "override water color";
                    }

                    public String getMatchExpression() {
                        return this.buildExpression(this.reference(182, new MethodRef("WorldChunkManager", "getBiomeGenAt", "(II)LBiomeGenBase;")), BinaryRegex.any(0, 4), this.reference(180, waterColorMultiplier));
                    }

                    public byte[] getReplacementBytes() throws IOException {
                        return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeWater", "(Ljava/lang/Object;II)I"))});
                    }
                }.targetMethod(colorMultiplier));
            }
        }
    }

    private class BiomeGenSwampMod
    extends ClassMod {
        private static final int MAGIC1 = 0xFEFEFE;
        private static final int MAGIC2 = 0x4E0E4E;
        private static final int MAGIC3_A = 14745456;
        private static final int MAGIC3_B = 14745518;

        BiomeGenSwampMod() {
            this.parentClass = "BiomeGenBase";
            this.classSignatures.add(new ConstSignature(0xFEFEFE));
            this.classSignatures.add(new ConstSignature(0x4E0E4E));
            this.classSignatures.add(new OrSignature(new ConstSignature(14745456), new ConstSignature(14745518)));
            this.addSwampColorPatch("SWAMP_GRASS", "Grass");
            this.addSwampColorPatch("SWAMP_FOLIAGE", "Foliage");
        }

        private void addSwampColorPatch(final String index, final String name) {
            if (CustomColors.this.haveNewBiomes) {
                this.patches.add(new BytecodePatch(){

                    public String getDescription() {
                        return "override swamp " + name.toLowerCase() + " color";
                    }

                    public String getMatchExpression() {
                        return this.buildExpression(172);
                    }

                    public byte[] getReplacementBytes() throws IOException {
                        return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_" + index, "I")), 39, 41, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBiome", "(IIDD)I")), 172);
                    }
                }.targetMethod(new MethodRef(this.getDeobfClass(), "get" + name + "Color", "()I")));
            } else {
                this.patches.add(new BytecodePatch.InsertAfter(){

                    public String getDescription() {
                        return "override swamp " + name.toLowerCase() + " color";
                    }

                    public String getMatchExpression() {
                        return this.buildExpression(this.push(0xFEFEFE), 126, this.push(0x4E0E4E), 96, 5, 108);
                    }

                    public byte[] getInsertBytes() throws IOException {
                        return this.buildCode(this.reference(178, new FieldRef("com.pclewis.mcpatcher.mod.Colorizer", "COLOR_MAP_" + index, "I")), 24, 5, 24, 7, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBiome", "(IIDD)I")));
                    }
                }.targetMethod(new MethodRef(this.getDeobfClass(), "get" + name + "Color", "(LIBlockAccess;III)I")));
            }
        }
    }

    private class BiomeGenBaseMod
    extends ClassMod {
        BiomeGenBaseMod() {
            this.classSignatures.add(new ConstSignature("Ocean"));
            this.classSignatures.add(new ConstSignature("Plains"));
            this.classSignatures.add(new ConstSignature("Desert"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(0xFFFFFF), BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "waterColorMultiplier", "I")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "biomeID", "I")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, this.push(Float.valueOf(0.5f)), BytecodeMatcher.captureReference(181), 42, this.push(Float.valueOf(0.5f)), BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "temperature", "F")).addXref(2, new FieldRef(this.getDeobfClass(), "rainfall", "F")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().startsWith("(Ljava/lang/String;)")) {
                        return this.buildExpression(BinaryRegex.begin(), 42, 43, BytecodeMatcher.captureReference(181), 42, 176, BinaryRegex.end());
                    }
                    return null;
                }
            }.setMethodName("setBiomeName").addXref(1, new FieldRef(this.getDeobfClass(), "biomeName", "Ljava/lang/String;")));
            if (CustomColors.this.haveNewBiomes) {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(182), 11, 12, BytecodeMatcher.anyReference(184), 141, 72, 42, BytecodeMatcher.captureReference(182), 11, 12, BytecodeMatcher.anyReference(184), 141, 74, 39, 41, BytecodeMatcher.anyReference(184), 172);
                    }
                }.addXref(1, new MethodRef(this.getDeobfClass(), "getTemperaturef", "()F")).addXref(2, new MethodRef(this.getDeobfClass(), "getRainfallf", "()F")));
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getGrassColor", "()I"), new MethodRef(this.getDeobfClass(), "getFoliageColor", "()I")).accessFlag(1, true).accessFlag(8, false).accessFlag(16, false));
            } else {
                this.classSignatures.add(new BytecodeSignature(){

                    public String getMatchExpression() {
                        return this.buildExpression(43, BytecodeMatcher.anyReference(185), 28, 29, 21, 4, BytecodeMatcher.captureReference(182), 141, 57, 5, 43, BytecodeMatcher.anyReference(185), 28, 21, 4, BytecodeMatcher.captureReference(182), 141, 57, 7);
                    }
                }.addXref(1, new MethodRef("WorldChunkManager", "getTemperature", "(III)F")).addXref(2, new MethodRef("WorldChunkManager", "getRainfall", "(II)F")));
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getGrassColor", "(LIBlockAccess;III)I"), new MethodRef(this.getDeobfClass(), "getFoliageColor", "(LIBlockAccess;III)I")));
            }
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "color", "I")).accessFlag(1, true));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "map biomes by name";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, 176, BinaryRegex.end());
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setupBiome", "(LBiomeGenBase;)V")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "setBiomeName", "(Ljava/lang/String;)LBiomeGenBase;")));
        }
    }

    private class IBlockAccessMod
    extends BaseMod.IBlockAccessMod {
        IBlockAccessMod() {
            if (CustomColors.this.haveNewBiomes) {
                this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBiomeGenAt", "(II)LBiomeGenBase;")));
            }
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            final MethodRef getRenderColor = new MethodRef(this.getDeobfClass(), "getRenderColor", "(I)I");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().equals(getRenderColor.getType())) {
                        return this.buildExpression(BinaryRegex.begin(), this.push(0xFFFFFF), 172, BinaryRegex.end());
                    }
                    return null;
                }
            }.setMethod(getRenderColor));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override color multiplier for all blocks";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0xFFFFFF));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 28, 29, 21, 4, 43, 28, 29, 21, 4, this.reference(185, new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I")), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBlock", "(LBlock;IIII)I")));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I")));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override default color for all blocks";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(0xFFFFFF));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "colorizeBlock", "(LBlock;)I")));
                }
            }.targetMethod(getRenderColor));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod(MinecraftVersion minecraftVersion) {
            MethodRef runGameLoop = new MethodRef(this.getDeobfClass(), "runGameLoop", "()V");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(65), this.reference(184, new MethodRef("org/lwjgl/input/Keyboard", "isKeyDown", "(I)Z")), 153, BinaryRegex.any(2), this.reference(184, new MethodRef("org/lwjgl/opengl/Display", "update", "()V")));
                }
            }.setMethod(runGameLoop));
            this.mapTexturePackList();
            this.addWorldGetter(minecraftVersion);
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "set up block access";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(182, new MethodRef(MinecraftMod.this.getDeobfClass(), "getWorld", "()LWorld;")), this.push(CustomColors.this.haveNewBiomes), this.reference(184, new MethodRef("com.pclewis.mcpatcher.mod.Colorizer", "setupBlockAccess", "(LIBlockAccess;Z)V")));
                }
            }.targetMethod(runGameLoop));
        }
    }

    private class ConfigPanel
    extends ModConfigPanel {
        private JCheckBox waterCheckBox;
        private JCheckBox swampCheckBox;
        private JCheckBox treeCheckBox;
        private JCheckBox potionCheckBox;
        private JCheckBox particleCheckBox;
        private JPanel panel;
        private JCheckBox lightmapCheckBox;
        private JCheckBox redstoneCheckBox;
        private JCheckBox stemCheckBox;
        private JCheckBox otherBlockCheckBox;
        private JCheckBox eggCheckBox;
        private JCheckBox fogCheckBox;
        private JCheckBox cloudsCheckBox;
        private JCheckBox mapCheckBox;
        private JCheckBox sheepCheckBox;
        private JSpinner fogBlendRadiusSpinner;
        private JSpinner blockBlendRadiusSpinner;
        private JCheckBox textCheckBox;
        private JCheckBox xpOrbCheckBox;

        ConfigPanel() {
            this.$$$setupUI$$$();
            this.waterCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "water", ConfigPanel.this.waterCheckBox.isSelected());
                }
            });
            this.swampCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "swamp", ConfigPanel.this.swampCheckBox.isSelected());
                }
            });
            this.treeCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "tree", ConfigPanel.this.treeCheckBox.isSelected());
                }
            });
            this.potionCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "potion", ConfigPanel.this.potionCheckBox.isSelected());
                }
            });
            this.particleCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "particle", ConfigPanel.this.particleCheckBox.isSelected());
                }
            });
            this.lightmapCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "lightmaps", ConfigPanel.this.lightmapCheckBox.isSelected());
                }
            });
            this.cloudsCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "clouds", ConfigPanel.this.cloudsCheckBox.isSelected());
                }
            });
            this.redstoneCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "redstone", ConfigPanel.this.redstoneCheckBox.isSelected());
                }
            });
            this.stemCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "stem", ConfigPanel.this.stemCheckBox.isSelected());
                }
            });
            this.eggCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "egg", ConfigPanel.this.eggCheckBox.isSelected());
                }
            });
            this.mapCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "map", ConfigPanel.this.mapCheckBox.isSelected());
                }
            });
            this.sheepCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "sheep", ConfigPanel.this.sheepCheckBox.isSelected());
                }
            });
            this.fogCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "fog", ConfigPanel.this.fogCheckBox.isSelected());
                }
            });
            this.otherBlockCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "otherBlocks", ConfigPanel.this.otherBlockCheckBox.isSelected());
                }
            });
            this.textCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "text", ConfigPanel.this.textCheckBox.isSelected());
                }
            });
            this.xpOrbCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Custom Colors", "xporb", ConfigPanel.this.xpOrbCheckBox.isSelected());
                }
            });
            this.fogBlendRadiusSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int value = 7;
                    try {
                        value = Integer.parseInt(ConfigPanel.this.fogBlendRadiusSpinner.getValue().toString());
                        value = Math.min(Math.max(0, value), 99);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    MCPatcherUtils.set("Custom Colors", "fogBlendRadius", value);
                    ConfigPanel.this.fogBlendRadiusSpinner.setValue(value);
                }
            });
            this.blockBlendRadiusSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int value = 1;
                    try {
                        value = Integer.parseInt(ConfigPanel.this.blockBlendRadiusSpinner.getValue().toString());
                        value = Math.min(Math.max(0, value), 99);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    MCPatcherUtils.set("Custom Colors", "blockBlendRadius", value);
                    ConfigPanel.this.blockBlendRadiusSpinner.setValue(value);
                }
            });
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public void load() {
            this.waterCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "water", true));
            this.swampCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "swamp", true));
            this.treeCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "tree", true));
            this.potionCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "potion", true));
            this.particleCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "particle", true));
            this.lightmapCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "lightmaps", true));
            this.cloudsCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "clouds", true));
            this.redstoneCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "redstone", true));
            this.stemCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "stem", true));
            this.eggCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "egg", true));
            this.mapCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "map", true));
            this.sheepCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "sheep", true));
            this.fogCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "fog", true));
            this.otherBlockCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "otherBlocks", true));
            this.textCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "text", true));
            this.xpOrbCheckBox.setSelected(MCPatcherUtils.getBoolean("Custom Colors", "xporb", true));
            this.fogBlendRadiusSpinner.setValue(MCPatcherUtils.getInt("Custom Colors", "fogBlendRadius", 7));
            this.blockBlendRadiusSpinner.setValue(MCPatcherUtils.getInt("Custom Colors", "blockBlendRadius", 1));
            this.eggCheckBox.setVisible(CustomColors.this.haveSpawnerEggs);
        }

        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JSpinner jSpinner;
            JSpinner jSpinner2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JCheckBox jCheckBox12;
            JCheckBox jCheckBox13;
            JCheckBox jCheckBox14;
            JCheckBox jCheckBox15;
            JCheckBox jCheckBox16;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(16, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.waterCheckBox = jCheckBox16 = new JCheckBox();
            jCheckBox16.setText("Water");
            jCheckBox16.setToolTipText("");
            jPanel.add((Component)jCheckBox16, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.swampCheckBox = jCheckBox15 = new JCheckBox();
            jCheckBox15.setText("Swamp grass and foliage");
            jCheckBox15.setToolTipText("");
            jPanel.add((Component)jCheckBox15, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.potionCheckBox = jCheckBox14 = new JCheckBox();
            jCheckBox14.setText("Potions");
            jCheckBox14.setToolTipText("");
            jPanel.add((Component)jCheckBox14, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.particleCheckBox = jCheckBox13 = new JCheckBox();
            jCheckBox13.setText("Particle effects");
            jCheckBox13.setToolTipText("");
            jPanel.add((Component)jCheckBox13, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.treeCheckBox = jCheckBox12 = new JCheckBox();
            jCheckBox12.setText("Pine and birch trees");
            jCheckBox12.setToolTipText("");
            jPanel.add((Component)jCheckBox12, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.lightmapCheckBox = jCheckBox11 = new JCheckBox();
            jCheckBox11.setText("Lighting");
            jCheckBox11.setToolTipText("");
            jPanel.add((Component)jCheckBox11, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.redstoneCheckBox = jCheckBox10 = new JCheckBox();
            jCheckBox10.setText("Redstone wiring and particle effects");
            jCheckBox10.setToolTipText("");
            jPanel.add((Component)jCheckBox10, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Allow texture packs to customize the following colors:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.stemCheckBox = jCheckBox9 = new JCheckBox();
            jCheckBox9.setText("Pumpkin and melon stems");
            jPanel.add((Component)jCheckBox9, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.eggCheckBox = jCheckBox8 = new JCheckBox();
            jCheckBox8.setText("Creative Mode spawner eggs");
            jPanel.add((Component)jCheckBox8, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.cloudsCheckBox = jCheckBox7 = new JCheckBox();
            jCheckBox7.setText("Cloud type");
            jPanel.add((Component)jCheckBox7, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.mapCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setText("Held maps");
            jPanel.add((Component)jCheckBox6, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.sheepCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setText("Sheep");
            jPanel.add((Component)jCheckBox5, new GridConstraints(12, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayoutManager(2, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(15, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
            this.fogCheckBox = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("Fog and sky");
            jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.otherBlockCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setText("Other blocks");
            jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Blend radius:");
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Blend radius:");
            jPanel2.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.fogBlendRadiusSpinner = jSpinner2 = new JSpinner();
            jPanel2.add((Component)jSpinner2, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, null, null));
            this.blockBlendRadiusSpinner = jSpinner = new JSpinner();
            jPanel2.add((Component)jSpinner, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText("blocks");
            jPanel2.add((Component)jLabel4, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            jLabel5.setText("blocks");
            jPanel2.add((Component)jLabel5, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel2.add((Component)spacer3, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel2.add((Component)spacer4, new GridConstraints(1, 5, 1, 1, 0, 1, 6, 1, null, null, null));
            this.textCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Text");
            jPanel.add((Component)jCheckBox2, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.xpOrbCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("XP orbs");
            jPanel.add((Component)jCheckBox, new GridConstraints(14, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

