/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javassist.bytecode.MethodInfo;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectedTextures
extends Mod {
    public ConnectedTextures(MinecraftVersion minecraftVersion) {
        this.name = "Connected Textures";
        this.author = "MCPatcher";
        this.description = "Connects adjacent blocks of the same type.";
        this.version = "1.3";
        this.configPanel = new ConfigPanel();
        this.classMods.add(new MinecraftMod());
        this.classMods.add(new RenderEngineMod());
        this.classMods.add(new BaseMod.TexturePackListMod(minecraftVersion));
        this.classMods.add(new BaseMod.TexturePackBaseMod(minecraftVersion));
        this.classMods.add(new BaseMod.IBlockAccessMod());
        this.classMods.add(new BlockMod());
        this.classMods.add(new TessellatorMod());
        this.classMods.add(new RenderBlocksMod());
        this.classMods.add(new WorldRendererMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.CTMUtils"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.SuperTessellator"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride$CTM"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride$Random1"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride$Horizontal"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride$Vertical"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride$Top"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.mod.TileOverride$Repeat"));
        this.getClassMap().addInheritance("Tessellator", "com.pclewis.mcpatcher.mod.SuperTessellator");
    }

    private class WorldRendererMod
    extends ClassMod {
        WorldRendererMod() {
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            final MethodRef start = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "start", "()V");
            final MethodRef finish = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "finish", "()V");
            this.classSignatures.add(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.000001f)));
                }
            }.setMethod(updateRenderer));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "pre render world";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(184, start)});
                }
            }.targetMethod(updateRenderer));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "post render world";
                }

                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.reference(184, finish), 177);
                }
            }.targetMethod(updateRenderer));
        }
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        private final MethodRef[] faceMethods = new MethodRef[6];
        private final FieldRef overrideBlockTexture = new FieldRef(this.getDeobfClass(), "overrideBlockTexture", "I");
        private final FieldRef blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
        private final FieldRef instance = new FieldRef("Tessellator", "instance", "LTessellator;");
        private final MethodRef renderStandardBlock = new MethodRef(this.getDeobfClass(), "renderStandardBlock", "(LBlock;III)Z");
        private final MethodRef drawCrossedSquares = new MethodRef(this.getDeobfClass(), "drawCrossedSquares", "(LBlock;IDDD)V");
        private final MethodRef setup = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "setup", "(LRenderBlocks;LBlock;IIIII)Z");
        private final MethodRef setupNoFace = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "setup", "(LRenderBlocks;LBlock;IIII)Z");
        private final MethodRef reset = new MethodRef("com.pclewis.mcpatcher.mod.CTMUtils", "reset", "()V");
        private final FieldRef newTextureIndex = new FieldRef("com.pclewis.mcpatcher.mod.CTMUtils", "newTextureIndex", "I");
        private final FieldRef newTessellator = new FieldRef("com.pclewis.mcpatcher.mod.CTMUtils", "newTessellator", "LTessellator;");
        private ArrayList<MethodInfo> renderMethods = new ArrayList();
        private ArrayList<Integer> tessellatorRegisters = new ArrayList();

        RenderBlocksMod() {
            this.setupBlockFace(0, "Bottom");
            this.setupBlockFace(1, "Top");
            this.setupBlockFace(2, "North");
            this.setupBlockFace(3, "South");
            this.setupBlockFace(4, "West");
            this.setupBlockFace(5, "East");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(182), 87, 42, this.push(156), BytecodeMatcher.captureReference(181));
                }
            }.addXref(1, this.renderStandardBlock).addXref(2, this.overrideBlockTexture));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, this.blockAccess));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, this.faceMethods));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, this.drawCrossedSquares));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "find potential render methods";
                }

                public boolean filterMethod(MethodInfo methodInfo) {
                    return methodInfo.getDescriptor().matches("^\\(L[a-z]+;III.*");
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(178, RenderBlocksMod.this.instance), 58, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    RenderBlocksMod.this.renderMethods.add(this.getMethodInfo());
                    RenderBlocksMod.this.tessellatorRegisters.add(this.getCaptureGroup(1)[0] & 0xFF);
                    return null;
                }
            });
            this.patches.add(new BytecodePatch.InsertBefore(){
                private int tessellatorRegister;

                public String getDescription() {
                    return "override texture (other blocks)";
                }

                public boolean filterMethod(MethodInfo methodInfo) {
                    for (int i = 0; i < RenderBlocksMod.this.renderMethods.size(); ++i) {
                        MethodInfo m = (MethodInfo)RenderBlocksMod.this.renderMethods.get(i);
                        if (!methodInfo.getName().equals(m.getName()) || !methodInfo.getDescriptor().equals(m.getDescriptor())) continue;
                        this.tessellatorRegister = (Integer)RenderBlocksMod.this.tessellatorRegisters.get(i);
                        return true;
                    }
                    return false;
                }

                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), this.push(15), 126, this.push(4), 120, 54, BinaryRegex.any(), 21, BinaryRegex.backReference(1), this.push(240), 126, 54, BinaryRegex.any());
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 156, RenderBlocksMod.this.branch("A"), 42, 43, 28, 29, 21, 4, 21, this.getCaptureGroup(1), this.reference(184, RenderBlocksMod.this.setupNoFace), 153, RenderBlocksMod.this.branch("A"), this.reference(178, RenderBlocksMod.this.newTextureIndex), 54, this.getCaptureGroup(1), this.reference(178, RenderBlocksMod.this.newTessellator), 58, this.tessellatorRegister, RenderBlocksMod.this.label("A"));
                }
            });
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "override texture (crossed squares)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.reference(178, RenderBlocksMod.this.instance), 58, BinaryRegex.capture(BinaryRegex.any()), 43, 3, 28, BytecodeMatcher.anyReference(182), 54, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 156, RenderBlocksMod.this.branch("A"), 42, 43, 41, 142, 24, 5, 142, 24, 7, 142, 21, this.getCaptureGroup(2), this.reference(184, RenderBlocksMod.this.setupNoFace), 153, RenderBlocksMod.this.branch("A"), this.reference(178, RenderBlocksMod.this.newTextureIndex), 54, this.getCaptureGroup(2), this.reference(178, RenderBlocksMod.this.newTessellator), 58, this.getCaptureGroup(1), RenderBlocksMod.this.label("A"));
                }
            }.targetMethod(this.drawCrossedSquares));
        }

        private void setupBlockFace(final int face, final String direction) {
            this.faceMethods[face] = new MethodRef(this.getDeobfClass(), "render" + direction + "Face", "(LBlock;DDDI)V");
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "override texture (" + direction.toLowerCase() + " face)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), 58, BinaryRegex.capture(BinaryRegex.any()), 42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture))), 155, BinaryRegex.any(2), BinaryRegex.capture(BinaryRegex.build(42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 54, BinaryRegex.capture(BinaryRegex.any()))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 155, RenderBlocksMod.this.branch("A"), this.getCaptureGroup(3), this.reference(184, RenderBlocksMod.this.reset), 167, RenderBlocksMod.this.branch("B"), RenderBlocksMod.this.label("A"), 42, 43, 40, 142, 24, 4, 142, 24, 6, 142, this.push(face), 21, this.getCaptureGroup(4), this.reference(184, RenderBlocksMod.this.setup), 153, RenderBlocksMod.this.branch("B"), this.reference(178, RenderBlocksMod.this.newTextureIndex), 54, this.getCaptureGroup(4), this.reference(178, RenderBlocksMod.this.newTessellator), 58, this.getCaptureGroup(2), RenderBlocksMod.this.label("B"));
                }
            }.targetMethod(this.faceMethods[face]));
        }
    }

    private class TessellatorMod
    extends ClassMod {
        TessellatorMod() {
            MethodRef draw = new MethodRef(this.getDeobfClass(), "draw", "()I");
            MethodRef startDrawingQuads = new MethodRef(this.getDeobfClass(), "startDrawingQuads", "()V");
            MethodRef startDrawing = new MethodRef(this.getDeobfClass(), "startDrawing", "(I)V");
            final MethodRef constructor = new MethodRef("Tessellator", "<init>", "(I)V");
            final MethodRef constructor0 = new MethodRef("Tessellator", "<init>", "()V");
            final MethodRef reset = new MethodRef(this.getDeobfClass(), "reset", "()V");
            MethodRef addVertex = new MethodRef(this.getDeobfClass(), "addVertex", "(DDD)V");
            FieldRef instance = new FieldRef(this.getDeobfClass(), "instance", "LTessellator;");
            FieldRef isDrawing = new FieldRef(this.getDeobfClass(), "isDrawing", "Z");
            FieldRef drawMode = new FieldRef(this.getDeobfClass(), "drawMode", "I");
            final FieldRef texture = new FieldRef(this.getDeobfClass(), "texture", "I");
            FieldRef bufferSize = new FieldRef(this.getDeobfClass(), "bufferSize", "I");
            FieldRef addedVertices = new FieldRef(this.getDeobfClass(), "addedVertices", "I");
            FieldRef vertexCount = new FieldRef(this.getDeobfClass(), "vertexCount", "I");
            FieldRef rawBufferIndex = new FieldRef(this.getDeobfClass(), "rawBufferIndex", "I");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("Not tesselating!"));
                }
            }.setMethod(draw));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.push(4), 112, BinaryRegex.any(0, 1000), 42, 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181), 42, 89, BytecodeMatcher.captureReference(180), this.push(8), 96, BytecodeMatcher.anyReference(181));
                }
            }.setMethod(addVertex).addXref(1, addedVertices).addXref(2, vertexCount).addXref(3, rawBufferIndex));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), BinaryRegex.any(0, 50), this.push("Already tesselating!"), BinaryRegex.any(0, 100), 42, BytecodeMatcher.captureReference(183), 42, 27, BytecodeMatcher.captureReference(181));
                }
            }.setMethod(startDrawing).addXref(1, isDrawing).addXref(2, reset).addXref(3, drawMode));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, this.push(7), BytecodeMatcher.captureReference(182), 177, BinaryRegex.end());
                }
            }.setMethod(startDrawingQuads).addXref(1, startDrawing));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, bufferSize));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, instance).accessFlag(8, true));
            for (JavaRef ref : new JavaRef[]{constructor, startDrawing, isDrawing, drawMode, draw, reset, bufferSize, addedVertices, vertexCount, rawBufferIndex}) {
                this.patches.add(new MakeMemberPublicPatch(ref));
            }
            this.patches.add(new AddFieldPatch(texture));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "replace tessellator instance";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isStaticInitializer()) {
                        return this.buildExpression(this.reference(187, new ClassRef("Tessellator")), 89, BinaryRegex.capture(BinaryRegex.optional(BytecodeMatcher.anyLDC)), BinaryRegex.capture(BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(183, constructor)}), BinaryRegex.build(new Object[]{this.reference(183, constructor0)}))));
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    boolean isForge = this.getCaptureGroup(1).length == 0;
                    return this.buildCode(this.reference(187, new ClassRef("com.pclewis.mcpatcher.mod.SuperTessellator")), 89, this.getCaptureGroup(1), this.reference(183, new MethodRef("com.pclewis.mcpatcher.mod.SuperTessellator", "<init>", isForge ? "()V" : "(I)V")));
                }
            });
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "initialize texture field to -1";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(177);
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.push(-1), this.reference(181, texture));
                }
            });
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "bind texture before drawing";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(42, BytecodeMatcher.anyReference(180)), BytecodeMatcher.anyReference(178)), this.reference(182, new MethodRef("java/nio/IntBuffer", "clear", "()Ljava/nio/Buffer;")), 87);
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, texture), 155, TessellatorMod.this.branch("A"), this.push(3553), 42, this.reference(180, texture), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glBindTexture", "(II)V")), TessellatorMod.this.label("A"));
                }
            }.targetMethod(draw));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "fix references to reset method";
                }

                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(183, reset)});
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(new Object[]{this.reference(182, reset)});
                }
            });
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            MethodRef getBlockTexture = new MethodRef(this.getDeobfClass(), "getBlockTexture", "(LIBlockAccess;IIII)I");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 21, 5, 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(185), BytecodeMatcher.captureReference(182), 172, BinaryRegex.end());
                }
            }.setMethod(getBlockTexture).addXref(1, new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I")).addXref(2, new MethodRef(this.getDeobfClass(), "getBlockTextureFromSideAndMetadata", "(II)I")));
        }
    }

    private class RenderEngineMod
    extends ClassMod {
        RenderEngineMod() {
            this.classSignatures.add(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V")));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getTexture", "(Ljava/lang/String;)I")).accessFlag(1, true).accessFlag(8, false));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "allocateAndSetupTexture", "(Ljava/awt/image/BufferedImage;)I")).accessFlag(1, true).accessFlag(8, false));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            this.mapTexturePackList();
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;")));
        }
    }

    private class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JCheckBox glassCheckBox;
        private JCheckBox glassPaneCheckBox;
        private JCheckBox bookshelfCheckBox;
        private JCheckBox sandstoneCheckBox;
        private JCheckBox standardCheckBox;
        private JCheckBox nonStandardCheckBox;
        private JCheckBox outlineCheckBox;

        public ConfigPanel() {
            this.$$$setupUI$$$();
            this.glassCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "glass", ConfigPanel.this.glassCheckBox.isSelected());
                }
            });
            this.glassPaneCheckBox.setVisible(false);
            this.glassPaneCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "glassPane", ConfigPanel.this.glassPaneCheckBox.isSelected());
                }
            });
            this.bookshelfCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "bookshelf", ConfigPanel.this.bookshelfCheckBox.isSelected());
                }
            });
            this.sandstoneCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "sandstone", ConfigPanel.this.sandstoneCheckBox.isSelected());
                }
            });
            this.standardCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "standard", ConfigPanel.this.standardCheckBox.isSelected());
                }
            });
            this.nonStandardCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "nonStandard", ConfigPanel.this.nonStandardCheckBox.isSelected());
                }
            });
            this.outlineCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("Connected Textures", "outline", ConfigPanel.this.outlineCheckBox.isSelected());
                }
            });
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public void load() {
            this.glassCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "glass", true));
            this.glassPaneCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "glassPane", true));
            this.bookshelfCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "bookshelf", true));
            this.sandstoneCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "sandstone", true));
            this.standardCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "standard", true));
            this.nonStandardCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "nonStandard", true));
            this.outlineCheckBox.setSelected(MCPatcherUtils.getBoolean("Connected Textures", "outline", false));
        }

        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.glassCheckBox = jCheckBox7 = new JCheckBox();
            jCheckBox7.setText("Glass blocks");
            jPanel.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.glassPaneCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setText("Glass panes");
            jPanel.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.bookshelfCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setText("Bookshelves");
            jPanel.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.sandstoneCheckBox = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("Sandstone");
            jPanel.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.standardCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setToolTipText("Standard 6-sixed blocks");
            jCheckBox3.setText("Other standard blocks");
            jPanel.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Apply replacement textures to:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.outlineCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("<html>Outline mode <font color=\"#ff0000\">(Experimental)</font></html>");
            jPanel.add((Component)jCheckBox2, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.nonStandardCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText("Covers most other block types (flowers, grass, etc.)");
            jCheckBox.setText("Non-standard blocks");
            jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

