/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.mod.SuperTessellator;
import com.pclewis.mcpatcher.mod.TileOverride;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Properties;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TexturePackBase;
import org.lwjgl.opengl.GL11;

public class CTMUtils {
    private static final boolean enableGlass = MCPatcherUtils.getBoolean("Connected Textures", "glass", true);
    private static final boolean enableGlassPane = false;
    private static final boolean enableBookshelf = MCPatcherUtils.getBoolean("Connected Textures", "bookshelf", true);
    private static final boolean enableSandstone = MCPatcherUtils.getBoolean("Connected Textures", "sandstone", true);
    private static final boolean enableStandard = MCPatcherUtils.getBoolean("Connected Textures", "standard", true);
    private static final boolean enableNonStandard = MCPatcherUtils.getBoolean("Connected Textures", "nonStandard", true);
    private static final boolean enableOutline = MCPatcherUtils.getBoolean("Connected Textures", "outline", false);
    static final int BLOCK_ID_LOG = 17;
    static final int BLOCK_ID_GLASS = 20;
    static final int BLOCK_ID_BED = 26;
    static final int BLOCK_ID_GLASS_PANE = 102;
    static final int BLOCK_ID_BOOKSHELF = 47;
    static final int NUM_TILES = 256;
    static final int TILE_NUM_STILL_LAVA = 237;
    static final int TILE_NUM_FLOWING_LAVA = 238;
    static final int TILE_NUM_STILL_WATER = 205;
    static final int TILE_NUM_FLOWING_WATER = 206;
    static final int TILE_NUM_FIRE_E_W = 31;
    static final int TILE_NUM_FIRE_N_S = 47;
    static final int TILE_NUM_PORTAL = 14;
    static final int TILE_NUM_SANDSTONE_SIDE = 192;
    static TexturePackBase lastTexturePack;
    static int terrainTexture;
    private static TileOverride[][] blockOverrides;
    private static TileOverride[][] tileOverrides;
    private static boolean active;
    private static int newTexture;
    public static int newTextureIndex;
    public static Tessellator newTessellator;

    public static void start() {
        CTMUtils.checkUpdate();
        Tessellator.instance.texture = terrainTexture;
        if (Tessellator.instance instanceof SuperTessellator) {
            active = true;
        }
    }

    public static boolean setup(RenderBlocks renderBlocks, Block block, int i, int j, int k, int face, int origTexture) {
        IBlockAccess blockAccess = renderBlocks.blockAccess;
        if (!active || !enableStandard || blockAccess == null || face < 0 || face > 5) {
            return false;
        }
        if (block.blockID == 26 || block.blockID == 102) {
            return false;
        }
        if (CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, face)) {
            newTessellator = ((SuperTessellator)Tessellator.instance).getTessellator(newTexture);
            return true;
        }
        CTMUtils.reset();
        return false;
    }

    public static boolean setup(RenderBlocks renderBlocks, Block block, int i, int j, int k, int origTexture) {
        IBlockAccess blockAccess = renderBlocks.blockAccess;
        if (!active || !enableNonStandard || blockAccess == null) {
            return false;
        }
        if (block.blockID == 26 || block.blockID == 102) {
            return false;
        }
        if (CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, -1)) {
            newTessellator = ((SuperTessellator)Tessellator.instance).getTessellator(newTexture);
            return true;
        }
        CTMUtils.reset();
        return false;
    }

    public static void reset() {
    }

    public static void finish() {
        CTMUtils.reset();
        Tessellator.instance.texture = -1;
        active = false;
    }

    private static boolean getConnectedTexture(RenderBlocks renderBlocks, IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face) {
        return CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, face, tileOverrides, origTexture) || CTMUtils.getConnectedTexture(renderBlocks, blockAccess, block, origTexture, i, j, k, face, blockOverrides, block.blockID);
    }

    private static boolean getConnectedTexture(RenderBlocks renderBlocks, IBlockAccess blockAccess, Block block, int origTexture, int i, int j, int k, int face, TileOverride[][] allOverrides, int index) {
        if (index < 0 || index >= allOverrides.length) {
            return false;
        }
        TileOverride[] overrides = allOverrides[index];
        if (overrides == null) {
            return false;
        }
        for (int n = 0; n < overrides.length; ++n) {
            TileOverride override = overrides[n];
            if (override == null) continue;
            if (override.disabled) {
                overrides[n] = null;
                continue;
            }
            newTexture = override.texture;
            newTextureIndex = override.getTile(renderBlocks, blockAccess, block, origTexture, i, j, k, face);
            if (newTextureIndex < 0) continue;
            return true;
        }
        return false;
    }

    private static void checkUpdate() {
        TexturePackBase selectedTexturePack = MCPatcherUtils.getMinecraft().texturePackList.getSelectedTexturePack();
        if (selectedTexturePack == lastTexturePack) {
            return;
        }
        MCPatcherUtils.info("refreshing connected textures", new Object[0]);
        lastTexturePack = selectedTexturePack;
        terrainTexture = CTMUtils.getTexture("/terrain.png");
        if (Tessellator.instance instanceof SuperTessellator) {
            ((SuperTessellator)Tessellator.instance).clearTessellators();
        }
        blockOverrides = CTMUtils.loadOverrides("block", Block.blocksList.length, false);
        tileOverrides = CTMUtils.loadOverrides("terrain", 256, true);
        Properties properties = new Properties();
        if (enableGlass) {
            properties.clear();
            properties.setProperty("method", "glass");
            properties.setProperty("connect", "block");
            CTMUtils.loadBasicOverride(properties, blockOverrides, 20);
        }
        if (enableBookshelf) {
            properties.clear();
            properties.setProperty("method", "bookshelf");
            properties.setProperty("connect", "block");
            CTMUtils.loadBasicOverride(properties, blockOverrides, 47);
        }
        if (enableSandstone) {
            properties.clear();
            properties.setProperty("method", "sandstone");
            properties.setProperty("connect", "tile");
            properties.setProperty("metadata", "0");
            CTMUtils.loadBasicOverride(properties, tileOverrides, 192);
        }
        if (enableOutline) {
            CTMUtils.setupOutline();
        }
        GL11.glBindTexture((int)3553, (int)terrainTexture);
    }

    private static TileOverride[][] loadOverrides(String type, int length, boolean connectByTile) {
        TileOverride[][] allOverrides = new TileOverride[length][];
        if (enableStandard || enableNonStandard) {
            for (int i = 0; i < length; ++i) {
                ArrayList<TileOverride> tmpOverrides = null;
                for (char c = '`'; c <= 'z'; c = (char)(c + '\u0001')) {
                    String prefix = "/ctm/" + type + i + (c >= 'a' ? "" + c : "");
                    TileOverride override = TileOverride.create(prefix, null, connectByTile);
                    if (override == null) {
                        if (c < 97) continue;
                        break;
                    }
                    if (tmpOverrides == null) {
                        tmpOverrides = new ArrayList<TileOverride>();
                    }
                    tmpOverrides.add(override);
                }
                if (tmpOverrides == null) continue;
                allOverrides[i] = new TileOverride[tmpOverrides.size()];
                tmpOverrides.toArray(allOverrides[i]);
            }
        }
        return allOverrides;
    }

    private static void loadBasicOverride(Properties properties, TileOverride[][] allOverrides, int index) {
        TileOverride override = TileOverride.create("/ctm", properties, false);
        if (override == null || allOverrides == null || index < 0 || index >= allOverrides.length) {
            return;
        }
        TileOverride[] oldList = allOverrides[index];
        if (oldList == null) {
            allOverrides[index] = new TileOverride[]{override};
        } else {
            TileOverride[] newList = new TileOverride[oldList.length + 1];
            System.arraycopy(oldList, 0, newList, 0, oldList.length);
            newList[oldList.length] = override;
            allOverrides[index] = newList;
        }
    }

    private static void setupOutline() {
        BufferedImage terrain = MCPatcherUtils.readImage(lastTexturePack.getInputStream("/terrain.png"));
        if (terrain == null) {
            return;
        }
        BufferedImage template = MCPatcherUtils.readImage(lastTexturePack.getInputStream("/ctm/template.png"));
        if (template == null) {
            return;
        }
        int width = terrain.getWidth();
        int height = terrain.getHeight();
        if (template.getWidth() != width) {
            BufferedImage newImage = new BufferedImage(width, height, 2);
            Graphics2D graphics2D = newImage.createGraphics();
            graphics2D.drawImage(template, 0, 0, width, height, null);
            template = newImage;
        }
        for (int i = 0; i < tileOverrides.length; ++i) {
            TileOverride override = CTMUtils.setupOutline(i, terrain, template);
            if (override == null) continue;
            TileOverride[] oldList = tileOverrides[i];
            if (oldList == null) {
                CTMUtils.tileOverrides[i] = new TileOverride[]{override};
                continue;
            }
            TileOverride[] newList = new TileOverride[oldList.length + 1];
            System.arraycopy(oldList, 0, newList, 0, oldList.length);
            newList[oldList.length] = override;
            CTMUtils.tileOverrides[i] = newList;
        }
    }

    private static TileOverride setupOutline(int tileNum, BufferedImage terrain, BufferedImage template) {
        switch (tileNum) {
            case 14: 
            case 31: 
            case 47: 
            case 205: 
            case 206: 
            case 237: 
            case 238: {
                return null;
            }
        }
        int tileSize = terrain.getWidth() / 16;
        int tileX = tileNum % 16 * tileSize;
        int tileY = tileNum / 16 * tileSize;
        BufferedImage newImage = new BufferedImage(template.getWidth(), template.getHeight(), 2);
        for (int x = 0; x < template.getWidth(); ++x) {
            for (int y = 0; y < template.getHeight(); ++y) {
                int rgb = template.getRGB(x, y);
                if ((rgb & 0xFF000000) == 0) {
                    rgb = terrain.getRGB(tileX + x % tileSize, tileY + y % tileSize);
                }
                newImage.setRGB(x, y, rgb);
            }
        }
        return TileOverride.create(newImage);
    }

    static int getTexture(String name) {
        if (name == null) {
            return -1;
        }
        BufferedImage image = MCPatcherUtils.readImage(lastTexturePack.getInputStream(name));
        if (image == null) {
            return -1;
        }
        return MCPatcherUtils.getMinecraft().renderEngine.getTexture(name);
    }
}

