/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FixedBytecodeSignature;
import com.pclewis.mcpatcher.InterfaceMethodRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;

public class BetterGrass
extends Mod {
    private static final String field_MATRIX = "grassMatrix";
    private static final String fieldtype_MATRIX = "[[I";
    private boolean haveAO;

    public BetterGrass(MinecraftVersion minecraftVersion) {
        this.name = "Better Grass";
        this.author = "MCPatcher";
        this.description = "Improves the look of the sides of grass blocks. Inspired by MrMessiah's mod.";
        this.version = "1.0";
        this.defaultEnabled = false;
        this.haveAO = minecraftVersion.compareTo("Beta 1.6") >= 0;
        this.classMods.add(new MaterialMod());
        this.classMods.add(new BlockMod());
        this.classMods.add(new BlockGrassMod("Grass", 2, 3, 0));
        if (minecraftVersion.compareTo("Beta 1.9 Prerelease 1") >= 0) {
            this.classMods.add(new BlockGrassMod("Mycelium", 110, 77, 78));
        }
        this.classMods.add(new BaseMod.IBlockAccessMod().mapMaterial());
        this.classMods.add(new RenderBlocksMod());
    }

    private class RenderBlocksMod
    extends ClassMod {
        private int eastFace;
        private int westFace;
        private int northFace;
        private int southFace;
        private int redMultiplier;
        private int greenMultiplier;
        private int blueMultiplier;

        RenderBlocksMod() {
            this.classSignatures.add(new ConstSignature(0.02734375));
            this.classSignatures.add(new ConstSignature(0.0234375));
            this.classSignatures.add(new ConstSignature(0.03515625));
            this.classSignatures.add(new ConstSignature(0.03125));
            MethodRef renderStandardBlockWithColorMultiplier = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithColorMultiplier", "(LBlock;IIIFFF)Z");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().matches("^\\(L[^;]+;IIIFFF\\)Z$")) {
                        return this.buildExpression(this.push(Float.valueOf(0.5f)), 56, BinaryRegex.any(), this.push(Float.valueOf(1.0f)), 56, BinaryRegex.capture(BinaryRegex.any()), this.push(Float.valueOf(0.8f)), 56, BinaryRegex.any(), this.push(Float.valueOf(0.6f)), 56, BinaryRegex.any(), BinaryRegex.any(0, 20), 23, BinaryRegex.backReference(1), 23, 5, 106, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(1), 23, 6, 106, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(1), 23, 7, 106, 56, BinaryRegex.capture(BinaryRegex.any()));
                    }
                    return null;
                }

                public void afterMatch(ClassFile classFile) {
                    RenderBlocksMod.this.redMultiplier = this.matcher.getCaptureGroup(2)[0] & 0xFF;
                    RenderBlocksMod.this.greenMultiplier = this.matcher.getCaptureGroup(3)[0] & 0xFF;
                    RenderBlocksMod.this.blueMultiplier = this.matcher.getCaptureGroup(4)[0] & 0xFF;
                    Logger.log(3, "non-AO multipliers (R G B) = (%d %d %d)", RenderBlocksMod.this.redMultiplier, RenderBlocksMod.this.greenMultiplier, RenderBlocksMod.this.blueMultiplier);
                }
            }.setMethod(renderStandardBlockWithColorMultiplier));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;")));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "if (getBlockTexture == 0) useBiomeColor = true (non-AO pre-1.8)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(25, BinaryRegex.capture(BinaryRegex.any()), BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.backReference(3), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.backReference(3), 106, BytecodeMatcher.captureReference(182))), BinaryRegex.capture(BinaryRegex.build(43, 42, this.reference(180, new FieldRef("RenderBlocks", "blockAccess", "LIBlockAccess;")), 28, 29, 21, 4, BinaryRegex.any(1, 2), this.reference(182, new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I")))), 54, BinaryRegex.capture(BinaryRegex.any()));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(5), 89, 54, this.getCaptureGroup(6), 154, RenderBlocksMod.this.branch("A"), 25, this.getCaptureGroup(2), 23, RenderBlocksMod.this.redMultiplier, 23, this.getCaptureGroup(3), 106, 23, RenderBlocksMod.this.greenMultiplier, 23, this.getCaptureGroup(3), 106, 23, RenderBlocksMod.this.blueMultiplier, 23, this.getCaptureGroup(3), 106, this.getCaptureGroup(4), 167, RenderBlocksMod.this.branch("B"), RenderBlocksMod.this.label("A"), this.getCaptureGroup(1), RenderBlocksMod.this.label("B"));
                }
            }.targetMethod(renderStandardBlockWithColorMultiplier));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "if (getBlockTexture == 0) useBiomeColor = true (non-AO post-1.8)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(43, 42, this.reference(180, new FieldRef("RenderBlocks", "blockAccess", "LIBlockAccess;")), 28, 29, 21, 4, BinaryRegex.any(1, 2), this.reference(182, new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I")))), 54, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.capture(BinaryRegex.any(20, 40)), BinaryRegex.capture(BinaryRegex.build(25, BinaryRegex.capture(BinaryRegex.any()), BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.anyFLOAD, 23, BinaryRegex.capture(BinaryRegex.any()), 106, BytecodeMatcher.captureReference(182))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 54, this.getCaptureGroup(2), 21, this.getCaptureGroup(2), 154, RenderBlocksMod.this.branch("A"), 25, this.getCaptureGroup(5), 23, 5, 23, this.getCaptureGroup(6), 106, 23, 6, 23, this.getCaptureGroup(7), 106, 23, 7, 23, this.getCaptureGroup(8), 106, this.getCaptureGroup(9), RenderBlocksMod.this.label("A"), this.getCaptureGroup(3), this.getCaptureGroup(4));
                }
            }.targetMethod(renderStandardBlockWithColorMultiplier));
            if (BetterGrass.this.haveAO) {
                this.setupAO();
            }
        }

        private void setupAO() {
            MethodRef renderStandardBlockWithAmbientOcclusion = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithAmbientOcclusion", "(LBlock;IIIFFF)Z");
            this.classSignatures.add(new FixedBytecodeSignature(new Object[]{3, BinaryRegex.or(BinaryRegex.build(89, 54, BinaryRegex.capture(BinaryRegex.any()), 89, 54, BinaryRegex.capture(BinaryRegex.any()), 89, 54, BinaryRegex.capture(BinaryRegex.any()), 89, 54, BinaryRegex.capture(BinaryRegex.any())), BinaryRegex.build(54, BinaryRegex.capture(BinaryRegex.any()), 3, 54, BinaryRegex.capture(BinaryRegex.any()), 3, 54, BinaryRegex.capture(BinaryRegex.any()), 3, 54, BinaryRegex.capture(BinaryRegex.any()), 3)), BytecodeMatcher.anyISTORE}){

                public void afterMatch(ClassFile classFile) {
                    byte[][] m;
                    RenderBlocksMod.this.southFace = m[(m = new byte[][]{this.matcher.getCaptureGroup(1), this.matcher.getCaptureGroup(2), this.matcher.getCaptureGroup(3), this.matcher.getCaptureGroup(4), this.matcher.getCaptureGroup(5), this.matcher.getCaptureGroup(6), this.matcher.getCaptureGroup(7), this.matcher.getCaptureGroup(8)})[0] == null ? 4 : 0][0] & 0xFF;
                    RenderBlocksMod.this.northFace = m[m[1] == null ? 5 : 1][0] & 0xFF;
                    RenderBlocksMod.this.westFace = m[m[2] == null ? 6 : 2][0] & 0xFF;
                    RenderBlocksMod.this.eastFace = m[m[3] == null ? 7 : 3][0] & 0xFF;
                    Logger.log(3, "AO faces (N S E W) = (%d %d %d %d)", RenderBlocksMod.this.northFace, RenderBlocksMod.this.southFace, RenderBlocksMod.this.eastFace, RenderBlocksMod.this.westFace);
                }
            }.setMethod(renderStandardBlockWithAmbientOcclusion));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "if (getBlockTexture == 0) useBiomeColor = true (AO)";
                }

                public String getMatchExpression() {
                    return BinaryRegex.capture(BinaryRegex.build(3, BinaryRegex.or(BinaryRegex.build(89, 54, RenderBlocksMod.this.southFace, 89, 54, RenderBlocksMod.this.northFace, 89, 54, RenderBlocksMod.this.westFace, 89, 54, RenderBlocksMod.this.eastFace), BinaryRegex.build(54, RenderBlocksMod.this.southFace, 3, 54, RenderBlocksMod.this.northFace, 3, 54, RenderBlocksMod.this.westFace, 3, 54, RenderBlocksMod.this.eastFace, 3)), BytecodeMatcher.anyISTORE));
                }

                public byte[] getReplacementBytes() throws IOException {
                    byte[] blockAccess = this.reference(180, new FieldRef("RenderBlocks", "blockAccess", "LIBlockAccess;"));
                    byte[] getBlockTexture = this.reference(182, new MethodRef("Block", "getBlockTexture", "(LIBlockAccess;IIII)I"));
                    return this.buildCode(this.getCaptureGroup(1), 43, 42, blockAccess, 28, 29, 21, 4, 5, getBlockTexture, 154, RenderBlocksMod.this.branch("east"), 4, 54, RenderBlocksMod.this.eastFace, RenderBlocksMod.this.label("east"), 43, 42, blockAccess, 28, 29, 21, 4, 6, getBlockTexture, 154, RenderBlocksMod.this.branch("west"), 4, 54, RenderBlocksMod.this.westFace, RenderBlocksMod.this.label("west"), 43, 42, blockAccess, 28, 29, 21, 4, 7, getBlockTexture, 154, RenderBlocksMod.this.branch("north"), 4, 54, RenderBlocksMod.this.northFace, RenderBlocksMod.this.label("north"), 43, 42, blockAccess, 28, 29, 21, 4, 8, getBlockTexture, 154, RenderBlocksMod.this.branch("south"), 4, 54, RenderBlocksMod.this.southFace, RenderBlocksMod.this.label("south"));
                }
            }.targetMethod(renderStandardBlockWithAmbientOcclusion));
        }
    }

    private class BlockGrassMod
    extends ClassMod {
        private byte[] material;
        private String blockName;

        BlockGrassMod(String blockName, final int blockID, final int halfTextureID, final int fullTextureID) {
            this.blockName = blockName;
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(25, BinaryRegex.capture(BinaryRegex.any()), BytecodeMatcher.captureReference(178), 165, BinaryRegex.any(2), 25, BinaryRegex.backReference(1), BytecodeMatcher.captureReference(178), 166, BinaryRegex.any(2), 16, 68, 172, this.push(halfTextureID), 172);
                }

                public void afterMatch(ClassFile classFile, MethodInfo methodInfo) {
                    BlockGrassMod.access$002(BlockGrassMod.this, this.matcher.getCaptureGroup(1));
                }
            }.addXref(2, new FieldRef("Material", "snow", "LMaterial;")).addXref(3, new FieldRef("Material", "builtSnow", "LMaterial;")).setMethodName("getBlockTexture"));
            this.classSignatures.add(new FixedBytecodeSignature(16, 9, 161, BinaryRegex.any(2)));
            this.classSignatures.add(new FixedBytecodeSignature(BytecodeMatcher.captureReference(185)).addXref(1, new InterfaceMethodRef("IBlockAccess", "getBlockMaterial", "(III)LMaterial;")));
            final FieldRef array = new FieldRef(this.getDeobfClass(), BetterGrass.field_MATRIX, BetterGrass.fieldtype_MATRIX);
            this.patches.add(new AddFieldPatch(array, 9));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "initialize grassMatrix";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(177);
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    byte[] getArray = this.reference(178, array);
                    byte[] putArray = this.reference(179, array);
                    return this.buildCode(getArray, 1, 166, BlockGrassMod.this.branch("A"), 7, 5, this.reference(197, new ClassRef(BetterGrass.fieldtype_MATRIX)), 2, putArray, getArray, 3, 50, 4, 2, 79, getArray, 4, 50, 4, 4, 79, getArray, 5, 50, 3, 2, 79, getArray, 6, 50, 3, 4, 79, BlockGrassMod.this.label("A"), 177);
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "check surrounding blocks in getBlockTexture";
                }

                public String getMatchExpression() {
                    return this.buildExpression(25, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.capture(BinaryRegex.build(178, BinaryRegex.any(2))), 165, BinaryRegex.any(2), 25, BinaryRegex.backReference(1), BinaryRegex.capture(BinaryRegex.build(178, BinaryRegex.any(2))), 166, BinaryRegex.any(2), 16, 68, 172, this.push(halfTextureID), 172);
                }

                public byte[] getReplacementBytes() throws IOException {
                    byte[] snow = this.reference(178, new FieldRef("Material", "snow", "LMaterial;"));
                    byte[] builtSnow = this.reference(178, new FieldRef("Material", "builtSnow", "LMaterial;"));
                    byte[] getBlockID = this.reference(185, new InterfaceMethodRef("IBlockAccess", "a", "(III)I"));
                    byte[] matrix = this.reference(178, new FieldRef("BlockGrass", BetterGrass.field_MATRIX, BetterGrass.fieldtype_MATRIX));
                    return this.buildCode(132, 5, -2, 25, BlockGrassMod.this.material, snow, 165, BlockGrassMod.this.branch("A"), 25, BlockGrassMod.this.material, builtSnow, 165, BlockGrassMod.this.branch("A"), 25, 1, 21, 2, matrix, 21, 5, 50, 3, 46, 96, 21, 3, 4, 100, 21, 4, matrix, 21, 5, 50, 4, 46, 96, getBlockID, this.push(blockID), 159, BlockGrassMod.this.branch("B"), this.push(halfTextureID), 172, BlockGrassMod.this.label("B"), this.push(fullTextureID), 172, BlockGrassMod.this.label("A"), 25, 1, 21, 2, matrix, 21, 5, 50, 3, 46, 96, 21, 3, 21, 4, matrix, 21, 5, 50, 4, 46, 96, this.reference(185, new InterfaceMethodRef("IBlockAccess", "getBlockMaterial", "(III)LMaterial;")), 58, BlockGrassMod.this.material, 25, BlockGrassMod.this.material, snow, 165, BlockGrassMod.this.branch("C"), 25, BlockGrassMod.this.material, builtSnow, 165, BlockGrassMod.this.branch("C"), 16, 68, 172, BlockGrassMod.this.label("C"), 16, 66, 172);
                }
            });
        }

        public String getDeobfClass() {
            return "Block" + this.blockName;
        }

        static /* synthetic */ byte[] access$002(BlockGrassMod x0, byte[] x1) {
            x0.material = x1;
            return x1;
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBlockTexture", "(LIBlockAccess;IIII)I")));
        }
    }

    private class MaterialMod
    extends ClassMod {
        MaterialMod() {
            this.classSignatures.add(new FixedBytecodeSignature(BinaryRegex.begin(), 42, 4, 181, BinaryRegex.any(2), 42, 176, BinaryRegex.end()));
            this.classSignatures.add(new FixedBytecodeSignature(BinaryRegex.begin(), 3, 172, BinaryRegex.end()));
            this.classSignatures.add(new FixedBytecodeSignature(BinaryRegex.begin(), 4, 172, BinaryRegex.end()));
            this.classSignatures.add(new ConstSignature("CONFLICT @ ").negate(true));
            this.classSignatures.add(new ClassSignature(){

                public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
                    int count = 0;
                    int flags = 25;
                    String descriptor = "L" + this.getClassFile().getName() + ";";
                    for (Object o : this.getClassFile().getFields()) {
                        FieldInfo fieldInfo = (FieldInfo)o;
                        if ((fieldInfo.getAccessFlags() & flags) != flags || !fieldInfo.getDescriptor().equals(descriptor)) continue;
                        ++count;
                    }
                    return count > 10;
                }
            });
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, null, new FieldRef(this.getDeobfClass(), "ground", "LMaterial;")).accessFlag(8, true));
        }
    }
}

