/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher.mod;

import com.pclewis.mcpatcher.AddFieldPatch;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BaseMod;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import java.io.IOException;
import javassist.bytecode.BadBytecode;

public class BetterGlass
extends Mod {
    private static final MethodRef glEnable = new MethodRef("org.lwjgl.opengl.GL11", "glEnable", "(I)V");
    private static final MethodRef getRenderBlockPass = new MethodRef("Block", "getRenderBlockPass", "()I");

    public BetterGlass(MinecraftVersion minecraftVersion) {
        this.name = "Better Glass";
        this.author = "MCPatcher";
        this.description = "Enables partial transparency for glass blocks.";
        this.version = "1.0";
        this.defaultEnabled = false;
        this.classMods.add(new BlockMod());
        this.classMods.add(new BlockBreakableMod());
        this.classMods.add(new BlockGlassMod());
        this.classMods.add(new BlockPaneMod());
        this.classMods.add(new RenderBlocksMod());
        this.classMods.add(new WorldRendererMod());
        this.classMods.add(new EntityRendererMod());
        this.classMods.add(new RenderGlobalMod());
        this.classMods.add(new ItemRendererMod());
        this.classMods.add(new RenderItemMod());
    }

    private class RenderItemMod
    extends ClassMod {
        RenderItemMod() {
            MethodRef doRenderItem = new MethodRef(this.getDeobfClass(), "doRenderItem", "(LEntityItem;DDDFF)V");
            MethodRef drawItemIntoGui = new MethodRef(this.getDeobfClass(), "drawItemIntoGui", "(LFontRenderer;LRenderEngine;IIIII)V");
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new ConstSignature("/gui/items.png"));
            this.classSignatures.add(new ConstSignature("%blur%/misc/glint.png"));
            this.classSignatures.add(new ConstSignature("/misc/water.png").negate(true));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.anyReference(180), this.push(187L), this.reference(182, new MethodRef("java/util/Random", "setSeed", "(J)V")));
                }
            }.setMethod(doRenderItem));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(210.0f)), this.push(Float.valueOf(1.0f)), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(0.0f)), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glRotatef", "(FFFF)V")));
                }
            }.setMethod(drawItemIntoGui));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "enable alpha transparency for glass item entities";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/terrain.png"), BytecodeMatcher.anyReference(182));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("Block", "blocksList", "[LBlock;")), 25, 10, this.reference(180, new FieldRef("ItemStack", "itemID", "I")), 50, this.reference(182, getRenderBlockPass), 153, RenderItemMod.this.branch("A"), this.push(3042), this.reference(184, glEnable), RenderItemMod.this.label("A"));
                }
            }.targetMethod(doRenderItem));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "enable alpha transparency for glass blocks in gui";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push("/terrain.png"));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("Block", "blocksList", "[LBlock;")), 29, 50, this.reference(182, getRenderBlockPass), 153, RenderItemMod.this.branch("A"), this.push(3042), this.reference(184, glEnable), RenderItemMod.this.label("A"));
                }
            }.targetMethod(drawItemIntoGui));
        }
    }

    private class ItemRendererMod
    extends ClassMod {
        ItemRendererMod() {
            MethodRef renderItem = new MethodRef(this.getDeobfClass(), "renderItem", "(LEntityLiving;LItemStack;I)V");
            final FieldRef mc = new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;");
            final FieldRef renderEngine = new FieldRef("Minecraft", "renderEngine", "LRenderEngine;");
            final MethodRef getTexture = new MethodRef("RenderEngine", "getTexture", "(Ljava/lang/String;)I");
            final FieldRef itemID = new FieldRef("ItemStack", "itemID", "I");
            final MethodRef glBindTexture = new MethodRef("org.lwjgl.opengl.GL11", "glBindTexture", "(II)V");
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new ConstSignature("/gui/items.png"));
            this.classSignatures.add(new ConstSignature("%blur%/misc/glint.png"));
            this.classSignatures.add(new ConstSignature("/misc/water.png"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(3553), 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), this.push("/terrain.png"), BytecodeMatcher.captureReference(182), this.reference(184, glBindTexture));
                }
            }.setMethod(renderItem).addXref(1, mc).addXref(2, renderEngine).addXref(3, getTexture));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyReference(178), 44, BytecodeMatcher.captureReference(180), 50);
                }
            }.setMethod(renderItem).addXref(1, itemID));
            this.patches.add(new BytecodePatch.InsertBefore(){

                public String getDescription() {
                    return "enable alpha transparency for held items";
                }

                public String getMatchExpression() {
                    return this.buildExpression(this.push(3553), 42, this.reference(180, mc), this.reference(180, renderEngine), this.push("/terrain.png"), this.reference(182, getTexture), this.reference(184, glBindTexture));
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(this.reference(178, new FieldRef("Block", "blocksList", "[LBlock;")), 44, this.reference(180, itemID), 50, this.reference(182, getRenderBlockPass), 153, ItemRendererMod.this.branch("A"), this.push(3042), this.reference(184, glEnable), ItemRendererMod.this.label("A"));
                }
            });
        }
    }

    private class RenderGlobalMod
    extends ClassMod {
        RenderGlobalMod() {
            MethodRef sortAndRender = new MethodRef(this.getDeobfClass(), "sortAndRender", "(LEntityLiving;ID)I");
            MethodRef renderAllRenderLists = new MethodRef(this.getDeobfClass(), "renderAllRenderLists", "(ID)V");
            this.classSignatures.add(new ConstSignature("smoke"));
            this.classSignatures.add(new ConstSignature("/environment/clouds.png"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().equals("()V")) {
                        return null;
                    }
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("java/util/Arrays", "sort", "([Ljava/lang/Object;Ljava/util/Comparator;)V"))});
                }
            }.setMethod(sortAndRender));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, renderAllRenderLists));
        }
    }

    private class EntityRendererMod
    extends ClassMod {
        final MethodRef renderWorld = new MethodRef(this.getDeobfClass(), "renderWorld", "(FJ)V");
        final FieldRef loop = new FieldRef(this.getDeobfClass(), "betterGrassLoop", "I");

        EntityRendererMod() {
            final MethodRef glBlendFunc = new MethodRef("org.lwjgl.opengl.GL11", "glBlendFunc", "(II)V");
            final MethodRef glDisable = new MethodRef("org.lwjgl.opengl.GL11", "glDisable", "(I)V");
            MethodRef sortAndRender = new MethodRef("RenderGlobal", "sortAndRender", "(LEntityLiving;ID)I");
            MethodRef renderAllRenderLists = new MethodRef("RenderGlobal", "renderAllRenderLists", "(ID)V");
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new ConstSignature("/environment/snow.png"));
            this.classSignatures.add(new ConstSignature("ambient.weather.rain"));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push(770), this.push(771), this.reference(184, glBlendFunc));
                }
            }.setMethod(this.renderWorld));
            this.patches.add(new AddFieldPatch(this.loop));
            this.addRenderPassPatch(renderAllRenderLists);
            this.addRenderPassPatch(sortAndRender);
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "add new render pass";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(this.push(770), this.push(771), this.reference(184, glBlendFunc))), BinaryRegex.capture(BinaryRegex.build(BinaryRegex.any(0, 1000))), BinaryRegex.capture(BinaryRegex.build(42, 35, BytecodeMatcher.anyReference(182), this.push(2912), this.reference(184, glDisable))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 42, 4, this.reference(181, EntityRendererMod.this.loop), EntityRendererMod.this.label("A"), 42, this.reference(180, EntityRendererMod.this.loop), 6, 162, EntityRendererMod.this.branch("B"), this.getCaptureGroup(2), 42, 89, this.reference(180, EntityRendererMod.this.loop), 4, 96, this.reference(181, EntityRendererMod.this.loop), 167, EntityRendererMod.this.branch("A"), EntityRendererMod.this.label("B"), this.getCaptureGroup(3));
                }
            }.targetMethod(this.renderWorld));
        }

        private void addRenderPassPatch(final MethodRef method) {
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "render pass 1 -> i (" + method.getName() + ")";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(25, 5, BinaryRegex.any(0, 2))), 4, BinaryRegex.capture(BinaryRegex.build(35, 141, this.reference(182, method))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 42, this.reference(180, EntityRendererMod.this.loop), this.getCaptureGroup(2));
                }
            }.targetMethod(this.renderWorld));
        }
    }

    private class WorldRendererMod
    extends ClassMod {
        WorldRendererMod() {
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            final FieldRef skipRenderPass = new FieldRef(this.getDeobfClass(), "skipRenderPass", "[Z");
            this.classSignatures.add(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, BytecodeMatcher.captureReference(182), 54, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.any(0, 30), 21, BinaryRegex.backReference(2), 21, BinaryRegex.any(), 159, BinaryRegex.any(2), 4, 54, BinaryRegex.any());
                }
            }.setMethod(updateRenderer).addXref(1, getRenderBlockPass));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, skipRenderPass));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "increase render passes from 2 to 3 (init)";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(42, 5, 188, 4, this.reference(181, skipRenderPass));
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, 6, 188, 4, this.reference(181, skipRenderPass));
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "increase render passes from 2 to 3 (loop)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyILOAD), 5, BinaryRegex.capture(BinaryRegex.build(BinaryRegex.subset(new byte[]{-95, -94}, true), BinaryRegex.any(2))));
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.getCaptureGroup(1), 6, this.getCaptureGroup(2));
                }
            });
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "increase render passes from 2 to 3 (&&)";
                }

                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, skipRenderPass), 3, 51, 153, BinaryRegex.any(2), 42, this.reference(180, skipRenderPass), 4, 51, 153, BinaryRegex.any(2), 4, BinaryRegex.or(BinaryRegex.build(172), BinaryRegex.build(167, BinaryRegex.any(2))), 3, 172);
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(42, this.reference(180, skipRenderPass), 3, 51, 153, WorldRendererMod.this.branch("A"), 42, this.reference(180, skipRenderPass), 4, 51, 153, WorldRendererMod.this.branch("A"), 42, this.reference(180, skipRenderPass), 5, 51, 153, WorldRendererMod.this.branch("A"), 4, 172, WorldRendererMod.this.label("A"), 3, 172);
                }
            });
        }
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        RenderBlocksMod() {
            MethodRef renderBlockAsItem = new MethodRef(this.getDeobfClass(), "renderBlockAsItem", "(LBlock;IF)V");
            MethodRef getRenderType = new MethodRef("Block", "getRenderType", "()I");
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, BytecodeMatcher.captureReference(182), 54, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(2), 153, BinaryRegex.any(2), BinaryRegex.any(0, 20), 21, BinaryRegex.backReference(2), this.push(16), BinaryRegex.subset(new byte[]{-96, -97}, true), BinaryRegex.any(2));
                }
            }.setMethod(renderBlockAsItem).addXref(1, getRenderType));
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "renderBlockPane", "(LBlockPane;III)Z")));
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "enable culling on glass panes";
                }

                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(this.push(2884), this.reference(184, glEnable));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "renderBlockPane", "(LBlockPane;III)Z")));
        }
    }

    private class BlockPaneMod
    extends ClassMod {
        BlockPaneMod() {
            this.parentClass = "Block";
            this.prerequisiteClasses.add(this.parentClass);
            this.patches.add(new AddMethodPatch(new MethodRef(this.getDeobfClass(), "getRenderBlockPass", "()I")){

                public byte[] generateMethod() throws BadBytecode, IOException {
                    return this.buildCode(5, 172);
                }
            });
        }
    }

    private class BlockGlassMod
    extends ClassMod {
        BlockGlassMod() {
            this.parentClass = "BlockBreakable";
            this.prerequisiteClasses.add("Block");
            this.patches.add(new BytecodePatch(){

                public String getDescription() {
                    return "change glass block render pass";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().equals("()I")) {
                        return this.buildExpression(3);
                    }
                    return null;
                }

                public byte[] getReplacementBytes() throws IOException {
                    return this.buildCode(5);
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "getRenderBlockPass", "()I")));
        }
    }

    private class BlockBreakableMod
    extends ClassMod {
        BlockBreakableMod() {
            this.parentClass = "Block";
            this.prerequisiteClasses.add("BlockGlass");
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            this.addBlockSignature("BlockGlass");
            this.addBlockSignature("BlockPane");
        }
    }
}

