/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MinecraftVersion {
    public static final int ALPHA = 1;
    public static final int BETA = 2;
    public static final int RC = 3;
    public static final int FINAL = 4;
    private static final int NOT_PRERELEASE = 9999;
    private static final Pattern LONG_PATTERN = Pattern.compile("Minecraft\\s+(Alpha|Beta|RC)?\\s*v?([0-9][-_.0-9a-zA-Z]*)\\s*((?:Pre\\S*|Beta)\\s*(\\d+)?)?", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("^(alpha-|beta-|rc)?([0-9][-_.0-9a-zA-Z]*)(pre(\\d+))?$", 2);
    private String versionNumberOnly;
    private String versionString;
    private String profileString;
    private int[] parsedVersion;
    private int preRelease;
    private boolean weeklyBuild;
    static final HashMap<String, String> knownMD5s = new HashMap();
    private static final ArrayList<MinecraftVersion> versionOrdering = new ArrayList();

    private static void addKnownVersion(String versionString, String md5) {
        try {
            MinecraftVersion version = MinecraftVersion.parseShortVersion(versionString);
            if (version == null) {
                throw new IllegalArgumentException("bad known version " + version);
            }
            if (md5 != null && !md5.matches("\\p{XDigit}{32}")) {
                throw new IllegalArgumentException("bad md5 sum for known version " + version);
            }
            versionOrdering.add(version);
            knownMD5s.put(versionString, md5);
        }
        catch (Throwable e) {
            Logger.log(e);
        }
    }

    private static int findClosestKnownVersion(MinecraftVersion version) {
        Integer partialResult;
        int i;
        for (i = 0; i < versionOrdering.size() && ((partialResult = version.comparePartial(versionOrdering.get(i))) == null || partialResult > 0); ++i) {
        }
        return i;
    }

    public static MinecraftVersion parseVersion(String versionString) {
        Matcher matcher = LONG_PATTERN.matcher(versionString);
        if (matcher.find()) {
            return new MinecraftVersion(matcher);
        }
        return null;
    }

    public static MinecraftVersion parseShortVersion(String versionString) {
        Matcher matcher = SHORT_PATTERN.matcher(versionString);
        if (matcher.find()) {
            return new MinecraftVersion(matcher);
        }
        return null;
    }

    private MinecraftVersion(Matcher matcher) {
        Matcher m;
        String[] elements = new String[]{"", "", "", ""};
        for (int i = 0; i < elements.length; ++i) {
            String value;
            if (i >= matcher.groupCount() || (value = matcher.group(i + 1)) == null) continue;
            elements[i] = value;
        }
        elements[0] = elements[0].toLowerCase();
        if (elements[2].equals("") && (m = Pattern.compile("(.*)(pre)(\\d*)").matcher(elements[1])).matches()) {
            elements[1] = m.group(1);
            elements[2] = m.group(2);
            elements[3] = m.group(3);
        }
        this.versionNumberOnly = elements[1];
        String[] tokens = this.versionNumberOnly.split("[^0-9a-zA-Z]+");
        this.parsedVersion = new int[tokens.length + 1];
        this.parsedVersion[0] = elements[0].startsWith("alpha") ? 1 : (elements[0].startsWith("beta") ? 2 : (elements[0].startsWith("rc") ? 3 : 4));
        for (int i = 0; i < tokens.length; ++i) {
            try {
                this.parsedVersion[i + 1] = Integer.parseInt(tokens[i]);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (elements[2] == null || elements[2].equals("")) {
            this.preRelease = 9999;
        } else if (elements[3] == null || elements[3].equals("")) {
            this.preRelease = 1;
        } else {
            try {
                this.preRelease = Integer.parseInt(elements[3]);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this.preRelease = 1;
            }
        }
        if (this.preRelease != 9999) {
            this.versionNumberOnly = this.versionNumberOnly + "pre" + this.preRelease;
        }
        switch (this.parsedVersion[0]) {
            case 1: {
                this.profileString = "Alpha ";
                break;
            }
            case 2: {
                this.profileString = "Beta ";
                break;
            }
            case 3: {
                this.profileString = "RC";
                break;
            }
            default: {
                this.profileString = "";
            }
        }
        this.profileString = this.profileString + this.versionNumberOnly;
        this.versionString = MinecraftVersion.profileStringToVersionString(this.profileString);
        if (this.parsedVersion[0] == 3) {
            this.versionNumberOnly = this.versionString;
        }
        if (this.parsedVersion[0] == 4 && this.versionNumberOnly.length() > 1 && !this.versionNumberOnly.contains(".")) {
            this.weeklyBuild = true;
            Pattern p = Pattern.compile("^(\\d+)w(\\d+)(.)$");
            Matcher m2 = p.matcher(this.versionNumberOnly);
            if (m2.matches()) {
                int a = Integer.parseInt(m2.group(1));
                int b = Integer.parseInt(m2.group(2));
                int c = m2.group(3).charAt(0) & 0xFF;
                this.parsedVersion = new int[]{4, 1, 0, 0, a, b, c};
            } else {
                this.parsedVersion = new int[]{4, 1, 0, 0, 1};
            }
        }
    }

    public int getReleaseType() {
        return this.parsedVersion[0];
    }

    public boolean isPrerelease() {
        return this.preRelease != 9999 || this.parsedVersion[0] == 3 || this.weeklyBuild;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getProfileString() {
        return this.profileString;
    }

    String getOldVersionString() {
        return this.versionNumberOnly;
    }

    static String profileStringToVersionString(String profileString) {
        return profileString.replaceFirst("^Alpha ", "alpha-").replaceFirst("^Beta ", "beta-").replaceFirst("^RC", "rc");
    }

    static String versionStringToProfileString(String versionString) {
        return versionString.replaceFirst("^alpha-", "Alpha ").replaceFirst("^beta-", "Beta ").replaceFirst("^rc", "RC");
    }

    public String toString() {
        return this.getVersionString();
    }

    private Integer comparePartial(MinecraftVersion that) {
        int i;
        if (this.weeklyBuild != that.weeklyBuild) {
            return null;
        }
        int[] a = this.parsedVersion;
        int[] b = that.parsedVersion;
        for (i = 0; i < a.length && i < b.length; ++i) {
            if (a[i] == b[i]) continue;
            return a[i] - b[i];
        }
        if (i < a.length) {
            return a[i];
        }
        if (i < b.length) {
            return -b[i];
        }
        return this.preRelease - that.preRelease;
    }

    public int compareTo(MinecraftVersion that) {
        int j;
        Integer partialResult = this.comparePartial(that);
        if (partialResult != null) {
            return partialResult;
        }
        int i = MinecraftVersion.findClosestKnownVersion(this);
        if (i != (j = MinecraftVersion.findClosestKnownVersion(that))) {
            return i - j;
        }
        return this.getVersionString().compareTo(that.getVersionString());
    }

    public int compareTo(String versionString) {
        if (!versionString.startsWith("Minecraft")) {
            versionString = "Minecraft " + versionString;
        }
        return this.compareTo(MinecraftVersion.parseVersion(versionString));
    }

    boolean isNewerThanAnyKnownVersion() {
        if (versionOrdering.isEmpty()) {
            return true;
        }
        MinecraftVersion highestVersion = versionOrdering.get(versionOrdering.size() - 1);
        return this.compareTo(highestVersion) > 0;
    }

    static boolean isKnownMD5(String md5) {
        return md5 != null && knownMD5s.containsValue(md5);
    }

    static {
        try {
            MinecraftVersion.addKnownVersion("beta-1.6.6", "ce80072464433cd5b05d505aa8ff29d1");
            MinecraftVersion.addKnownVersion("beta-1.7.3", "eae3353fdaa7e10a59b4cb5b45bfa10d");
            MinecraftVersion.addKnownVersion("beta-1.8pre1", "7ce3238b148bb67a3b84cf59b7516f55");
            MinecraftVersion.addKnownVersion("beta-1.8pre2", "bff1cf2e4586012ac8907b8e7945d4c3");
            MinecraftVersion.addKnownVersion("beta-1.8.1", "f8c5a2ccd3bc996792bbe436d8cc08bc");
            MinecraftVersion.addKnownVersion("beta-1.9pre1", "b4d9681a1118949d7753e19c35c61ec7");
            MinecraftVersion.addKnownVersion("beta-1.9pre2", "962d79abeca031b44cf8dac8d4fcabe9");
            MinecraftVersion.addKnownVersion("beta-1.9pre3", "334827dbe9183af6d650b39321a99e21");
            MinecraftVersion.addKnownVersion("beta-1.9pre4", "cae41f3746d3c4c440b2d63a403770e7");
            MinecraftVersion.addKnownVersion("beta-1.9pre5", "6258c4f293b939117efe640eda76dca4");
            MinecraftVersion.addKnownVersion("beta-1.9pre6", "2468205154374afe5f9caaba2ffbf5f8");
            MinecraftVersion.addKnownVersion("rc1", "22d708f84dc44fba200c2a5e4261959c");
            MinecraftVersion.addKnownVersion("rc2pre1", "e8e264bcff34aecbc7ef7f850858c1d6");
            MinecraftVersion.addKnownVersion("rc2", "bd569d20dd3dd898ff4371af9bbe14e1");
            MinecraftVersion.addKnownVersion("1.0.0", "3820d222b95d0b8c520d9596a756a6e6");
            MinecraftVersion.addKnownVersion("11w47a", "2ad75c809570663ec561ca707983a45b");
            MinecraftVersion.addKnownVersion("11w48a", "cd86517284d62a0854234ae12abd019c");
            MinecraftVersion.addKnownVersion("11w49a", "a1f7969b6b546c492fecabfcb8e8525a");
            MinecraftVersion.addKnownVersion("11w50a", "8763eb2747d57e2958295bbd06e764b1");
            MinecraftVersion.addKnownVersion("12w01a", "468f1b4022eb81d5ca2f316e24a7ffe5");
            MinecraftVersion.addKnownVersion("1.1", "e92302d2acdba7c97e0d8df1e10d2006");
            MinecraftVersion.addKnownVersion("12w03a", "ea85d9c4058ba9e47d8130bd1bff8be9");
            MinecraftVersion.addKnownVersion("12w04a", "c2e2d8c38288ac122001f2ed11c4d83a");
            MinecraftVersion.addKnownVersion("12w05a", "feabb7967bd528a9f3309a2d660d555d");
            MinecraftVersion.addKnownVersion("12w05b", "70affb4ae7da7e8b24f1bbbcbe58cf0f");
            MinecraftVersion.addKnownVersion("12w06a", "9cfaa4adec02642574ffb7c23a084d74");
            MinecraftVersion.addKnownVersion("12w07a", "d60621a26a64f3bda2849c32da6765c6");
            MinecraftVersion.addKnownVersion("12w07b", "88a9a9055d0d1d17b1c797e280508d83");
            MinecraftVersion.addKnownVersion("12w08a", "1d04d6b190a2ad14d8996802b9286bef");
            MinecraftVersion.addKnownVersion("1.2", "ee18a8cc1db8d15350bceb6ee71292f4");
            MinecraftVersion.addKnownVersion("1.2.2", "6189e96efaea11e5164b4a4755574324");
            MinecraftVersion.addKnownVersion("1.2.3", "12f6c4b1bdcc63f029e3c088a364b8e4");
            MinecraftVersion.addKnownVersion("1.2.4", "25423eab6d8707f96cc6ad8a21a7250a");
            MinecraftVersion.addKnownVersion("1.2.5", "8e8778078a175a33603a585257f28563");
            MinecraftVersion.addKnownVersion("12w15a", "90626a5c36f87aadbc7e79da1f076e93");
            MinecraftVersion.addKnownVersion("12w16a", "19ec24b0987e93da972147d1788c5227");
            MinecraftVersion.addKnownVersion("12w17a", "fc5826a699541df023762c6b8516e20e");
            MinecraftVersion.addKnownVersion("12w18a", "63bdc3586a192ddd13e7a8c08e864ec4");
            MinecraftVersion.addKnownVersion("12w19a", "113b505ad24b11a6cf801bd3516e7cc3");
            MinecraftVersion.addKnownVersion("12w21a", "51ea290e859130e14077758b545e8e91");
            MinecraftVersion.addKnownVersion("12w21b", "57b7376824b6635ea36b7591dd4da3ef");
            MinecraftVersion.addKnownVersion("12w22a", "fed0bfb2b0de4596c81dd698f73bdf4b");
            MinecraftVersion.addKnownVersion("12w23a", "42a509057902760abc3abd7227d028fc");
            MinecraftVersion.addKnownVersion("12w23b", "5798c9af6844333ee82fc9b11c6c47ea");
            MinecraftVersion.addKnownVersion("12w24a", "ac908492cdfe6c1d81183d2d2d7959a1");
            MinecraftVersion.addKnownVersion("12w25a", "b904c9d0d976039047e421a66a1a912d");
            MinecraftVersion.addKnownVersion("12w26a", "c3b849226a93a5aeffcabed61720cf45");
            MinecraftVersion.addKnownVersion("12w27a", "a3412d58aa1e5bcb6472fcf1c7e72ac1");
            MinecraftVersion.addKnownVersion("12w30a", "07dbdc7266019ab1d42c61f42b809f4d");
            MinecraftVersion.addKnownVersion("12w30b", "287bc65621e66a0d2287ff4eb424e90a");
            MinecraftVersion.addKnownVersion("12w30c", "1a1fb1f68354ca0a71fc723f36b97a81");
            MinecraftVersion.addKnownVersion("12w30d", "f2b0315ce33a3b473a523f5fa151a06d");
            MinecraftVersion.addKnownVersion("12w30e", "d466309bafbdece16b0a74a4290dbee1");
            MinecraftVersion.addKnownVersion("1.3", "a6effac1eaccf5d429aae340cf95ed5d");
            MinecraftVersion.addKnownVersion("1.3.1", "266ccbc9798afd2eadf3d6c01b4c562a");
            MinecraftVersion.addKnownVersion("1.3.2", "969699f13e5bbe7f12e40ac4f32b7d9a");
            MinecraftVersion.addKnownVersion("1.3.9999", null);
            MinecraftVersion.addKnownVersion("12w32a", "0de5595692a736307e96e3fec050a98e");
            for (int i = 0; i < versionOrdering.size(); ++i) {
                MinecraftVersion a = versionOrdering.get(i);
                for (int j = 0; j < versionOrdering.size(); ++j) {
                    MinecraftVersion b = versionOrdering.get(j);
                    Integer result = a.comparePartial(b);
                    if (i == j) {
                        if (result != null && result == 0) continue;
                        throw new RuntimeException("incorrect ordering in known version table: " + a.getVersionString() + " != " + b.getVersionString());
                    }
                    if (i > j) {
                        if (result == null || result > 0) continue;
                        throw new RuntimeException("incorrect ordering in known version table: " + a.getVersionString() + " <= " + b.getVersionString());
                    }
                    if (result == null || result < 0) continue;
                    throw new RuntimeException("incorrect ordering in known version table: " + a.getVersionString() + " >= " + b.getVersionString());
                }
            }
        }
        catch (Throwable e) {
            Logger.log(e);
        }
    }
}

