/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Config;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;

class MinecraftJar {
    private File origFile;
    private File outputFile;
    private Info info;
    private JarFile origJar;
    private JarOutputStream outputJar;

    public MinecraftJar(File file) throws IOException {
        this.info = new Info(file);
        if (!this.info.isOk()) {
            throw this.info.exception;
        }
        if (file.getName().equals("minecraft.jar")) {
            this.origFile = new File(file.getParent(), "minecraft-" + this.info.version.getVersionString() + ".jar");
            this.outputFile = file;
            Info origInfo = new Info(this.origFile);
            if (origInfo.result == 3 && this.info.result == 5) {
                Logger.log(0, "copying unmodded %s over %s", this.outputFile.getName(), this.origFile.getName());
                this.origFile.delete();
            }
            if (!this.origFile.exists()) {
                this.createBackup();
            } else if (origInfo.isOk()) {
                this.info = origInfo;
            }
        } else {
            this.origFile = file;
            this.outputFile = new File(file.getParent(), "minecraft.jar");
        }
    }

    protected void finalize() throws Throwable {
        this.closeStreams();
        super.finalize();
    }

    public MinecraftVersion getVersion() {
        return this.info.version;
    }

    public boolean isModded() {
        return this.info.result == 3;
    }

    public void logVersion() {
        Logger.log(0, "Minecraft version is %s (md5 %s)", this.info.version, this.info.md5);
        if (this.info.origMD5 == null) {
            Logger.log(0, "WARNING: could not determine original md5 sum", new Object[0]);
        } else if (this.info.result == 3) {
            Logger.log(0, "WARNING: possibly modded minecraft.jar (orig md5 %s)", this.info.origMD5);
        }
    }

    static void fixJarNames() {
        File binDir = MCPatcherUtils.getMinecraftPath("bin");
        for (String filename : binDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches("^minecraft-(rc)?[0-9][-_.0-9a-zA-Z]*(pre\\d+)?\\.jar$");
            }
        })) {
            try {
                File oldFile = new File(binDir, filename);
                MinecraftVersion version = Info.extractVersion(oldFile);
                if (version == null) continue;
                String oldVersion = version.getOldVersionString();
                String newVersion = version.getVersionString();
                File newFile = new File(binDir, "minecraft-" + newVersion + ".jar");
                boolean renameProfile = false;
                if (!newFile.exists()) {
                    Logger.log(0, "Renaming %s to %s", oldFile.getName(), newFile.getName());
                    oldFile.renameTo(newFile);
                    renameProfile = true;
                } else if (oldVersion.startsWith("rc")) {
                    renameProfile = true;
                }
                if (!renameProfile) continue;
                Config config = MCPatcherUtils.config;
                String oldProfile = "Minecraft " + oldVersion;
                String newProfile = "Minecraft " + version.getProfileString();
                config.renameProfile(oldProfile, newProfile);
                File oldModDir = MCPatcherUtils.getMinecraftPath("mods", oldVersion);
                File newModDir = MCPatcherUtils.getMinecraftPath("mods", newVersion);
                if (!oldModDir.isDirectory() || newModDir.exists()) continue;
                oldModDir.renameTo(newModDir);
                config.rewriteModPaths(oldModDir, newModDir);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    static boolean isGarbageFile(String filename) {
        return filename.startsWith("META-INF") || filename.startsWith("__MACOSX") || filename.endsWith(".DS_Store") || filename.equals("mod.properties");
    }

    static boolean isClassFile(String filename) {
        return filename.endsWith(".class") && !MinecraftJar.isGarbageFile(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultTexturePack() {
        File output;
        File input;
        block10: {
            input = MCPatcherUtils.getMinecraftPath("options.txt");
            if (!input.exists()) {
                return;
            }
            output = MCPatcherUtils.getMinecraftPath("options.txt.tmp");
            BufferedReader br = null;
            PrintWriter pw = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(input));
                pw = new PrintWriter(new FileWriter(output));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("skin:")) {
                        line = "skin:Default";
                    }
                    pw.println(line);
                }
                MCPatcherUtils.close(br);
            }
            catch (IOException e) {
                Logger.log(e);
                break block10;
            }
            finally {
                MCPatcherUtils.close(br);
                MCPatcherUtils.close(pw);
            }
            MCPatcherUtils.close(pw);
        }
        try {
            Util.copyFile(output, input);
            output.delete();
        }
        catch (IOException e) {
            Logger.log(e);
        }
    }

    public void createBackup() throws IOException {
        this.closeStreams();
        if (this.outputFile.exists() && !this.origFile.exists()) {
            Util.copyFile(this.outputFile, this.origFile);
        }
    }

    public void restoreBackup() throws IOException {
        this.closeStreams();
        if (this.origFile.exists()) {
            Util.copyFile(this.origFile, this.outputFile);
        }
    }

    public void setOutputFile(File file) {
        this.outputFile = file;
        this.closeStreams();
    }

    public JarFile getInputJar() throws IOException {
        if (this.origJar == null) {
            this.origJar = new JarFile(this.origFile, false);
        }
        return this.origJar;
    }

    public JarOutputStream getOutputJar() throws IOException {
        if (this.outputJar == null) {
            this.outputJar = new JarOutputStream(new FileOutputStream(this.outputFile));
        }
        return this.outputJar;
    }

    public File getInputFile() {
        return this.origFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkOutput() throws Exception {
        this.closeStreams();
        JarFile jar = null;
        try {
            jar = new JarFile(this.outputFile);
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(jar);
            throw throwable;
        }
        MCPatcherUtils.close(jar);
    }

    public void closeStreams() {
        MCPatcherUtils.close(this.origJar);
        MCPatcherUtils.close(this.outputJar);
        this.origJar = null;
        this.outputJar = null;
    }

    public void run() {
        File file = this.getOutputFile();
        File directory = file.getParentFile();
        StringBuilder cp = new StringBuilder();
        for (String string : new String[]{file.getName(), "lwjgl.jar", "lwjgl_util.jar", "jinput.jar"}) {
            cp.append(directory.getPath());
            cp.append("/");
            cp.append(string);
            cp.append(File.pathSeparatorChar);
        }
        int heapSize = MCPatcherUtils.getInt("javaHeapSize", 1024);
        ProcessBuilder pb = new ProcessBuilder("java", "-cp", cp.toString(), "-Djava.library.path=" + new File(directory, "natives").getPath(), "-Xmx" + heapSize + "M", "-Xms" + Math.min(heapSize, 512) + "M", "net.minecraft.client.Minecraft");
        pb.redirectErrorStream(true);
        pb.directory(MCPatcherUtils.getMinecraftPath(new String[0]));
        Logger.log(0);
        Logger.log(0, "Launching %s", file.getPath());
        StringBuilder sb = new StringBuilder();
        for (String s : pb.command()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (s.contains(" ")) {
                sb.append('\"');
                sb.append(s);
                sb.append('\"');
                continue;
            }
            sb.append(s);
        }
        Logger.log(0, "%s", sb.toString());
        try {
            Process process = pb.start();
            if (process != null) {
                String line;
                BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = input.readLine()) != null) {
                    MCPatcher.checkInterrupt();
                    Logger.log(0, "%s", line);
                }
                process.waitFor();
                if (process.exitValue() != 0) {
                    Logger.log(0, "Minecraft exited with status %d", process.exitValue());
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            Logger.log(iOException);
        }
    }

    private static class Info {
        static final int MISSING_JAR = 0;
        static final int IO_ERROR = 1;
        static final int CORRUPT_JAR = 2;
        static final int MODDED_JAR = 3;
        static final int MODDED_OR_UNMODDED_JAR = 4;
        static final int UNMODDED_JAR = 5;
        MinecraftVersion version;
        String md5;
        String origMD5;
        int result;
        IOException exception;

        Info(File minecraftJar) {
            this.result = this.initialize(minecraftJar);
            if (!this.isOk() && this.exception == null) {
                this.exception = new IOException("unexpected error opening " + minecraftJar.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int initialize(File minecraftJar) {
            int n;
            JarFile jar;
            block17: {
                boolean haveMetaInf;
                block18: {
                    if (!minecraftJar.exists()) {
                        this.exception = new FileNotFoundException(minecraftJar.getPath() + " does not exist");
                        return 0;
                    }
                    this.md5 = Util.computeMD5(minecraftJar);
                    if (this.md5 == null) {
                        this.exception = new IOException("could not open " + minecraftJar.getPath());
                        return 1;
                    }
                    haveMetaInf = false;
                    jar = null;
                    try {
                        HashSet<String> entries = new HashSet<String>();
                        jar = new JarFile(minecraftJar);
                        for (JarEntry entry : Collections.list(jar.entries())) {
                            String name = entry.getName();
                            if (entries.contains(name)) {
                                this.exception = new ZipException("duplicate zip entry " + name);
                                n = 2;
                                break block17;
                            }
                            if (name.startsWith("META-INF")) {
                                haveMetaInf = true;
                            }
                            entries.add(name);
                        }
                        this.version = Info.extractVersion(jar, this.md5);
                    }
                    catch (ZipException e) {
                        this.exception = e;
                        int n2 = 2;
                        {
                            catch (Throwable throwable) {
                                MCPatcherUtils.close(jar);
                                throw throwable;
                            }
                        }
                        MCPatcherUtils.close(jar);
                        return n2;
                        catch (IOException e2) {
                            this.exception = e2;
                            int n3 = 1;
                            MCPatcherUtils.close(jar);
                            return n3;
                        }
                    }
                    MCPatcherUtils.close(jar);
                    if (this.version != null) break block18;
                    this.exception = new JarException("Could not determine version of " + minecraftJar.getPath());
                    return 2;
                }
                this.origMD5 = Info.getOrigMD5(minecraftJar.getParentFile(), this.version);
                if (!haveMetaInf) {
                    return 3;
                }
                if (this.origMD5 == null) {
                    return 4;
                }
                if (MinecraftVersion.isKnownMD5(this.md5)) {
                    return 5;
                }
                if (this.version.isNewerThanAnyKnownVersion()) {
                    return 4;
                }
                if (this.origMD5.equals(this.md5)) {
                    return 5;
                }
                return 3;
            }
            MCPatcherUtils.close(jar);
            return n;
        }

        static MinecraftVersion extractVersion(File file) {
            return Info.extractVersion(file, Util.computeMD5(file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static MinecraftVersion extractVersion(File file, String md5) {
            MinecraftVersion minecraftVersion;
            if (!file.exists()) {
                return null;
            }
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                minecraftVersion = Info.extractVersion(jar, md5);
            }
            catch (Exception e) {
                try {
                    Logger.log(e);
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(jar);
                    throw throwable;
                }
                MCPatcherUtils.close(jar);
                return null;
            }
            MCPatcherUtils.close(jar);
            return minecraftVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MinecraftVersion extractVersion(JarFile jar, String md5) {
            MinecraftVersion version = null;
            InputStream inputStream = null;
            try {
                ZipEntry entry = jar.getEntry("net/minecraft/client/Minecraft.class");
                if (entry == null) {
                    MinecraftVersion minecraftVersion = null;
                    return minecraftVersion;
                }
                inputStream = jar.getInputStream(entry);
                ClassFile classFile = new ClassFile(new DataInputStream(inputStream));
                ConstPool constPool = classFile.getConstPool();
                for (int i = 1; i < constPool.getSize(); ++i) {
                    String value;
                    if (constPool.getTag(i) != 8 || (version = MinecraftVersion.parseVersion(value = constPool.getStringInfo(i))) == null) continue;
                    if (version.getVersionString().equals("rc1") && md5.equals("e8e264bcff34aecbc7ef7f850858c1d6")) {
                        version = MinecraftVersion.parseVersion("Minecraft RC2 Prerelease 1");
                        break;
                    }
                    if (!version.getVersionString().equals("11w49a") || !md5.equals("8763eb2747d57e2958295bbd06e764b1")) break;
                    version = MinecraftVersion.parseVersion("Minecraft 11w50a");
                    break;
                }
                MCPatcherUtils.close(inputStream);
            }
            catch (IOException e) {
                Logger.log(e);
            }
            finally {
                MCPatcherUtils.close(inputStream);
            }
            return version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getOrigMD5(File binDir, MinecraftVersion version) {
            String md5 = MinecraftVersion.knownMD5s.get(version.getVersionString());
            if (md5 != null) {
                return md5;
            }
            File md5File = new File(binDir, "md5s");
            if (!version.isPrerelease() && md5File.exists()) {
                FileInputStream inputStream = null;
                try {
                    Properties properties = new Properties();
                    inputStream = new FileInputStream(md5File);
                    properties.load(inputStream);
                    String string = properties.getProperty("minecraft.jar");
                    MCPatcherUtils.close(inputStream);
                    return string;
                }
                catch (IOException e) {
                    Logger.log(e);
                }
                finally {
                    MCPatcherUtils.close(inputStream);
                }
            }
            return null;
        }

        boolean isOk() {
            return this.result > 2;
        }
    }
}

