/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Config;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MainForm;
import com.pclewis.mcpatcher.MinecraftVersion;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

class MainMenu {
    private MainForm mainForm;
    JMenuBar menuBar;
    JMenu file;
    JMenuItem origFile;
    JMenuItem outputFile;
    JMenuItem exit;
    JMenu mods;
    JMenuItem addMod;
    JMenuItem removeMod;
    JMenuItem moveUp;
    JMenuItem moveDown;
    JMenuItem save;
    JMenuItem load;
    JMenuItem delete;
    JMenu game;
    JMenuItem patch;
    JMenuItem unpatch;
    JMenuItem test;

    MainMenu(MainForm mainForm1) {
        this.mainForm = mainForm1;
        this.menuBar = new JMenuBar();
        this.file = new JMenu("File");
        this.file.setMnemonic('F');
        this.menuBar.add(this.file);
        this.origFile = new JMenuItem("Select input file...");
        MainMenu.copyActionListener(this.origFile, this.mainForm.origBrowseButton);
        this.file.add(this.origFile);
        this.outputFile = new JMenuItem("Select output file...");
        MainMenu.copyActionListener(this.outputFile, this.mainForm.outputBrowseButton);
        this.file.add(this.outputFile);
        this.file.addSeparator();
        this.exit = new JMenuItem("Exit");
        this.exit.setMnemonic('x');
        this.exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(((MainMenu)MainMenu.this).mainForm.frame, 201));
            }
        });
        this.file.add(this.exit);
        this.mods = new JMenu("Mods");
        this.mods.setMnemonic('M');
        this.menuBar.add(this.mods);
        this.addMod = new JMenuItem("Add...");
        MainMenu.copyActionListener(this.addMod, this.mainForm.addButton);
        this.mods.add(this.addMod);
        this.removeMod = new JMenuItem("Remove");
        MainMenu.copyActionListener(this.removeMod, this.mainForm.removeButton);
        this.mods.add(this.removeMod);
        this.mods.addSeparator();
        this.moveUp = new JMenuItem("Move up");
        MainMenu.copyActionListener(this.moveUp, this.mainForm.upButton);
        this.mods.add(this.moveUp);
        this.moveDown = new JMenuItem("Move down");
        MainMenu.copyActionListener(this.moveDown, this.mainForm.downButton);
        this.mods.add(this.moveDown);
        this.mods.addSeparator();
        this.save = new JMenuItem("Save profile...");
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String profileName;
                int i = 0;
                while (true) {
                    profileName = "Custom Profile";
                    if (i > 0) {
                        profileName = profileName + " " + i;
                    }
                    if (MCPatcherUtils.config.findProfileByName(profileName, false) == null) break;
                    ++i;
                }
                Object result = JOptionPane.showInputDialog(((MainMenu)MainMenu.this).mainForm.frame, "Enter a name for this profile:", "Profile name", 3, null, null, profileName);
                if (result != null && result instanceof String && !result.equals("")) {
                    profileName = (String)result;
                    String currentProfile = MCPatcherUtils.config.getConfigValue("selectedProfile");
                    if (profileName.equals(currentProfile)) {
                        return;
                    }
                    if (MCPatcherUtils.config.findProfileByName(profileName, false) != null) {
                        int confirm = JOptionPane.showConfirmDialog(((MainMenu)MainMenu.this).mainForm.frame, String.format("Profile \"%s\" exists.  Overwrite?", profileName), "Confirm overwrite", 0);
                        if (confirm != 0) {
                            return;
                        }
                        MCPatcherUtils.config.deleteProfile(profileName);
                    }
                    MCPatcher.modList.updateProperties();
                    MCPatcherUtils.config.selectProfile(profileName);
                    MainMenu.this.mainForm.updateControls();
                }
            }
        });
        this.mods.add(this.save);
        this.load = new JMenu("Select profile");
        this.mods.add(this.load);
        this.delete = new JMenu("Delete profile");
        this.mods.add(this.delete);
        this.game = new JMenu("Game");
        this.game.setMnemonic('G');
        this.menuBar.add(this.game);
        this.patch = new JMenuItem("Patch");
        MainMenu.copyActionListener(this.patch, this.mainForm.patchButton);
        this.game.add(this.patch);
        this.unpatch = new JMenuItem("Unpatch");
        MainMenu.copyActionListener(this.unpatch, this.mainForm.undoButton);
        this.game.add(this.unpatch);
        this.game.addSeparator();
        this.test = new JMenuItem("Test Minecraft");
        MainMenu.copyActionListener(this.test, this.mainForm.testButton);
        this.game.add(this.test);
        this.updateControls(true);
    }

    private static void copyActionListener(JMenuItem item, final JButton button) {
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    for (ActionListener listener : button.getActionListeners()) {
                        listener.actionPerformed(e);
                    }
                }
            }
        });
    }

    void updateControls(boolean busy) {
        JMenuItem item;
        this.file.setEnabled(!busy);
        this.mods.setEnabled(!busy);
        this.game.setEnabled(!busy);
        this.origFile.setEnabled(this.mainForm.origBrowseButton.isEnabled());
        this.outputFile.setEnabled(this.mainForm.outputBrowseButton.isEnabled());
        this.addMod.setEnabled(this.mainForm.addButton.isEnabled());
        this.removeMod.setEnabled(this.mainForm.removeButton.isEnabled());
        this.moveUp.setEnabled(this.mainForm.upButton.isEnabled());
        this.moveDown.setEnabled(this.mainForm.downButton.isEnabled());
        this.patch.setEnabled(this.mainForm.patchButton.isEnabled());
        this.unpatch.setEnabled(this.mainForm.undoButton.isEnabled());
        this.test.setEnabled(this.mainForm.testButton.isEnabled());
        this.load.removeAll();
        this.delete.removeAll();
        if (!busy && MCPatcherUtils.config != null) {
            ArrayList<String> profiles = MCPatcherUtils.config.getProfiles();
            Collections.sort(profiles, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    MinecraftVersion v1 = null;
                    MinecraftVersion v2 = null;
                    if (Config.isDefaultProfile(o1)) {
                        v1 = MinecraftVersion.parseVersion(o1);
                    }
                    if (Config.isDefaultProfile(o2)) {
                        v2 = MinecraftVersion.parseVersion(o2);
                    }
                    if (v1 == null && v2 == null) {
                        return o1.compareTo(o2);
                    }
                    if (v1 == null) {
                        return 1;
                    }
                    if (v2 == null) {
                        return -1;
                    }
                    return v1.compareTo(v2);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            final String currentProfile = MCPatcherUtils.config.getConfigValue("selectedProfile");
            for (final String profile : profiles) {
                JRadioButtonMenuItem item2 = new JRadioButtonMenuItem(profile, profile.equals(currentProfile));
                item2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        File jar;
                        String version;
                        if (profile.equals(currentProfile)) {
                            return;
                        }
                        MCPatcher.modList.updateProperties();
                        MCPatcherUtils.config.selectProfile(profile);
                        boolean modsOk = false;
                        if (Config.isDefaultProfile(profile) && !(version = profile.replaceFirst("^Minecraft\\s+", "")).equals(MCPatcher.minecraft.getVersion().getProfileString()) && (jar = MCPatcherUtils.getMinecraftPath("bin", "minecraft-" + MinecraftVersion.profileStringToVersionString(version) + ".jar")).exists()) {
                            try {
                                modsOk = MCPatcher.setMinecraft(jar, false);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                        if (!modsOk) {
                            MCPatcher.getAllMods();
                        }
                        MainMenu.this.mainForm.updateModList();
                    }
                });
                buttonGroup.add(item2);
                this.load.add(item2);
                JMenuItem item1 = new JMenuItem(profile);
                item1.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (profile.equals(currentProfile)) {
                            return;
                        }
                        int result = JOptionPane.showConfirmDialog(((MainMenu)MainMenu.this).mainForm.frame, String.format("Delete saved profile \"%s\"?", profile), "Confirm profile delete", 0);
                        if (result == 0) {
                            MCPatcherUtils.config.deleteProfile(profile);
                            MainMenu.this.mainForm.updateControls();
                        }
                    }
                });
                item1.setEnabled(!profile.equals(currentProfile));
                this.delete.add(item1);
            }
        }
        if (this.load.getSubElements().length == 0) {
            item = new JMenuItem("(none)");
            item.setEnabled(false);
            this.load.add(item);
        } else {
            this.load.setEnabled(true);
        }
        if (this.delete.getSubElements().length == 0) {
            item = new JMenuItem("(none)");
            item.setEnabled(false);
            this.delete.add(item);
        } else {
            this.delete.setEnabled(true);
        }
    }
}

