/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.Config;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;

public class MCPatcherUtils {
    private static File minecraftDir = null;
    private static boolean debug = false;
    private static boolean isGame;
    static Config config;
    private static Minecraft minecraft;
    private static String minecraftVersion;
    private static String patcherVersion;
    public static final String HD_TEXTURES = "HD Textures";
    public static final String HD_FONT = "HD Font";
    public static final String BETTER_GRASS = "Better Grass";
    public static final String RANDOM_MOBS = "Random Mobs";
    public static final String CUSTOM_COLORS = "Custom Colors";
    public static final String CONNECTED_TEXTURES = "Connected Textures";
    public static final String BETTER_SKIES = "Better Skies";
    public static final String BETTER_GLASS = "Better Glass";
    public static final String GLSL_SHADERS = "GLSL Shaders";
    public static final String UTILS_CLASS = "com.pclewis.mcpatcher.MCPatcherUtils";
    public static final String CONFIG_CLASS = "com.pclewis.mcpatcher.Config";
    public static final String GL11_CLASS = "org.lwjgl.opengl.GL11";
    public static final String TILE_SIZE_CLASS = "com.pclewis.mcpatcher.mod.TileSize";
    public static final String TEXTURE_UTILS_CLASS = "com.pclewis.mcpatcher.mod.TextureUtils";
    public static final String CUSTOM_ANIMATION_CLASS = "com.pclewis.mcpatcher.mod.CustomAnimation";
    public static final String FONT_UTILS_CLASS = "com.pclewis.mcpatcher.mod.FontUtils";
    public static final String RANDOM_MOBS_CLASS = "com.pclewis.mcpatcher.mod.MobRandomizer";
    public static final String MOB_OVERLAY_CLASS = "com.pclewis.mcpatcher.mod.MobOverlay";
    public static final String COLORIZER_CLASS = "com.pclewis.mcpatcher.mod.Colorizer";
    public static final String COLOR_MAP_CLASS = "com.pclewis.mcpatcher.mod.ColorMap";
    public static final String BIOME_HELPER_CLASS = "com.pclewis.mcpatcher.mod.BiomeHelper";
    public static final String CTM_UTILS_CLASS = "com.pclewis.mcpatcher.mod.CTMUtils";
    public static final String SUPER_TESSELLATOR_CLASS = "com.pclewis.mcpatcher.mod.SuperTessellator";
    public static final String TILE_OVERRIDE_CLASS = "com.pclewis.mcpatcher.mod.TileOverride";
    public static final String SKY_RENDERER_CLASS = "com.pclewis.mcpatcher.mod.SkyRenderer";
    public static final String SHADERS_CLASS = "com.pclewis.mcpatcher.mod.Shaders";

    private MCPatcherUtils() {
    }

    static File getDefaultGameDir() {
        String os = System.getProperty("os.name").toLowerCase();
        String baseDir = null;
        String subDir = ".minecraft";
        if (os.contains("win")) {
            baseDir = System.getenv("APPDATA");
        } else if (os.contains("mac")) {
            subDir = "Library/Application Support/minecraft";
        }
        if (baseDir == null) {
            baseDir = System.getProperty("user.home");
        }
        return new File(baseDir, subDir);
    }

    static boolean setGameDir(File dir) {
        minecraftDir = dir != null && dir.isDirectory() && new File(dir, "bin/lwjgl.jar").exists() && new File(dir, "resources").isDirectory() ? dir.getAbsoluteFile() : null;
        return MCPatcherUtils.loadProperties();
    }

    private static boolean loadProperties() {
        config = null;
        if (minecraftDir != null && minecraftDir.exists()) {
            try {
                config = new Config(minecraftDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            debug = MCPatcherUtils.getBoolean("debug", false);
            return true;
        }
        return false;
    }

    public static File getMinecraftPath(String ... subdirs) {
        File f = minecraftDir;
        for (String s : subdirs) {
            f = new File(f, s);
        }
        return f;
    }

    public static void log(String format, Object ... params) {
        MCPatcherUtils.debug(format, params);
    }

    public static boolean isGame() {
        return isGame;
    }

    public static void warn(String format, Object ... params) {
        System.out.printf("WARNING: " + format + "\n", params);
    }

    public static void error(String format, Object ... params) {
        System.out.printf("ERROR: " + format + "\n", params);
    }

    public static void info(String format, Object ... params) {
        System.out.printf(format + "\n", params);
    }

    public static void debug(String format, Object ... params) {
        if (debug) {
            System.out.printf(format + "\n", params);
        }
    }

    public static String getString(String mod, String tag, Object defaultValue) {
        if (config == null) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        String value = config.getModConfigValue(mod, tag);
        if (value == null && defaultValue != null) {
            value = defaultValue.toString();
            config.setModConfigValue(mod, tag, value);
        }
        return value;
    }

    public static String getString(String tag, Object defaultValue) {
        if (config == null) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        String value = config.getConfigValue(tag);
        if (value == null && defaultValue != null) {
            value = defaultValue.toString();
            config.setConfigValue(tag, value);
        }
        return value;
    }

    public static int getInt(String mod, String tag, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(MCPatcherUtils.getString(mod, tag, defaultValue));
        }
        catch (NumberFormatException e) {
            value = defaultValue;
        }
        return value;
    }

    public static int getInt(String tag, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(MCPatcherUtils.getString(tag, defaultValue));
        }
        catch (NumberFormatException e) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(String mod, String tag, boolean defaultValue) {
        String value = MCPatcherUtils.getString(mod, tag, defaultValue).toLowerCase();
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        return defaultValue;
    }

    public static boolean getBoolean(String tag, boolean defaultValue) {
        String value = MCPatcherUtils.getString(tag, defaultValue).toLowerCase();
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        return defaultValue;
    }

    public static void set(String mod, String tag, Object value) {
        if (config != null) {
            config.setModConfigValue(mod, tag, value.toString());
        }
    }

    static void set(String tag, Object value) {
        if (config != null) {
            config.setConfigValue(tag, value.toString());
        }
    }

    public static void remove(String mod, String tag) {
        if (config != null) {
            config.remove(config.getModConfig(mod, tag));
        }
    }

    static void remove(String tag) {
        if (config != null) {
            config.remove(config.getConfig(tag));
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setMinecraft(Minecraft minecraft) {
        MCPatcherUtils.minecraft = minecraft;
    }

    public static void setVersions(String minecraftVersion, String patcherVersion) {
        MCPatcherUtils.minecraftVersion = minecraftVersion;
        MCPatcherUtils.patcherVersion = patcherVersion;
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    public static String getMinecraftVersion() {
        return minecraftVersion;
    }

    public static String getPatcherVersion() {
        return patcherVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(InputStream input) {
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    public static Properties readProperties(InputStream input) {
        Properties properties = new Properties();
        if (MCPatcherUtils.readProperties(input, properties)) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readProperties(InputStream input, Properties properties) {
        if (input != null && properties != null) {
            try {
                properties.load(input);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }

    public static int[] getImageRGB(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rgb = new int[width * height];
        image.getRGB(0, 0, width, height, rgb, 0, width);
        return rgb;
    }

    public static int[] parseIntegerList(String list, int minValue, int maxValue) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        for (String token : list.replace(',', ' ').split("\\s+")) {
            token = token.trim();
            try {
                if (token.matches("^\\d+$")) {
                    tmpList.add(Integer.parseInt(token));
                    continue;
                }
                if (!token.matches("^\\d+-\\d+$")) continue;
                String[] t = token.split("-");
                int min = Integer.parseInt(t[0]);
                int max = Integer.parseInt(t[1]);
                for (int i = min; i <= max; ++i) {
                    tmpList.add(i);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (minValue <= maxValue) {
            int i = 0;
            while (i < tmpList.size()) {
                if ((Integer)tmpList.get(i) < minValue || (Integer)tmpList.get(i) > maxValue) {
                    tmpList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        int[] a = new int[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Integer)tmpList.get(i);
        }
        return a;
    }

    static {
        config = null;
        isGame = true;
        try {
            if (Class.forName("com.pclewis.mcpatcher.MCPatcher") != null) {
                isGame = false;
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (isGame) {
            if (MCPatcherUtils.setGameDir(new File(".")) || MCPatcherUtils.setGameDir(MCPatcherUtils.getDefaultGameDir())) {
                System.out.println("MCPatcherUtils initialized. Directory " + minecraftDir.getPath());
            } else {
                System.out.println("MCPatcherUtils initialized. Current directory " + new File(".").getAbsolutePath());
            }
        }
    }
}

