/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstPoolUtils;
import com.pclewis.mcpatcher.JavaRef;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BytecodeSignature
extends ClassSignature {
    MethodRef deobfMethod;
    protected BytecodeMatcher matcher;
    HashMap<Integer, JavaRef> xrefs = new HashMap();

    public abstract String getMatchExpression();

    boolean match() {
        this.matcher = new BytecodeMatcher(this.getMatchExpression());
        return this.matcher.match(this.getMethodInfo());
    }

    void initMatcher() {
        this.matcher = new BytecodeMatcher(this.getMatchExpression());
    }

    @Override
    void setClassMod(ClassMod classMod) {
        super.setClassMod(classMod);
        if (this.deobfMethod != null && this.deobfMethod.getClassName() == null) {
            this.deobfMethod = new MethodRef(classMod.getDeobfClass(), this.deobfMethod.getName(), this.deobfMethod.getType());
        }
    }

    private boolean isPotentialTypeMatch(ArrayList<String> deobfTypes, ArrayList<String> obfTypes) {
        if (deobfTypes.size() != obfTypes.size()) {
            return false;
        }
        for (int i = 0; i < deobfTypes.size(); ++i) {
            String deobfType = deobfTypes.get(i);
            String obfType = obfTypes.get(i);
            String deobfClass = deobfType.replaceFirst("^\\[+", "");
            String obfClass = obfType.replaceFirst("^\\[+", "");
            if (deobfType.length() - deobfClass.length() != obfType.length() - obfClass.length()) {
                return false;
            }
            if (deobfClass.charAt(0) == 'L' && obfClass.charAt(0) == 'L') {
                String deobfMapping;
                boolean obfIsMC;
                deobfClass = ClassMap.descriptorToClassName(deobfClass);
                obfClass = ClassMap.descriptorToClassName(obfClass);
                boolean deobfIsMC = !deobfClass.contains(".") || deobfClass.startsWith("net.minecraft.");
                boolean bl = obfIsMC = !obfClass.matches(".*[^a-z].*") || obfClass.startsWith("net.minecraft.");
                if (deobfIsMC != obfIsMC) {
                    return false;
                }
                if (!(deobfIsMC ? this.classMod.getClassMap().hasMap(deobfClass) && !(deobfMapping = this.classMod.getClassMap().map(deobfClass).replace('/', '.')).equals(obfClass) : !deobfClass.equals(obfClass))) continue;
                return false;
            }
            if (deobfClass.equals(obfClass)) continue;
            return false;
        }
        return true;
    }

    private boolean isPotentialTypeMatch(String deobfDesc, String obfDesc) {
        return deobfDesc == null && obfDesc == null || this.isPotentialTypeMatch(ConstPoolUtils.parseDescriptor(deobfDesc), ConstPoolUtils.parseDescriptor(obfDesc));
    }

    @Override
    public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
        for (Object o : classFile.getMethods()) {
            MethodInfo methodInfo;
            this.classMod.methodInfo = methodInfo = (MethodInfo)o;
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute == null) continue;
            if (this.getClassMap().hasMap((JavaRef)this.deobfMethod)) {
                MethodRef obfTarget = (MethodRef)this.getClassMap().map((JavaRef)this.deobfMethod);
                if (!methodInfo.getName().equals(obfTarget.getName())) continue;
            }
            ArrayList<String> deobfTypes = null;
            ArrayList<String> obfTypes = null;
            if (this.deobfMethod != null && this.deobfMethod.getType() != null && !this.isPotentialTypeMatch(deobfTypes = ConstPoolUtils.parseDescriptor(this.deobfMethod.getType()), obfTypes = ConstPoolUtils.parseDescriptor(methodInfo.getDescriptor()))) continue;
            ConstPool constPool = methodInfo.getConstPool();
            CodeIterator codeIterator = codeAttribute.iterator();
            this.initMatcher();
            ArrayList<JavaRef> tempMappings = new ArrayList<JavaRef>();
            try {
                int offset = 0;
                while (offset < codeIterator.getCodeLength() && this.matcher.match(methodInfo, offset)) {
                    block11: {
                        tempMappings.clear();
                        for (Map.Entry<Integer, JavaRef> entry : this.xrefs.entrySet()) {
                            int captureGroup = entry.getKey();
                            JavaRef xref = entry.getValue();
                            byte[] code = this.matcher.getCaptureGroup(captureGroup);
                            int index = Util.demarshal(code, 1, 2);
                            ConstPoolUtils.matchOpcodeToRefType(code[0], xref);
                            ConstPoolUtils.matchConstPoolTagToRefType(constPool.getTag(index), xref);
                            JavaRef newRef = ConstPoolUtils.getRefForIndex(constPool, index);
                            if (this.isPotentialTypeMatch(xref.getType(), newRef.getType())) {
                                tempMappings.add(xref);
                                tempMappings.add(newRef);
                                continue;
                            }
                            break block11;
                        }
                        int i = 0;
                        while (i + 1 < tempMappings.size()) {
                            tempClassMap.addMap((JavaRef)tempMappings.get(i), (JavaRef)tempMappings.get(i + 1));
                            i += 2;
                        }
                        if (this.deobfMethod != null) {
                            String deobfName = this.classMod.getDeobfClass();
                            tempClassMap.addClassMap(deobfName, ClassMap.filenameToClassName(filename));
                            tempClassMap.addMethodMap(deobfName, this.deobfMethod.getName(), methodInfo.getName(), methodInfo.getDescriptor());
                            if (deobfTypes != null && obfTypes != null) {
                                for (int i2 = 0; i2 < deobfTypes.size(); ++i2) {
                                    String desc = ClassMap.descriptorToClassName(deobfTypes.get(i2));
                                    String obf = ClassMap.descriptorToClassName(obfTypes.get(i2));
                                    if (obf.equals(desc)) continue;
                                    tempClassMap.addClassMap(desc, obf);
                                }
                            }
                        }
                        this.afterMatch(classFile, methodInfo);
                        this.classMod.methodInfo = null;
                        return true;
                    }
                    offset = codeIterator.next();
                }
            }
            catch (BadBytecode e) {
                Logger.log(e);
            }
        }
        this.classMod.methodInfo = null;
        return false;
    }

    public BytecodeSignature setMethodName(String methodName) {
        return this.setMethod(new MethodRef(null, methodName, null));
    }

    public BytecodeSignature setMethod(MethodRef methodRef) {
        this.deobfMethod = methodRef;
        return this;
    }

    public BytecodeSignature addXref(int captureGroup, JavaRef javaRef) {
        this.xrefs.put(captureGroup, javaRef);
        return this;
    }

    public void afterMatch(ClassFile classFile, MethodInfo methodInfo) {
    }
}

