/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.pclewis.mcpatcher.AddMethodPatch;
import com.pclewis.mcpatcher.BinaryRegex;
import com.pclewis.mcpatcher.BytecodeMatcher;
import com.pclewis.mcpatcher.BytecodePatch;
import com.pclewis.mcpatcher.BytecodeSignature;
import com.pclewis.mcpatcher.ClassMap;
import com.pclewis.mcpatcher.ClassMod;
import com.pclewis.mcpatcher.ClassRef;
import com.pclewis.mcpatcher.ClassSignature;
import com.pclewis.mcpatcher.ConstSignature;
import com.pclewis.mcpatcher.FieldRef;
import com.pclewis.mcpatcher.FilenameSignature;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MakeMemberPublicPatch;
import com.pclewis.mcpatcher.MethodRef;
import com.pclewis.mcpatcher.MinecraftVersion;
import com.pclewis.mcpatcher.Mod;
import com.pclewis.mcpatcher.ModConfigPanel;
import com.pclewis.mcpatcher.OrSignature;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class BaseMod
extends Mod {
    BaseMod(MinecraftVersion minecraftVersion) {
        this.name = "__Base";
        this.author = "MCPatcher";
        this.description = "Internal mod required by the patcher.";
        this.version = "1.0";
        this.configPanel = new ConfigPanel();
        this.classMods.add(new XMinecraftMod());
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.MCPatcherUtils"));
        this.filesToAdd.add(ClassMap.classNameToFilename("com.pclewis.mcpatcher.Config"));
    }

    public static class GameSettingsMod
    extends ClassMod {
        public GameSettingsMod() {
            this.classSignatures.add(new ConstSignature("key.forward"));
        }

        protected void mapOption(final String option, String field, String descriptor) {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(45, 3, 50, this.push(option), this.reference(182, new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z")), 153, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 20)), BytecodeMatcher.captureReference(181));
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), field, descriptor)));
        }
    }

    public static class RenderBlocksMod
    extends ClassMod {
        public RenderBlocksMod() {
            this.classSignatures.add(new ConstSignature(0.1875));
            this.classSignatures.add(new ConstSignature(0.01));
        }
    }

    public static class FontRendererMod
    extends ClassMod {
        public FontRendererMod() {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isConstructor()) {
                        return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.anyReference(183), 42, this.push(256), 188, 10, BytecodeMatcher.captureReference(181), 42, 3, BytecodeMatcher.captureReference(181));
                    }
                    return null;
                }
            }.addXref(1, new FieldRef(this.getDeobfClass(), "charWidth", "[I")).addXref(2, new FieldRef(this.getDeobfClass(), "fontTextureName", "I")));
            this.classSignatures.add(new OrSignature(new ConstSignature("0123456789abcdef"), new ConstSignature("0123456789abcdefk"), new ConstSignature("/font/glyph_sizes.bin")));
        }
    }

    public static class WorldServerMPMod
    extends ClassMod {
        public WorldServerMPMod(MinecraftVersion minecraftVersion) {
            this.parentClass = "World";
            this.classSignatures.add(new ConstSignature("MpServer"));
        }
    }

    public static class WorldServerMod
    extends ClassMod {
        public WorldServerMod(MinecraftVersion minecraftVersion) {
            FieldRef world = new FieldRef(this.getDeobfClass(), "world", "LWorld;");
            this.classSignatures.add(new ConstSignature("/particles.png"));
            this.classSignatures.add(new ConstSignature("/terrain.png"));
            this.classSignatures.add(new ConstSignature("/gui/items.png"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, world));
            this.patches.add(new MakeMemberPublicPatch(world));
        }
    }

    public static class WorldMod
    extends ClassMod {
        public WorldMod() {
            this.classSignatures.add(new ConstSignature("ambient.cave.cave"));
            this.classSignatures.add(new ConstSignature(1013904223));
        }
    }

    public static class ItemMod
    extends ClassMod {
        public ItemMod() {
            this.classSignatures.add(new ConstSignature("CONFLICT @ "));
            this.classSignatures.add(new ConstSignature("coal"));
        }
    }

    public static class BlockMod
    extends ClassMod {
        private static final ArrayList<BlockSubclassEntry> subclasses = new ArrayList<BlockSubclassEntry>(){
            {
                this.add(new BlockSubclassEntry(1, "BlockStone", "stone", "Block", "stone"));
                this.add(new BlockSubclassEntry(2, "BlockGrass", "grass", "BlockGrass", "grass"));
                this.add(new BlockSubclassEntry(3, "BlockDirt", "dirt", "Block", "dirt"));
                this.add(new BlockSubclassEntry(4, "Block", "stonebrick", "Block", "cobblestone"));
                this.add(new BlockSubclassEntry(5, "Block", "wood", "Block", "planks"));
                this.add(new BlockSubclassEntry(6, "BlockSapling", "sapling", "Block", "sapling"));
                this.add(new BlockSubclassEntry(7, "Block", "bedrock", "Block", "bedrock"));
                this.add(new BlockSubclassEntry(8, "BlockFlowing", "water", "Block", "waterMoving"));
                this.add(new BlockSubclassEntry(9, "BlockStationary", "water", "Block", "waterStill"));
                this.add(new BlockSubclassEntry(10, "BlockFlowing", "lava", "Block", "lavaMoving"));
                this.add(new BlockSubclassEntry(11, "BlockStationary", "lava", "Block", "lavaStill"));
                this.add(new BlockSubclassEntry(12, "BlockSand", "sand", "Block", "sand"));
                this.add(new BlockSubclassEntry(13, "BlockGravel", "gravel", "Block", "gravel"));
                this.add(new BlockSubclassEntry(14, "BlockOre", "oreGold", "Block", "oreGold"));
                this.add(new BlockSubclassEntry(15, "BlockOre", "oreIron", "Block", "oreIron"));
                this.add(new BlockSubclassEntry(16, "BlockOre", "oreCoal", "Block", "oreCoal"));
                this.add(new BlockSubclassEntry(17, "BlockLog", "log", "Block", "wood"));
                this.add(new BlockSubclassEntry(18, "BlockLeaves", "leaves", "BlockLeaves", "leaves"));
                this.add(new BlockSubclassEntry(19, "BlockSponge", "sponge", "Block", "sponge"));
                this.add(new BlockSubclassEntry(20, "BlockGlass", "glass", "Block", "glass"));
                this.add(new BlockSubclassEntry(21, "BlockOre", "oreLapis", "Block", "oreLapis"));
                this.add(new BlockSubclassEntry(22, "Block", "blockLapis", "Block", "blockLapis"));
                this.add(new BlockSubclassEntry(23, "BlockDispenser", "dispenser", "Block", "dispenser"));
                this.add(new BlockSubclassEntry(24, "BlockSandStone", "sandStone", "Block", "sandStone"));
                this.add(new BlockSubclassEntry(25, "BlockNote", "musicBlock", "Block", "music"));
                this.add(new BlockSubclassEntry(26, "BlockBed", "bed", "Block", "bed"));
                this.add(new BlockSubclassEntry(27, "BlockRail", "goldenRail", "Block", "railPowered"));
                this.add(new BlockSubclassEntry(28, "BlockDetectorRail", "detectorRail", "Block", "railDetector"));
                this.add(new BlockSubclassEntry(29, "BlockPistonBase", "pistonStickyBase", "Block", "pistonStickyBase"));
                this.add(new BlockSubclassEntry(30, "BlockWeb", "web", "Block", "web"));
                this.add(new BlockSubclassEntry(31, "BlockTallGrass", "tallgrass", "BlockTallGrass", "tallGrass"));
                this.add(new BlockSubclassEntry(32, "BlockDeadBush", "deadbush", "BlockDeadBush", "deadBush"));
                this.add(new BlockSubclassEntry(33, "BlockPistonBase", "pistonBase", "Block", "pistonBase"));
                this.add(new BlockSubclassEntry(37, "BlockFlower", "flower", "BlockFlower", "plantYellow"));
                this.add(new BlockSubclassEntry(38, "BlockFlower", "rose", "BlockFlower", "plantRed"));
                this.add(new BlockSubclassEntry(39, "BlockMushroom", "mushroom", "BlockFlower", "mushroomBrown"));
                this.add(new BlockSubclassEntry(40, "BlockMushroom", "mushroom", "BlockFlower", "mushroomRed"));
                this.add(new BlockSubclassEntry(41, "BlockOreStorage", "blockGold", "Block", "blockGold"));
                this.add(new BlockSubclassEntry(42, "BlockOreStorage", "blockIron", "Block", "blockSteel"));
                this.add(new BlockSubclassEntry(43, "BlockStep", "stoneSlab", "Block", "stairDouble"));
                this.add(new BlockSubclassEntry(44, "BlockStep", "stoneSlab", "Block", "stairSingle"));
                this.add(new BlockSubclassEntry(45, "Block", "brick", "Block", "brick"));
                this.add(new BlockSubclassEntry(46, "BlockTNT", "tnt", "Block", "tnt"));
                this.add(new BlockSubclassEntry(47, "BlockBookshelf", "bookshelf", "Block", "bookShelf"));
                this.add(new BlockSubclassEntry(48, "Block", "stoneMoss", "Block", "cobblestoneMossy"));
                this.add(new BlockSubclassEntry(49, "BlockObsidian", "obsidian", "Block", "obsidian"));
                this.add(new BlockSubclassEntry(50, "BlockTorch", "torch", "Block", "torchWood"));
                this.add(new BlockSubclassEntry(51, "BlockFire", "fire", "BlockFire", "fire"));
                this.add(new BlockSubclassEntry(52, "BlockMobSpawner", "mobSpawner", "Block", "mobSpawner"));
                this.add(new BlockSubclassEntry(53, "BlockStairs", "stairsWood", "Block", "stairCompactPlanks"));
                this.add(new BlockSubclassEntry(54, "BlockChest", "chest", "Block", "chest"));
                this.add(new BlockSubclassEntry(55, "BlockRedstoneWire", "redstoneDust", "Block", "redstoneWire"));
                this.add(new BlockSubclassEntry(56, "BlockOre", "oreDiamond", "Block", "oreDiamond"));
                this.add(new BlockSubclassEntry(57, "BlockOreStorage", "blockDiamond", "Block", "blockDiamond"));
                this.add(new BlockSubclassEntry(58, "BlockWorkbench", "workbench", "Block", "workbench"));
                this.add(new BlockSubclassEntry(59, "BlockCrops", "crops", "Block", "crops"));
                this.add(new BlockSubclassEntry(60, "BlockFarmland", "farmland", "Block", "tilledField"));
                this.add(new BlockSubclassEntry(61, "BlockFurnace", "furnace", "Block", "stoneOvenIdle"));
                this.add(new BlockSubclassEntry(62, "BlockFurnace", "furnace", "Block", "stoneOvenActive"));
                this.add(new BlockSubclassEntry(63, "BlockSign", "sign", "Block", "signPost"));
                this.add(new BlockSubclassEntry(64, "BlockDoor", "doorWood", "Block", "doorWood"));
                this.add(new BlockSubclassEntry(65, "BlockLadder", "ladder", "Block", "ladder"));
                this.add(new BlockSubclassEntry(66, "BlockRail", "rail", "Block", "rail"));
                this.add(new BlockSubclassEntry(67, "BlockStairs", "stairsStone", "Block", "stairCompactCobblestone"));
                this.add(new BlockSubclassEntry(68, "BlockSign", "sign", "Block", "signWall"));
                this.add(new BlockSubclassEntry(69, "BlockLever", "lever", "Block", "lever"));
                this.add(new BlockSubclassEntry(70, "BlockPressurePlate", "pressurePlate", "Block", "pressurePlateStone"));
                this.add(new BlockSubclassEntry(71, "BlockDoor", "doorIron", "Block", "doorSteel"));
                this.add(new BlockSubclassEntry(72, "BlockPressurePlate", "pressurePlate", "Block", "pressurePlatePlanks"));
                this.add(new BlockSubclassEntry(73, "BlockRedstoneOre", "oreRedstone", "Block", "oreRedstone"));
                this.add(new BlockSubclassEntry(74, "BlockRedstoneOre", "oreRedstone", "Block", "oreRedstoneGlowing"));
                this.add(new BlockSubclassEntry(75, "BlockRedstoneTorch", "notGate", "Block", "torchRedstoneIdle"));
                this.add(new BlockSubclassEntry(76, "BlockRedstoneTorch", "notGate", "Block", "torchRedstoneActive"));
                this.add(new BlockSubclassEntry(77, "BlockButton", "button", "Block", "button"));
                this.add(new BlockSubclassEntry(78, "BlockSnow", "snow", "Block", "snow"));
                this.add(new BlockSubclassEntry(79, "BlockIce", "ice", "Block", "ice"));
                this.add(new BlockSubclassEntry(80, "BlockSnowBlock", "snow", "Block", "blockSnow"));
                this.add(new BlockSubclassEntry(81, "BlockCactus", "cactus", "Block", "cactus"));
                this.add(new BlockSubclassEntry(82, "BlockClay", "clay", "Block", "blockClay"));
                this.add(new BlockSubclassEntry(83, "BlockReed", "reeds", "Block", "reed"));
                this.add(new BlockSubclassEntry(84, "BlockJukeBox", "jukebox", "Block", "jukebox"));
                this.add(new BlockSubclassEntry(85, "BlockFence", "fence", "Block", "fence"));
                this.add(new BlockSubclassEntry(86, "BlockPumpkin", "pumpkin", "Block", "pumpkin"));
                this.add(new BlockSubclassEntry(87, "BlockNetherrack", "hellrock", "Block", "netherrack"));
                this.add(new BlockSubclassEntry(88, "BlockSoulSand", "hellsand", "Block", "slowSand"));
                this.add(new BlockSubclassEntry(89, "BlockGlowStone", "lightgem", "Block", "glowStone"));
                this.add(new BlockSubclassEntry(90, "BlockPortal", "portal", "BlockPortal", "portal"));
                this.add(new BlockSubclassEntry(91, "BlockPumpkin", "litpumpkin", "Block", "pumpkinLantern"));
                this.add(new BlockSubclassEntry(92, "BlockCake", "cake", "Block", "cake"));
                this.add(new BlockSubclassEntry(93, "BlockRedstoneRepeater", "diode", "Block", "redstoneRepeaterIdle"));
                this.add(new BlockSubclassEntry(94, "BlockRedstoneRepeater", "diode", "Block", "redstoneRepeaterActive"));
                this.add(new BlockSubclassEntry(95, "BlockLockedChest", "lockedchest", "Block", "lockedChest"));
                this.add(new BlockSubclassEntry(96, "BlockTrapDoor", "trapdoor", "Block", "trapdoor"));
                this.add(new BlockSubclassEntry(98, "BlockStoneBrick", "stonebricksmooth", "Block", "stoneBrick"));
                this.add(new BlockSubclassEntry(99, "BlockMushroomCap", "mushroom", "Block", "mushroomCapBrown"));
                this.add(new BlockSubclassEntry(100, "BlockMushroomCap", "mushroom", "Block", "mushroomCapRed"));
                this.add(new BlockSubclassEntry(101, "BlockPane", "fenceIron", "Block", "fenceIron"));
                this.add(new BlockSubclassEntry(102, "BlockPane", "thinGlass", "Block", "thinGlass"));
                this.add(new BlockSubclassEntry(103, "BlockMelon", "melon", "Block", "melon"));
                this.add(new BlockSubclassEntry(104, "BlockStem", "pumpkinStem", "Block", "pumpkinStem"));
                this.add(new BlockSubclassEntry(105, "BlockStem", "pumpkinStem", "Block", "melonStem"));
                this.add(new BlockSubclassEntry(106, "BlockVine", "vine", "Block", "vine"));
                this.add(new BlockSubclassEntry(107, "BlockFenceGate", "fenceGate", "Block", "fenceGate"));
                this.add(new BlockSubclassEntry(108, "BlockStairs", "stairsBrick", "Block", "stairsBrick"));
                this.add(new BlockSubclassEntry(109, "BlockStairs", "stairsStoneBrickSmooth", "Block", "stairsStoneBrickSmooth"));
                this.add(new BlockSubclassEntry(110, "BlockMycelium", "mycel", "BlockMycelium", "mycelium"));
                this.add(new BlockSubclassEntry(111, "BlockLilyPad", "waterlily", "Block", "waterlily"));
                this.add(new BlockSubclassEntry(112, "Block", "netherBrick", "Block", "netherBrick"));
                this.add(new BlockSubclassEntry(113, "BlockFence", "netherFence", "Block", "replaceID"));
                this.add(new BlockSubclassEntry(114, "BlockStairs", "stairsNetherBrick", "Block", "stairsNetherBrick"));
                this.add(new BlockSubclassEntry(115, "BlockNetherStalk", "netherStalk", "Block", "netherStalk"));
                this.add(new BlockSubclassEntry(116, "BlockEnchantmentTable", "enchantmentTable", "Block", "enchantmentTable"));
                this.add(new BlockSubclassEntry(117, "BlockBrewingStand", "brewingStand", "Block", "brewingStand"));
                this.add(new BlockSubclassEntry(118, "BlockCauldron", "cauldron", "Block", "cauldron"));
                this.add(new BlockSubclassEntry(120, "BlockEndPortalFrame", "endPortalFrame", "Block", "endPortalFrame"));
                this.add(new BlockSubclassEntry(121, "Block", "whiteStone", "Block", "whiteStone"));
                this.add(new BlockSubclassEntry(122, "BlockDragonEgg", "dragonEgg", "Block", "dragonEgg"));
            }
        };

        public BlockMod() {
            this.classSignatures.add(new ConstSignature(" is already occupied by "));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "blockID", "I")).accessFlag(1, true).accessFlag(8, false).accessFlag(16, true));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "blocksList", "[LBlock;")).accessFlag(1, true).accessFlag(8, true).accessFlag(16, true));
        }

        protected void addBlockSignatures() {
            for (BlockSubclassEntry entry : subclasses) {
                this.addBlockSignature(entry.blockID, entry.blockName, entry.className, entry.fieldName, entry.fieldClass);
            }
        }

        protected void addBlockSignature(String name) {
            for (BlockSubclassEntry entry : subclasses) {
                if (!entry.className.equals(name) && !entry.blockName.equals(name) && !entry.fieldName.equals(name)) continue;
                this.addBlockSignature(entry.blockID, entry.blockName, entry.className, entry.fieldName, entry.fieldClass);
                return;
            }
            throw new RuntimeException("unknown Block subclass: " + name);
        }

        protected void addBlockSignature(int blockID) {
            for (BlockSubclassEntry entry : subclasses) {
                if (entry.blockID != blockID) continue;
                this.addBlockSignature(entry.blockID, entry.blockName, entry.className, entry.fieldName, entry.fieldClass);
                return;
            }
            throw new RuntimeException("unknown Block subclass: block ID" + blockID);
        }

        protected void addBlockSignature(final int blockID, final String blockName, String className, String fieldName, String fieldClass) {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().isStaticInitializer()) {
                        return this.buildExpression(BytecodeMatcher.captureReference(187), 89, this.push(blockID), BinaryRegex.nonGreedy(BinaryRegex.any(0, 60)), this.push(blockName), BytecodeMatcher.anyReference(182), BinaryRegex.nonGreedy(BinaryRegex.any(0, 20)), BytecodeMatcher.captureReference(179));
                    }
                    return null;
                }
            }.addXref(1, new ClassRef(className)).addXref(2, new FieldRef(this.getDeobfClass(), fieldName, "L" + fieldClass + ";")));
        }

        private static class BlockSubclassEntry {
            int blockID;
            String className;
            String blockName;
            String fieldClass;
            String fieldName;

            BlockSubclassEntry(int blockID, String className, String blockName, String fieldClass, String fieldName) {
                this.blockID = blockID;
                this.className = className;
                this.blockName = blockName;
                this.fieldClass = fieldClass;
                this.fieldName = fieldName;
            }
        }
    }

    public static class IBlockAccessMod
    extends ClassMod {
        public IBlockAccessMod() {
            this.classSignatures.add(new ClassSignature(){

                public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
                    return classFile.isAbstract();
                }
            });
            this.classSignatures.add(new ClassSignature(){

                public boolean match(String filename, ClassFile classFile, ClassMap tempClassMap) {
                    List list = this.getClassFile().getMethods();
                    return list.size() >= 1 && ((MethodInfo)list.get(0)).getDescriptor().equals("(III)I");
                }
            });
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBlockId", "(III)I"), new MethodRef(this.getDeobfClass(), "getBlockMetadata", "(III)I")));
        }

        public IBlockAccessMod mapMaterial() {
            this.memberMappers.add(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBlockMaterial", "(III)LMaterial;")));
            return this;
        }
    }

    public static class TessellatorMod
    extends ClassMod {
        protected final MethodRef draw = new MethodRef(this.getDeobfClass(), "draw", "()I");
        protected final MethodRef startDrawingQuads = new MethodRef(this.getDeobfClass(), "startDrawingQuads", "()V");
        protected final MethodRef startDrawing = new MethodRef(this.getDeobfClass(), "startDrawing", "(I)V");
        protected final MethodRef addVertexWithUV = new MethodRef(this.getDeobfClass(), "addVertexWithUV", "(DDDDD)V");
        protected final MethodRef addVertex = new MethodRef(this.getDeobfClass(), "addVertex", "(DDD)V");
        protected final MethodRef setTextureUV = new MethodRef(this.getDeobfClass(), "setTextureUV", "(DD)V");
        protected final FieldRef instance = new FieldRef(this.getDeobfClass(), "instance", "LTessellator;");

        public TessellatorMod(MinecraftVersion minecraftVersion) {
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(this.push("Not tesselating!"));
                }
            }.setMethod(this.draw));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(7), BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(this.startDrawingQuads).addXref(1, this.startDrawing));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(42, 24, 7, 24, 9, BytecodeMatcher.captureReference(182), 42, 39, 41, 24, 5, BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(this.addVertexWithUV).addXref(1, this.setTextureUV).addXref(2, this.addVertex));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, this.instance).accessFlag(8, true));
        }
    }

    public static class GLAllocationMod
    extends ClassMod {
        public GLAllocationMod() {
            this.classSignatures.add(new ConstSignature(new MethodRef("org.lwjgl.opengl.GL11", "glDeleteLists", "(II)V")));
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().equals("(I)Ljava/nio/ByteBuffer;")) {
                        return this.buildExpression(new Object[]{this.reference(184, new MethodRef("java.nio.ByteBuffer", "allocateDirect", "(I)Ljava/nio/ByteBuffer;"))});
                    }
                    return null;
                }
            }.setMethodName("createDirectByteBuffer"));
        }
    }

    public static class TexturePackDefaultMod
    extends ClassMod {
        public TexturePackDefaultMod() {
            this.parentClass = "TexturePackBase";
            this.classSignatures.add(new ConstSignature("The default look of Minecraft"));
        }
    }

    public static class TexturePackBaseMod
    extends ClassMod {
        protected final boolean useITexturePack;

        public TexturePackBaseMod(MinecraftVersion minecraftVersion) {
            final MethodRef getResourceAsStream = new MethodRef("java.lang.Class", "getResourceAsStream", "(Ljava/lang/String;)Ljava/io/InputStream;");
            this.classSignatures.add(new ConstSignature(getResourceAsStream));
            if (minecraftVersion.compareTo("12w15a") >= 0) {
                this.useITexturePack = true;
                this.classSignatures.add(new ConstSignature("/pack.txt"));
                this.interfaces = new String[]{"ITexturePack"};
            } else {
                this.useITexturePack = false;
                this.classSignatures.add(new ConstSignature("pack.txt").negate(true));
            }
            this.classSignatures.add(new BytecodeSignature(){

                public String getMatchExpression() {
                    return this.buildExpression(43, this.reference(182, getResourceAsStream), 176);
                }
            }.setMethodName("getInputStream"));
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "texturePackFileName", "Ljava/lang/String;")));
            this.patches.add(new MakeMemberPublicPatch(new FieldRef(this.getDeobfClass(), "texturePackFileName", "Ljava/lang/String;")));
        }
    }

    public static class TexturePackListMod
    extends ClassMod {
        protected final boolean useITexturePack;
        protected final String texturePackType;
        protected final FieldRef selectedTexturePack;
        protected final FieldRef defaultTexturePack;
        protected final MethodRef getDefaultTexturePack = new MethodRef(this.getDeobfClass(), "getDefaultTexturePack", "()LTexturePackBase;");
        protected final MethodRef getSelectedTexturePack = new MethodRef(this.getDeobfClass(), "getSelectedTexturePack", "()LTexturePackBase;");

        public TexturePackListMod(MinecraftVersion minecraftVersion) {
            this.classSignatures.add(new ConstSignature(".zip"));
            this.classSignatures.add(new ConstSignature("texturepacks"));
            if (minecraftVersion.compareTo("12w15a") >= 0) {
                this.useITexturePack = true;
                this.texturePackType = "LITexturePack;";
                this.selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", this.texturePackType);
                this.defaultTexturePack = new FieldRef(this.getDeobfClass(), "defaultTexturePack", this.texturePackType);
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, this.selectedTexturePack).accessFlag(2, true).accessFlag(8, false).accessFlag(16, false));
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, this.defaultTexturePack).accessFlag(2, true).accessFlag(8, true).accessFlag(16, true));
                this.patches.add(new AddMethodPatch(this.getDefaultTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(this.reference(178, TexturePackListMod.this.defaultTexturePack), this.reference(192, new ClassRef("TexturePackBase")), 176);
                    }
                });
                this.patches.add(new AddMethodPatch(this.getSelectedTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, TexturePackListMod.this.selectedTexturePack), this.reference(192, new ClassRef("TexturePackBase")), 176);
                    }
                });
            } else {
                this.useITexturePack = false;
                this.texturePackType = "LTexturePackBase;";
                this.selectedTexturePack = new FieldRef(this.getDeobfClass(), "selectedTexturePack", this.texturePackType);
                this.defaultTexturePack = new FieldRef(this.getDeobfClass(), "defaultTexturePack", this.texturePackType);
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, this.selectedTexturePack).accessFlag(1, true));
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, this.defaultTexturePack).accessFlag(2, true));
                this.patches.add(new AddMethodPatch(this.getDefaultTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, TexturePackListMod.this.defaultTexturePack), 176);
                    }
                });
                this.patches.add(new AddMethodPatch(this.getSelectedTexturePack){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, TexturePackListMod.this.selectedTexturePack), 176);
                    }
                });
            }
        }
    }

    public static class MinecraftMod
    extends ClassMod {
        public MinecraftMod() {
            this.classSignatures.add(new FilenameSignature("net/minecraft/client/Minecraft.class"));
        }

        public MinecraftMod mapTexturePackList() {
            this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "texturePackList", "LTexturePackList;")));
            return this;
        }

        public MinecraftMod addWorldGetter(MinecraftVersion minecraftVersion) {
            MethodRef getWorld = new MethodRef(this.getDeobfClass(), "getWorld", "()LWorld;");
            if (minecraftVersion.compareTo("12w18a") >= 0) {
                final FieldRef worldServer = new FieldRef(this.getDeobfClass(), "worldServer", "LWorldServer;");
                final FieldRef world = new FieldRef("WorldServer", "world", "LWorld;");
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, worldServer));
                this.patches.add(new AddMethodPatch(getWorld){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, worldServer), this.reference(180, world), 176);
                    }
                });
            } else {
                final FieldRef theWorld = new FieldRef(this.getDeobfClass(), "theWorld", "LWorld;");
                this.memberMappers.add(new ClassMod.FieldMapper((ClassMod)this, theWorld));
                this.patches.add(new AddMethodPatch(getWorld){

                    public byte[] generateMethod() throws BadBytecode, IOException {
                        return this.buildCode(42, this.reference(180, theWorld), 176);
                    }
                });
            }
            return this;
        }
    }

    private class XMinecraftMod
    extends MinecraftMod {
        XMinecraftMod() {
            this.patches.add(new BytecodePatch.InsertAfter(){

                public String getDescription() {
                    return "MCPatcherUtils.setMinecraft(this)";
                }

                public String getMatchExpression() {
                    if (this.getMethodInfo().getName().equals("<init>")) {
                        return this.buildExpression(BinaryRegex.begin(), 42, this.reference(183, new MethodRef("java.lang.Object", "<init>", "()V")));
                    }
                    return null;
                }

                public byte[] getInsertBytes() throws IOException {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.pclewis.mcpatcher.MCPatcherUtils", "setMinecraft", "(LMinecraft;)V")), this.push(MCPatcher.minecraft.getVersion().getVersionString()), this.push(MCPatcher.VERSION_STRING), this.reference(184, new MethodRef("com.pclewis.mcpatcher.MCPatcherUtils", "setVersions", "(Ljava/lang/String;Ljava/lang/String;)V")));
                }
            });
        }

        public String getDeobfClass() {
            return "Minecraft";
        }
    }

    class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JTextField heapSizeText;
        private JCheckBox debugCheckBox;

        ConfigPanel() {
            this.$$$setupUI$$$();
            this.debugCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MCPatcherUtils.set("debug", ConfigPanel.this.debugCheckBox.isSelected());
                }
            });
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public String getPanelName() {
            return "General options";
        }

        public void load() {
            this.heapSizeText.setText("" + MCPatcherUtils.getInt("javaHeapSize", 1024));
            this.debugCheckBox.setSelected(MCPatcherUtils.getBoolean("debug", false));
        }

        public void save() {
            try {
                MCPatcherUtils.set("javaHeapSize", Integer.parseInt(this.heapSizeText.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Java heap size (MB)");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.heapSizeText = jTextField = new JTextField();
            jTextField.setColumns(5);
            jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.debugCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText("Extra debugging output during the game.");
            jCheckBox.setText("Game debug logging");
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

