/*
 * Decompiled with CFR 0.152.
 */
package com.pclewis.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.pclewis.mcpatcher.ExternalMod;
import com.pclewis.mcpatcher.Logger;
import com.pclewis.mcpatcher.MCPatcher;
import com.pclewis.mcpatcher.MCPatcherUtils;
import com.pclewis.mcpatcher.MainForm;
import com.pclewis.mcpatcher.MinecraftJar;
import com.pclewis.mcpatcher.ZipTreeDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

class AddModDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField inputField;
    private JButton browseButton;
    private JTable fileTable;
    private JButton addButton;
    private JButton removeButton;
    private JScrollPane fileTableScrollPane;
    private ZipFile zipFile;
    private ZipTreeDialog zipDialog;
    private HashMap<String, String> fileMap;
    private ExternalMod mod;
    private boolean editMode;

    AddModDialog(JPanel parent) {
        this(parent, null);
    }

    AddModDialog(final JPanel parent, ExternalMod mod) {
        this.$$$setupUI$$$();
        this.fileMap = new HashMap();
        if (mod != null) {
            this.mod = mod;
            this.editMode = true;
            this.zipFile = mod.zipFile;
            this.inputField.setText(this.zipFile.getName());
            this.fileMap.putAll(mod.fileMap);
        }
        MainForm.setIconImage(this);
        this.setContentPane(this.contentPane);
        this.setTitle("Add external mod");
        this.setMinimumSize(new Dimension(512, 512));
        this.setResizable(true);
        this.setModal(true);
        this.pack();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AddModDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.showBrowseDialog(parent);
            }
        });
        this.fileTableScrollPane.getViewport().setBackground(this.fileTable.getBackground());
        this.fileTable.setModel(new FileTableModel());
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.showZipDialog(true);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int rowIndex;
                FileTableModel model = (FileTableModel)AddModDialog.this.fileTable.getModel();
                while ((rowIndex = AddModDialog.this.fileTable.getSelectedRow()) >= 0) {
                    Map.Entry<String, String> row = model.getRow(rowIndex);
                    if (row == null) continue;
                    AddModDialog.this.fileMap.remove(row.getKey());
                    model.fireTableRowsDeleted(rowIndex, rowIndex);
                }
            }
        });
        this.updateControls();
    }

    public void dispose() {
        this.hideZipDialog();
        if (!this.editMode) {
            MCPatcherUtils.close(this.zipFile);
        }
        this.zipFile = null;
        super.dispose();
    }

    private void onOK() {
        if (this.zipFile == null || this.fileMap == null) {
            this.onCancel();
            return;
        }
        if (this.mod == null) {
            this.mod = new ExternalMod(this.zipFile, this.fileMap);
        } else {
            this.mod.setFileMap(this.fileMap);
        }
        this.zipFile = null;
        this.dispose();
    }

    private void onCancel() {
        this.mod = null;
        this.dispose();
    }

    private void updateControls() {
        boolean exists = new File(this.inputField.getText()).exists();
        this.browseButton.setVisible(!this.editMode);
        this.addButton.setEnabled(exists);
        this.removeButton.setEnabled(exists);
    }

    boolean showBrowseDialog(JPanel parent) {
        File lastModDir;
        JFileChooser fd = new JFileChooser();
        fd.setFileSelectionMode(0);
        fd.setFileHidingEnabled(false);
        fd.setDialogTitle("Select mod zip file");
        File defaultModDir = null;
        try {
            String modDirString = MCPatcherUtils.getString("lastModDirectory", "");
            lastModDir = new File(modDirString);
            String version = MCPatcher.minecraft.getVersion().getVersionString();
            defaultModDir = MCPatcherUtils.getMinecraftPath("mods", version);
            if (modDirString.equals("")) {
                defaultModDir.mkdirs();
                fd.setCurrentDirectory(defaultModDir);
            } else if (lastModDir.isDirectory()) {
                fd.setCurrentDirectory(lastModDir);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        fd.setAcceptAllFileFilterUsed(false);
        fd.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                String filename = f.getName().toLowerCase();
                return f.isDirectory() || filename.endsWith(".zip");
            }

            public String getDescription() {
                return "*.zip";
            }
        });
        if (fd.showOpenDialog(parent) == 0) {
            File file = fd.getSelectedFile();
            this.inputField.setText(file.getPath());
            lastModDir = file.getParentFile();
            if (lastModDir.equals(defaultModDir)) {
                MCPatcherUtils.set("lastModDirectory", "");
            } else {
                MCPatcherUtils.set("lastModDirectory", lastModDir.getAbsolutePath());
            }
            this.fileMap.clear();
            MCPatcherUtils.close(this.zipFile);
            this.zipFile = null;
            ((FileTableModel)this.fileTable.getModel()).fireTableDataChanged();
            this.showZipDialog(false);
        }
        this.updateControls();
        return this.zipFile != null && !this.fileMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showZipDialog(boolean addMode) {
        this.hideZipDialog();
        File inputFile = new File(this.inputField.getText());
        try {
            String newPrefix;
            this.zipFile = new ZipFile(inputFile);
            this.zipDialog = new ZipTreeDialog(this.zipFile);
            if (addMode || this.zipDialog.hasSubfolders()) {
                this.zipDialog.setLocationRelativeTo(this);
                this.zipDialog.setVisible(true);
            }
            if ((newPrefix = this.zipDialog.getPrefix()) != null) {
                this.addFiles(newPrefix);
            }
        }
        catch (IOException e) {
            this.inputField.setText("");
            JOptionPane.showMessageDialog(null, "There was an error reading\n" + inputFile.getPath() + "\n" + e.toString(), "Error reading zip file", 0);
            Logger.log(e);
        }
        finally {
            this.hideZipDialog();
            this.updateControls();
        }
    }

    private void hideZipDialog() {
        if (this.zipDialog != null) {
            this.zipDialog.setVisible(false);
            this.zipDialog.dispose();
            this.zipDialog = null;
        }
    }

    private void addFiles(String prefix) {
        boolean changed = false;
        for (ZipEntry zipEntry : Collections.list(this.zipFile.entries())) {
            String suffix;
            String name = zipEntry.getName();
            if (zipEntry.isDirectory() || !name.startsWith(prefix) || MinecraftJar.isGarbageFile(suffix = name.substring(prefix.length()))) continue;
            this.fileMap.put(suffix, name);
            changed = true;
        }
        if (changed) {
            ((DefaultTableModel)this.fileTable.getModel()).fireTableDataChanged();
        }
    }

    ExternalMod getMod() {
        return this.mod;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JTable jTable;
        JScrollPane jScrollPane;
        JButton jButton3;
        JTextField jTextField;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton5 = new JButton();
        jButton5.setText("OK");
        jPanel3.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton4 = new JButton();
        jButton4.setText("Cancel");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select mod", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setToolTipText("Path to zip file containing mod");
        jLabel.setText("Mod");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.inputField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jTextField.setColumns(35);
        ((Component)jTextField).setEnabled(true);
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.browseButton = jButton3 = new JButton();
        jButton3.setText("Browse");
        jButton3.setMnemonic('B');
        jButton3.setDisplayedMnemonicIndex(0);
        jButton3.setToolTipText("Select mod zip file");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Files to insert", 0, 0, null, null));
        this.fileTableScrollPane = jScrollPane = new JScrollPane();
        jPanel5.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.fileTable = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 300));
        jScrollPane.setViewportView(jTable);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.addButton = jButton2 = new JButton();
        jButton2.setText("");
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        jButton2.setToolTipText("Select a set of files to add");
        jPanel6.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.removeButton = jButton = new JButton();
        jButton.setText("");
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/remove.png")));
        jButton.setToolTipText("Remove the selected file");
        jPanel6.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FileTableModel
    extends DefaultTableModel {
        FileTableModel() {
            super(new Object[]{"From", "To"}, 0);
        }

        @Override
        public int getRowCount() {
            return AddModDialog.this.fileMap.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        Map.Entry<String, String> getRow(int rowIndex) {
            ArrayList list = new ArrayList();
            list.addAll(AddModDialog.this.fileMap.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            if (rowIndex >= 0 && rowIndex < list.size()) {
                return (Map.Entry)list.get(rowIndex);
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map.Entry<String, String> entry = this.getRow(rowIndex);
            if (entry != null) {
                switch (columnIndex) {
                    case 0: {
                        return entry.getValue();
                    }
                    case 1: {
                        return entry.getKey();
                    }
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

